/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.rest.services;

import com.jaspersoft.jasperserver.remote.ServiceException;
import com.jaspersoft.jasperserver.remote.services.DeleteService;
import com.jaspersoft.jasperserver.remote.services.GetService;
import com.jaspersoft.jasperserver.rest.RESTAbstractService;
import com.jaspersoft.jasperserver.rest.RESTUtils;
import com.jaspersoft.jasperserver.ws.scheduling.Job;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.Marshaller;
import org.exolab.castor.xml.ValidationException;

public class RESTJob
extends RESTAbstractService {
    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServiceException {
        try {
            long jobId = this.getJobId(RESTUtils.extractRepositoryUri(req.getPathInfo()));
            GetService service = new GetService(this.context);
            Job job = service.getJob(jobId);
            StringWriter stringWriter = new StringWriter();
            Marshaller marshaller = new Marshaller((Writer)stringWriter);
            marshaller.marshal((Object)job);
            String xml = stringWriter.toString();
            RESTUtils.setStatusAndBody(200, resp, xml);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (MarshalException e) {
            e.printStackTrace();
        }
        catch (ValidationException e) {
            e.printStackTrace();
        }
    }

    protected void doDelete(HttpServletRequest req, HttpServletResponse resp) throws ServiceException {
        long jobId = this.getJobId(RESTUtils.extractRepositoryUri(req.getPathInfo()));
        DeleteService service = new DeleteService(this.context);
        service.deleteJob(jobId);
        Marshaller m = new Marshaller();
        Object xml = null;
        RESTUtils.setStatusAndBody(200, resp, "");
    }

    private long getJobId(String uri) throws ServiceException {
        if (uri == null) {
            throw new ServiceException(400, "malformed input parameter");
        }
        String jobId = uri.replace("/", "");
        return Long.parseLong(jobId);
    }
}

