/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.rest.model;

import java.util.Map;
import javax.activation.DataSource;
import net.sf.jasperreports.engine.JasperPrint;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Report {
    private String uuid;
    private String originalUri;
    private JasperPrint jasperPrint;
    private Map<String, DataSource> attachments;

    public String toXml() {
        StringBuilder xml = new StringBuilder();
        xml.append("<report>\n");
        xml.append("\t").append("<uuid>").append(this.getUuid()).append("</uuid>\n");
        xml.append("\t").append("<originalUri>").append(this.getOriginalUri()).append("</originalUri>\n");
        xml.append("\t").append("<totalPages>").append(this.getJasperPrint().getPages().size()).append("</totalPages>\n");
        xml.append("\t").append("<startPage>").append(1).append("</startPage>\n");
        xml.append("\t").append("<endPage>").append(this.getJasperPrint().getPages().size()).append("</endPage>\n");
        if (this.getAttachments() != null) {
            for (String name : this.getAttachments().keySet()) {
                DataSource ds = this.getAttachments().get(name);
                xml.append("\t").append("<file type=\"").append(ds.getContentType()).append("\"><![CDATA[").append(name).append("]]></file>\n");
            }
        }
        xml.append("</report>");
        return xml.toString();
    }

    public String getUuid() {
        return this.uuid;
    }

    public void setUuid(String uuid) {
        this.uuid = uuid;
    }

    public JasperPrint getJasperPrint() {
        return this.jasperPrint;
    }

    public void setJasperPrint(JasperPrint jasperPrint) {
        this.jasperPrint = jasperPrint;
    }

    public Map<String, DataSource> getAttachments() {
        return this.attachments;
    }

    public void setAttachments(Map<String, DataSource> attachments) {
        this.attachments = attachments;
    }

    public String getOriginalUri() {
        return this.originalUri;
    }

    public void setOriginalUri(String originalUri) {
        this.originalUri = originalUri;
    }
}

