/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.ws.axis2.repository;

import com.jaspersoft.jasperserver.api.metadata.common.domain.FileResource;
import com.jaspersoft.jasperserver.api.metadata.common.domain.InputControl;
import com.jaspersoft.jasperserver.api.metadata.common.domain.Resource;
import com.jaspersoft.jasperserver.api.metadata.common.domain.ResourceReference;
import com.jaspersoft.jasperserver.api.metadata.jasperreports.domain.ReportDataSource;
import com.jaspersoft.jasperserver.api.metadata.jasperreports.domain.ReportUnit;
import com.jaspersoft.jasperserver.api.metadata.olap.domain.XMLAConnection;
import com.jaspersoft.jasperserver.api.metadata.xml.domain.impl.ResourceDescriptor;
import com.jaspersoft.jasperserver.ws.axis2.RepositoryServiceContext;
import com.jaspersoft.jasperserver.ws.axis2.ServiceRequest;
import com.jaspersoft.jasperserver.ws.axis2.WSException;
import com.jaspersoft.jasperserver.ws.axis2.repository.RepositoryResourceHandler;
import com.jaspersoft.jasperserver.ws.axis2.repository.SubResourceHandler;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ReportUnitHandler
extends RepositoryResourceHandler
implements SubResourceHandler {
    private static final Log log = LogFactory.getLog(ReportUnitHandler.class);
    public static final String OPTION_REPORT_UNIT_CONTENTS = "ReportUnitContents";

    public Class getResourceType() {
        return ReportUnit.class;
    }

    protected void doDescribe(Resource resource, ResourceDescriptor descriptor, Map arguments, RepositoryServiceContext serviceContext) throws WSException {
        Boolean reportUnitContent;
        ReportUnit reportUnit = (ReportUnit)resource;
        descriptor.setWsType("reportUnit");
        descriptor.setResourceProperty("PROP_RU_ALWAYS_PROPMT_CONTROLS", reportUnit.isAlwaysPromptControls());
        descriptor.setResourceProperty("PROP_RU_CONTROLS_LAYOUT", (int)reportUnit.getControlsLayout());
        if (reportUnit.getInputControlRenderingView() != null) {
            descriptor.setResourceProperty("PROP_RU_INPUTCONTROL_RENDERING_VIEW", reportUnit.getInputControlRenderingView());
        }
        if (reportUnit.getReportRenderingView() != null) {
            descriptor.setResourceProperty("PROP_RU_REPORT_RENDERING_VIEW", reportUnit.getReportRenderingView());
        }
        Boolean bl = reportUnitContent = arguments == null ? null : (Boolean)arguments.get(OPTION_REPORT_UNIT_CONTENTS);
        if (reportUnitContent != null && reportUnitContent.booleanValue()) {
            List resources;
            List inputControls;
            ResourceReference ruDataSource = reportUnit.getDataSource();
            if (ruDataSource != null) {
                if (ruDataSource.isLocal()) {
                    ResourceDescriptor dsDescriptor = serviceContext.createResourceDescriptor(ruDataSource.getLocalResource());
                    descriptor.getChildren().add(dsDescriptor);
                } else {
                    ResourceDescriptor rdDs = new ResourceDescriptor();
                    rdDs.setWsType("datasource");
                    rdDs.setReferenceUri(ruDataSource.getReferenceURI());
                    rdDs.setIsReference(true);
                    descriptor.getChildren().add(rdDs);
                }
            }
            ResourceReference ruMainReportResourceResourceReference = reportUnit.getMainReport();
            ResourceDescriptor ruMainReportResourceDescriptor = null;
            if (ruMainReportResourceResourceReference != null) {
                if (ruMainReportResourceResourceReference.isLocal()) {
                    ruMainReportResourceDescriptor = serviceContext.createResourceDescriptor(ruMainReportResourceResourceReference.getLocalResource());
                } else {
                    ruMainReportResourceDescriptor = serviceContext.createResourceDescriptor(ruMainReportResourceResourceReference.getReferenceURI());
                    ruMainReportResourceDescriptor.setReferenceUri(ruMainReportResourceResourceReference.getReferenceURI());
                    ruMainReportResourceDescriptor.setIsReference(true);
                }
                ruMainReportResourceDescriptor.setMainReport(true);
                descriptor.getChildren().add(ruMainReportResourceDescriptor);
            }
            if (ruMainReportResourceResourceReference != null) {
                ruMainReportResourceDescriptor = ruMainReportResourceResourceReference.isLocal() ? serviceContext.createResourceDescriptor(ruMainReportResourceResourceReference.getLocalResource()) : serviceContext.createResourceDescriptor(ruMainReportResourceResourceReference.getReferenceURI());
                ruMainReportResourceDescriptor.setMainReport(true);
                descriptor.getChildren().add(ruMainReportResourceDescriptor);
            }
            if ((inputControls = reportUnit.getInputControls()) != null && !inputControls.isEmpty()) {
                for (ResourceReference resRef : inputControls) {
                    ResourceDescriptor ruResourceDescriptor = null;
                    ruResourceDescriptor = resRef.isLocal() ? serviceContext.createResourceDescriptor(resRef.getLocalResource()) : serviceContext.createResourceDescriptor(resRef.getReferenceURI());
                    if (ruResourceDescriptor == null) continue;
                    descriptor.getChildren().add(ruResourceDescriptor);
                }
            }
            if ((resources = reportUnit.getResources()) != null && !resources.isEmpty()) {
                for (ResourceReference resRef : resources) {
                    ResourceDescriptor ruResourceDescriptor = null;
                    ruResourceDescriptor = resRef.isLocal() ? serviceContext.createResourceDescriptor(resRef.getLocalResource()) : serviceContext.createResourceDescriptor(resRef.getReferenceURI());
                    if (ruResourceDescriptor == null || ruMainReportResourceDescriptor.getUriString().equals(ruResourceDescriptor.getUriString())) continue;
                    descriptor.getChildren().add(ruResourceDescriptor);
                }
            }
        }
    }

    protected void updateResource(Resource resource, ResourceDescriptor descriptor, RepositoryServiceContext serviceContext) throws WSException {
        String renderingView;
        String controlsView;
        Integer controlsLayout;
        ReportUnit reportUnit = (ReportUnit)resource;
        Boolean alwaysPrompt = descriptor.getResourcePropertyValueAsBoolean("PROP_RU_ALWAYS_PROPMT_CONTROLS");
        if (alwaysPrompt != null) {
            reportUnit.setAlwaysPromptControls(alwaysPrompt.booleanValue());
        }
        if ((controlsLayout = descriptor.getResourcePropertyValueAsInteger("PROP_RU_CONTROLS_LAYOUT")) != null) {
            reportUnit.setControlsLayout(controlsLayout.byteValue());
        }
        if ((controlsView = descriptor.getResourcePropertyValue("PROP_RU_INPUTCONTROL_RENDERING_VIEW")) != null) {
            reportUnit.setInputControlRenderingView(controlsView);
        }
        if ((renderingView = descriptor.getResourcePropertyValue("PROP_RU_REPORT_RENDERING_VIEW")) != null) {
            reportUnit.setReportRenderingView(renderingView);
        }
        List children = descriptor.getChildren();
        for (int i = 0; i < children.size(); ++i) {
            ResourceDescriptor childResource = (ResourceDescriptor)children.get(i);
            if (serviceContext.getHandlerRegistry().typeExtends(childResource.getWsType(), "datasource")) {
                if (childResource.getIsReference()) {
                    reportUnit.setDataSourceReference(childResource.getReferenceUri());
                    continue;
                }
                ReportDataSource dataSource = (ReportDataSource)this.toChildResource(childResource, serviceContext);
                reportUnit.setDataSource(dataSource);
                continue;
            }
            if (!childResource.getWsType().equals("jrxml") || !childResource.isMainReport()) continue;
            String referenceURI = childResource.getReferenceUri();
            if (referenceURI != null && referenceURI.trim().length() > 0) {
                reportUnit.setMainReportReference(referenceURI);
                continue;
            }
            FileResource fileResource = (FileResource)this.toChildResource(childResource, serviceContext);
            fileResource.setFileType("jrxml");
            reportUnit.setMainReport(fileResource);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Resource setSubResource(Resource parent, ServiceRequest request) throws WSException {
        ReportUnit reportUnit = (ReportUnit)parent;
        ResourceDescriptor descriptor = request.getRequestDescriptor();
        ReportDataSource subResource = null;
        if (descriptor.getIsNew()) {
            String wsType = descriptor.getWsType();
            if (wsType.equals("reportUnit")) return subResource;
            if (request.getContext().getHandlerRegistry().typeExtends(wsType, "datasource")) {
                ReportDataSource datasource = (ReportDataSource)this.toChildResource(descriptor, request.getContext());
                reportUnit.setDataSource(datasource);
                return datasource;
            }
            if (wsType.equals("dataType")) {
                throw new WSException(2, request.getContext().getMessage("webservices.error.addingDTtoRU", null));
            }
            if (wsType.equals("lov")) {
                throw new WSException(2, request.getContext().getMessage("webservices.error.addingLOVtoRU", null));
            }
            if (wsType.equals("query")) {
                throw new WSException(2, request.getContext().getMessage("webservices.error.addingQuerytoRU", null));
            }
            if (wsType.equals("olapXmlaCon")) {
                XMLAConnection datasource = (XMLAConnection)this.toChildResource(descriptor, request.getContext());
                reportUnit.setDataSource((ReportDataSource)datasource);
                return datasource;
            }
            if (wsType.equals("reference") || wsType.equals("img") || wsType.equals("font") || wsType.equals("jar") || wsType.equals("jrxml") || wsType.equals("prop") || wsType.equals("jrtx")) {
                FileResource fileResource = (FileResource)this.toChildResource(descriptor, request.getContext());
                reportUnit.addResource(fileResource);
                return fileResource;
            }
            if (!wsType.equals("inputControl")) throw new WSException(6, request.getContext().getMessage("webservices.error.generic.not.supported", null));
            if (descriptor.getIsReference()) {
                String referenceUri = descriptor.getReferenceUri();
                log.info((Object)("Adding control to RU: " + referenceUri));
                InputControl inputControl = (InputControl)request.getContext().getRepository().getResource(null, referenceUri, InputControl.class);
                if (inputControl == null) {
                    throw new WSException(3, request.getContext().getMessage("webservices.error.resourceNotFoundOrInvalid", new Object[]{referenceUri}));
                }
                reportUnit.addInputControlReference(referenceUri);
                return inputControl;
            }
            InputControl inputControl = (InputControl)this.toChildResource(descriptor, request.getContext());
            reportUnit.addInputControl(inputControl);
            return inputControl;
        }
        FileResource resource = (FileResource)this.getReportUnitResource(descriptor, reportUnit, request.getContext());
        if (resource == null) {
            throw new WSException(2, "webservices.error.resourceNotFound");
        }
        RepositoryResourceHandler handler = (RepositoryResourceHandler)request.getContext().getHandlerRegistry().getHandler(descriptor.getWsType());
        handler.copyToResource((Resource)resource, descriptor, request.getContext());
        if (!descriptor.isMainReport()) return resource;
        if (!reportUnit.getMainReport().isLocal()) return resource;
        reportUnit.setMainReport(resource);
        return resource;
    }

    private Resource getReportUnitResource(ResourceDescriptor descriptor, ReportUnit reportUnit, RepositoryServiceContext serviceContext) {
        Resource resource = null;
        if (descriptor.isMainReport()) {
            ResourceReference resRef = reportUnit.getMainReport();
            Resource jrxmlResource = null;
            jrxmlResource = resRef.isLocal() ? resRef.getLocalResource() : serviceContext.getRepository().getResource(null, resRef.getReferenceURI());
            resource = jrxmlResource;
        } else {
            List resources = reportUnit.getResources();
            for (int i = 0; i < resources.size(); ++i) {
                ResourceReference resRef = (ResourceReference)resources.get(i);
                Resource genericResource = null;
                genericResource = resRef.isLocal() ? resRef.getLocalResource() : serviceContext.getRepository().getResource(null, resRef.getReferenceURI());
                if (!genericResource.getURIString().equals(descriptor.getUriString())) continue;
                resource = genericResource;
                break;
            }
        }
        return resource;
    }

    public void deleteSubResource(Resource parent, ResourceDescriptor childDescriptor, RepositoryServiceContext serviceContext) throws WSException {
        ReportUnit reportUnit = (ReportUnit)parent;
        if (childDescriptor.isMainReport()) {
            throw new WSException(2, serviceContext.getMessage("webservices.error.deletingMainJrxml", null));
        }
        log.debug((Object)("Delete: resource in reportUnit: " + childDescriptor.getWsType()));
        if (childDescriptor.getWsType().equals("inputControl")) {
            List resources = reportUnit.getInputControls();
            for (int i = 0; i < resources.size(); ++i) {
                ResourceReference resRef = (ResourceReference)resources.get(i);
                if (resRef.isLocal() && childDescriptor.getName().equals(resRef.getLocalResource().getName())) {
                    reportUnit.removeInputControl(i);
                } else {
                    if (resRef.isLocal() || !childDescriptor.getUriString().equals(resRef.getReferenceURI())) continue;
                    reportUnit.removeInputControl(i);
                }
                break;
            }
        } else {
            List resources = reportUnit.getResources();
            for (int i = 0; i < resources.size(); ++i) {
                ResourceReference resRef = (ResourceReference)resources.get(i);
                if (resRef.isLocal() && childDescriptor.getName().equals(resRef.getLocalResource().getName())) {
                    reportUnit.removeResourceLocal(resRef.getLocalResource().getName());
                } else {
                    if (resRef.isLocal() || !childDescriptor.getUriString().equals(resRef.getReferenceURI())) continue;
                    reportUnit.removeResourceReference(childDescriptor.getUriString());
                }
                break;
            }
        }
        serviceContext.getRepository().saveResource(null, (Resource)reportUnit);
    }
}

