/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.ws.axis2.authority;

import com.jaspersoft.jasperserver.api.metadata.user.domain.Role;
import com.jaspersoft.jasperserver.api.metadata.user.domain.User;
import com.jaspersoft.jasperserver.api.metadata.user.domain.client.RoleImpl;
import com.jaspersoft.jasperserver.ws.authority.WSRole;
import com.jaspersoft.jasperserver.ws.axis2.authority.UserBeanTraslator;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RoleBeanTraslator {
    public static WSRole toWSRole(Role role) {
        WSRole wsRole = new WSRole();
        wsRole.setRoleName(role.getRoleName());
        wsRole.setExternallyDefined(Boolean.valueOf(role.isExternallyDefined()));
        wsRole.setTenantId(role.getTenantId());
        if (role.getUsers() != null) {
            wsRole.setUsers(UserBeanTraslator.toWSUserArray(role.getUsers()));
        }
        return wsRole;
    }

    public static Role toRole(WSRole wsRole) {
        RoleImpl role = new RoleImpl();
        role.setRoleName(wsRole.getRoleName());
        if (wsRole.getExternallyDefined() == null) {
            role.setExternallyDefined(false);
        } else {
            role.setExternallyDefined(wsRole.getExternallyDefined().booleanValue());
        }
        role.setTenantId(wsRole.getTenantId());
        if (wsRole.getUsers() != null) {
            List<User> users = UserBeanTraslator.toUserList(wsRole.getUsers());
            for (User u : users) {
                role.addUser(u);
            }
        }
        return role;
    }

    public static WSRole[] toWSRoleArray(List roles) {
        ArrayList<WSRole> wsRoles = new ArrayList<WSRole>();
        for (Object o : roles) {
            Role r = (Role)o;
            wsRoles.add(RoleBeanTraslator.toWSRole(r));
        }
        return wsRoles.toArray(new WSRole[wsRoles.size()]);
    }

    public static WSRole[] toWSRoleArray(Set roles) {
        ArrayList<WSRole> wsRoles = new ArrayList<WSRole>();
        for (Object o : roles) {
            Role r = (Role)o;
            wsRoles.add(RoleBeanTraslator.toWSRole(r));
        }
        return wsRoles.toArray(new WSRole[wsRoles.size()]);
    }

    public static List<Role> toRoleList(WSRole[] wsRoles) {
        if (wsRoles == null) {
            return null;
        }
        ArrayList<Role> roleList = new ArrayList<Role>();
        for (WSRole r : wsRoles) {
            roleList.add(RoleBeanTraslator.toRole(r));
        }
        return roleList;
    }

    public static Set<Role> toRoleSet(WSRole[] wsRoles) {
        if (wsRoles == null) {
            return null;
        }
        HashSet<Role> roleSet = new HashSet<Role>();
        for (WSRole r : wsRoles) {
            roleSet.add(RoleBeanTraslator.toRole(r));
        }
        return roleSet;
    }
}

