/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.userdetails.jdbc;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashSet;
import junit.framework.TestCase;
import org.springframework.jdbc.object.MappingSqlQuery;
import org.springframework.security.PopulatedDatabase;
import org.springframework.security.userdetails.UserDetails;
import org.springframework.security.userdetails.UsernameNotFoundException;
import org.springframework.security.userdetails.jdbc.JdbcDaoImpl;

public class JdbcDaoImplTests
extends TestCase {
    public JdbcDaoImplTests() {
    }

    public JdbcDaoImplTests(String arg0) {
        super(arg0);
    }

    private JdbcDaoImpl makePopulatedJdbcDao() throws Exception {
        JdbcDaoImpl dao = new JdbcDaoImpl();
        dao.setDataSource(PopulatedDatabase.getDataSource());
        dao.afterPropertiesSet();
        return dao;
    }

    private JdbcDaoImpl makePopulatedJdbcDaoWithRolePrefix() throws Exception {
        JdbcDaoImpl dao = new JdbcDaoImpl();
        dao.setDataSource(PopulatedDatabase.getDataSource());
        dao.setRolePrefix("ARBITRARY_PREFIX_");
        dao.afterPropertiesSet();
        return dao;
    }

    public void testCheckDaoAccessUserSuccess() throws Exception {
        JdbcDaoImpl dao = this.makePopulatedJdbcDao();
        UserDetails user = dao.loadUserByUsername("rod");
        JdbcDaoImplTests.assertEquals((String)"rod", (String)user.getUsername());
        JdbcDaoImplTests.assertEquals((String)"koala", (String)user.getPassword());
        JdbcDaoImplTests.assertTrue((boolean)user.isEnabled());
        HashSet<String> authorities = new HashSet<String>(2);
        authorities.add(user.getAuthorities()[0].getAuthority());
        authorities.add(user.getAuthorities()[1].getAuthority());
        JdbcDaoImplTests.assertTrue((boolean)authorities.contains("ROLE_TELLER"));
        JdbcDaoImplTests.assertTrue((boolean)authorities.contains("ROLE_SUPERVISOR"));
    }

    public void testCheckDaoOnlyReturnsGrantedAuthoritiesGrantedToUser() throws Exception {
        JdbcDaoImpl dao = this.makePopulatedJdbcDao();
        UserDetails user = dao.loadUserByUsername("scott");
        JdbcDaoImplTests.assertEquals((String)"ROLE_TELLER", (String)user.getAuthorities()[0].getAuthority());
        JdbcDaoImplTests.assertEquals((int)1, (int)user.getAuthorities().length);
    }

    public void testCheckDaoReturnsCorrectDisabledProperty() throws Exception {
        JdbcDaoImpl dao = this.makePopulatedJdbcDao();
        UserDetails user = dao.loadUserByUsername("peter");
        JdbcDaoImplTests.assertTrue((!user.isEnabled() ? 1 : 0) != 0);
    }

    public void testGettersSetters() {
        JdbcDaoImpl dao = new JdbcDaoImpl();
        dao.setAuthoritiesByUsernameQuery("SELECT * FROM FOO");
        JdbcDaoImplTests.assertEquals((String)"SELECT * FROM FOO", (String)dao.getAuthoritiesByUsernameQuery());
        dao.setUsersByUsernameQuery("SELECT USERS FROM FOO");
        JdbcDaoImplTests.assertEquals((String)"SELECT USERS FROM FOO", (String)dao.getUsersByUsernameQuery());
    }

    public void testLookupFailsIfUserHasNoGrantedAuthorities() throws Exception {
        JdbcDaoImpl dao = this.makePopulatedJdbcDao();
        try {
            dao.loadUserByUsername("cooper");
            JdbcDaoImplTests.fail((String)"Should have thrown UsernameNotFoundException");
        }
        catch (UsernameNotFoundException expected) {
            JdbcDaoImplTests.assertEquals((String)"User cooper has no GrantedAuthority", (String)expected.getMessage());
        }
    }

    public void testLookupFailsWithWrongUsername() throws Exception {
        JdbcDaoImpl dao = this.makePopulatedJdbcDao();
        try {
            dao.loadUserByUsername("UNKNOWN_USER");
            JdbcDaoImplTests.fail((String)"Should have thrown UsernameNotFoundException");
        }
        catch (UsernameNotFoundException expected) {
            JdbcDaoImplTests.assertTrue((boolean)true);
        }
    }

    public void testLookupSuccessWithMixedCase() throws Exception {
        JdbcDaoImpl dao = this.makePopulatedJdbcDao();
        JdbcDaoImplTests.assertEquals((String)"koala", (String)dao.loadUserByUsername("rod").getPassword());
        JdbcDaoImplTests.assertEquals((String)"wombat", (String)dao.loadUserByUsername("ScOTt").getPassword());
    }

    public void testRolePrefixWorks() throws Exception {
        JdbcDaoImpl dao = this.makePopulatedJdbcDaoWithRolePrefix();
        JdbcDaoImplTests.assertEquals((String)"ARBITRARY_PREFIX_", (String)dao.getRolePrefix());
        UserDetails user = dao.loadUserByUsername("rod");
        JdbcDaoImplTests.assertEquals((String)"rod", (String)user.getUsername());
        JdbcDaoImplTests.assertEquals((int)2, (int)user.getAuthorities().length);
        HashSet<String> authorities = new HashSet<String>(2);
        authorities.add(user.getAuthorities()[0].getAuthority());
        authorities.add(user.getAuthorities()[1].getAuthority());
        JdbcDaoImplTests.assertTrue((boolean)authorities.contains("ARBITRARY_PREFIX_ROLE_TELLER"));
        JdbcDaoImplTests.assertTrue((boolean)authorities.contains("ARBITRARY_PREFIX_ROLE_SUPERVISOR"));
    }

    public void testGroupAuthoritiesAreLoadedCorrectly() throws Exception {
        JdbcDaoImpl dao = this.makePopulatedJdbcDao();
        dao.setEnableAuthorities(false);
        dao.setEnableGroups(true);
        UserDetails jerry = dao.loadUserByUsername("jerry");
        JdbcDaoImplTests.assertEquals((int)3, (int)jerry.getAuthorities().length);
    }

    public void testDuplicateGroupAuthoritiesAreRemoved() throws Exception {
        JdbcDaoImpl dao = this.makePopulatedJdbcDao();
        dao.setEnableAuthorities(false);
        dao.setEnableGroups(true);
        UserDetails tom = dao.loadUserByUsername("tom");
        JdbcDaoImplTests.assertEquals((int)3, (int)tom.getAuthorities().length);
    }

    public void testStartupFailsIfDataSourceNotSet() throws Exception {
        JdbcDaoImpl dao = new JdbcDaoImpl();
        try {
            dao.afterPropertiesSet();
            JdbcDaoImplTests.fail((String)"Should have thrown IllegalArgumentException");
        }
        catch (IllegalArgumentException expected) {
            JdbcDaoImplTests.assertTrue((boolean)true);
        }
    }

    public void testStartupFailsIfUserMapSetToNull() throws Exception {
        JdbcDaoImpl dao = new JdbcDaoImpl();
        try {
            dao.setDataSource(null);
            dao.afterPropertiesSet();
            JdbcDaoImplTests.fail((String)"Should have thrown IllegalArgumentException");
        }
        catch (IllegalArgumentException expected) {
            JdbcDaoImplTests.assertTrue((boolean)true);
        }
    }

    private class MockMappingSqlQuery
    extends MappingSqlQuery {
        private MockMappingSqlQuery() {
        }

        protected Object mapRow(ResultSet arg0, int arg1) throws SQLException {
            return null;
        }
    }
}

