/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.ui;

import javax.servlet.FilterChain;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import org.springframework.mock.web.MockFilterChain;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.mock.web.MockHttpServletResponse;
import org.springframework.security.Authentication;
import org.springframework.security.context.SecurityContextHolder;
import org.springframework.security.providers.TestingAuthenticationToken;
import org.springframework.security.ui.SessionFixationProtectionFilter;

public class SessionFixationProtectionFilterTests {
    @After
    public void clearContext() {
        SecurityContextHolder.clearContext();
    }

    @Test
    public void newSessionShouldNotBeCreatedIfNoSessionExists() throws Exception {
        SessionFixationProtectionFilter filter = new SessionFixationProtectionFilter();
        MockHttpServletRequest request = new MockHttpServletRequest();
        this.authenticateUser();
        filter.doFilter((ServletRequest)request, (ServletResponse)new MockHttpServletResponse(), (FilterChain)new MockFilterChain());
        Assert.assertNull((Object)request.getSession(false));
    }

    @Test
    public void newSessionBeCreatedIfAuthenticatedOccurredDuringRequest() throws Exception {
        SessionFixationProtectionFilter filter = new SessionFixationProtectionFilter();
        MockHttpServletRequest request = new MockHttpServletRequest();
        String sessionId = request.getSession().getId();
        this.authenticateUser();
        filter.doFilter((ServletRequest)request, (ServletResponse)new MockHttpServletResponse(), (FilterChain)new MockFilterChain());
        Assert.assertFalse((boolean)sessionId.equals(request.getSession().getId()));
    }

    @Test
    public void newSessionShouldNotBeCreatedIfSessionExistsAndUserIsNotAuthenticated() throws Exception {
        SessionFixationProtectionFilter filter = new SessionFixationProtectionFilter();
        MockHttpServletRequest request = new MockHttpServletRequest();
        String sessionId = request.getSession().getId();
        filter.doFilter((ServletRequest)request, (ServletResponse)new MockHttpServletResponse(), (FilterChain)new MockFilterChain());
        Assert.assertEquals((Object)sessionId, (Object)request.getSession().getId());
    }

    @Test
    public void newSessionShouldNotBeCreatedIfUserIsAlreadyAuthenticated() throws Exception {
        SessionFixationProtectionFilter filter = new SessionFixationProtectionFilter();
        MockHttpServletRequest request = new MockHttpServletRequest();
        String sessionId = request.getSession().getId();
        this.authenticateUser();
        request.getSession().setAttribute("SPRING_SECURITY_CONTEXT", (Object)SecurityContextHolder.getContext());
        filter.doFilter((ServletRequest)request, (ServletResponse)new MockHttpServletResponse(), (FilterChain)new MockFilterChain());
        Assert.assertEquals((Object)sessionId, (Object)request.getSession().getId());
    }

    private void authenticateUser() {
        SecurityContextHolder.getContext().setAuthentication((Authentication)new TestingAuthenticationToken("user", "pass"));
    }
}

