/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.securechannel;

import java.io.IOException;
import java.util.Collection;
import java.util.Vector;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import junit.framework.Assert;
import junit.framework.TestCase;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.mock.web.MockHttpServletResponse;
import org.springframework.security.ConfigAttribute;
import org.springframework.security.ConfigAttributeDefinition;
import org.springframework.security.intercept.web.FilterInvocation;
import org.springframework.security.intercept.web.FilterInvocationDefinitionSource;
import org.springframework.security.securechannel.ChannelDecisionManager;
import org.springframework.security.securechannel.ChannelProcessingFilter;

public class ChannelProcessingFilterTests
extends TestCase {
    public void testDetectsMissingChannelDecisionManager() throws Exception {
        ChannelProcessingFilter filter = new ChannelProcessingFilter();
        ConfigAttributeDefinition attr = new ConfigAttributeDefinition("MOCK");
        MockFilterInvocationDefinitionMap fids = new MockFilterInvocationDefinitionMap("/path", attr, true);
        filter.setFilterInvocationDefinitionSource((FilterInvocationDefinitionSource)fids);
        try {
            filter.afterPropertiesSet();
            ChannelProcessingFilterTests.fail((String)"Should have thrown IllegalArgumentException");
        }
        catch (IllegalArgumentException expected) {
            ChannelProcessingFilterTests.assertEquals((String)"channelDecisionManager must be specified", (String)expected.getMessage());
        }
    }

    public void testDetectsMissingFilterInvocationDefinitionSource() throws Exception {
        ChannelProcessingFilter filter = new ChannelProcessingFilter();
        filter.setChannelDecisionManager((ChannelDecisionManager)new MockChannelDecisionManager(false, "MOCK"));
        try {
            filter.afterPropertiesSet();
            ChannelProcessingFilterTests.fail((String)"Should have thrown IllegalArgumentException");
        }
        catch (IllegalArgumentException expected) {
            ChannelProcessingFilterTests.assertEquals((String)"filterInvocationDefinitionSource must be specified", (String)expected.getMessage());
        }
    }

    public void testDetectsSupportedConfigAttribute() throws Exception {
        ChannelProcessingFilter filter = new ChannelProcessingFilter();
        filter.setChannelDecisionManager((ChannelDecisionManager)new MockChannelDecisionManager(false, "SUPPORTS_MOCK_ONLY"));
        ConfigAttributeDefinition attr = new ConfigAttributeDefinition("SUPPORTS_MOCK_ONLY");
        MockFilterInvocationDefinitionMap fids = new MockFilterInvocationDefinitionMap("/path", attr, true);
        filter.setFilterInvocationDefinitionSource((FilterInvocationDefinitionSource)fids);
        filter.afterPropertiesSet();
        ChannelProcessingFilterTests.assertTrue((boolean)true);
    }

    public void testDetectsUnsupportedConfigAttribute() throws Exception {
        ChannelProcessingFilter filter = new ChannelProcessingFilter();
        filter.setChannelDecisionManager((ChannelDecisionManager)new MockChannelDecisionManager(false, "SUPPORTS_MOCK_ONLY"));
        ConfigAttributeDefinition attr = new ConfigAttributeDefinition(new String[]{"SUPPORTS_MOCK_ONLY", "INVALID_ATTRIBUTE"});
        MockFilterInvocationDefinitionMap fids = new MockFilterInvocationDefinitionMap("/path", attr, true);
        filter.setFilterInvocationDefinitionSource((FilterInvocationDefinitionSource)fids);
        try {
            filter.afterPropertiesSet();
            ChannelProcessingFilterTests.fail((String)"Should have thrown IllegalArgumentException");
        }
        catch (IllegalArgumentException expected) {
            ChannelProcessingFilterTests.assertTrue((boolean)expected.getMessage().startsWith("Unsupported configuration attributes:"));
        }
    }

    public void testDoFilterWhenManagerDoesCommitResponse() throws Exception {
        ChannelProcessingFilter filter = new ChannelProcessingFilter();
        filter.setChannelDecisionManager((ChannelDecisionManager)new MockChannelDecisionManager(true, "SOME_ATTRIBUTE"));
        ConfigAttributeDefinition attr = new ConfigAttributeDefinition("SOME_ATTRIBUTE");
        MockFilterInvocationDefinitionMap fids = new MockFilterInvocationDefinitionMap("/path", attr, true);
        filter.setFilterInvocationDefinitionSource((FilterInvocationDefinitionSource)fids);
        MockHttpServletRequest request = new MockHttpServletRequest();
        request.setQueryString("info=now");
        request.setServletPath("/path");
        MockHttpServletResponse response = new MockHttpServletResponse();
        MockFilterChain chain = new MockFilterChain(false);
        filter.doFilter((ServletRequest)request, (ServletResponse)response, (FilterChain)chain);
        ChannelProcessingFilterTests.assertTrue((boolean)true);
    }

    public void testDoFilterWhenManagerDoesNotCommitResponse() throws Exception {
        ChannelProcessingFilter filter = new ChannelProcessingFilter();
        filter.setChannelDecisionManager((ChannelDecisionManager)new MockChannelDecisionManager(false, "SOME_ATTRIBUTE"));
        ConfigAttributeDefinition attr = new ConfigAttributeDefinition("SOME_ATTRIBUTE");
        MockFilterInvocationDefinitionMap fids = new MockFilterInvocationDefinitionMap("/path", attr, true);
        filter.setFilterInvocationDefinitionSource((FilterInvocationDefinitionSource)fids);
        MockHttpServletRequest request = new MockHttpServletRequest();
        request.setQueryString("info=now");
        request.setServletPath("/path");
        MockHttpServletResponse response = new MockHttpServletResponse();
        MockFilterChain chain = new MockFilterChain(true);
        filter.doFilter((ServletRequest)request, (ServletResponse)response, (FilterChain)chain);
        ChannelProcessingFilterTests.assertTrue((boolean)true);
    }

    public void testDoFilterWhenNullConfigAttributeReturned() throws Exception {
        ChannelProcessingFilter filter = new ChannelProcessingFilter();
        filter.setChannelDecisionManager((ChannelDecisionManager)new MockChannelDecisionManager(false, "NOT_USED"));
        ConfigAttributeDefinition attr = new ConfigAttributeDefinition("NOT_USED");
        MockFilterInvocationDefinitionMap fids = new MockFilterInvocationDefinitionMap("/path", attr, true);
        filter.setFilterInvocationDefinitionSource((FilterInvocationDefinitionSource)fids);
        MockHttpServletRequest request = new MockHttpServletRequest();
        request.setQueryString("info=now");
        request.setServletPath("/PATH_NOT_MATCHING_CONFIG_ATTRIBUTE");
        MockHttpServletResponse response = new MockHttpServletResponse();
        MockFilterChain chain = new MockFilterChain(true);
        filter.doFilter((ServletRequest)request, (ServletResponse)response, (FilterChain)chain);
        ChannelProcessingFilterTests.assertTrue((boolean)true);
    }

    public void testDoFilterWithNonHttpServletRequestDetected() throws Exception {
        ChannelProcessingFilter filter = new ChannelProcessingFilter();
        try {
            filter.doFilter(null, (ServletResponse)new MockHttpServletResponse(), (FilterChain)new MockFilterChain());
            ChannelProcessingFilterTests.fail((String)"Should have thrown ServletException");
        }
        catch (ServletException servletException) {
            // empty catch block
        }
    }

    public void testDoFilterWithNonHttpServletResponseDetected() throws Exception {
        ChannelProcessingFilter filter = new ChannelProcessingFilter();
        try {
            filter.doFilter((ServletRequest)new MockHttpServletRequest(null, null), null, (FilterChain)new MockFilterChain());
            ChannelProcessingFilterTests.fail((String)"Should have thrown ServletException");
        }
        catch (ServletException servletException) {
            // empty catch block
        }
    }

    public void testGetterSetters() throws Exception {
        ChannelProcessingFilter filter = new ChannelProcessingFilter();
        filter.setChannelDecisionManager((ChannelDecisionManager)new MockChannelDecisionManager(false, "MOCK"));
        ChannelProcessingFilterTests.assertTrue((filter.getChannelDecisionManager() != null ? 1 : 0) != 0);
        ConfigAttributeDefinition attr = new ConfigAttributeDefinition("MOCK");
        MockFilterInvocationDefinitionMap fids = new MockFilterInvocationDefinitionMap("/path", attr, false);
        filter.setFilterInvocationDefinitionSource((FilterInvocationDefinitionSource)fids);
        ChannelProcessingFilterTests.assertTrue((filter.getFilterInvocationDefinitionSource() != null ? 1 : 0) != 0);
        filter.init(null);
        filter.afterPropertiesSet();
        filter.destroy();
    }

    private class MockFilterInvocationDefinitionMap
    implements FilterInvocationDefinitionSource {
        private ConfigAttributeDefinition toReturn;
        private String servletPath;
        private boolean provideIterator;

        public MockFilterInvocationDefinitionMap(String servletPath, ConfigAttributeDefinition toReturn, boolean provideIterator) {
            this.servletPath = servletPath;
            this.toReturn = toReturn;
            this.provideIterator = provideIterator;
        }

        public ConfigAttributeDefinition getAttributes(Object object) throws IllegalArgumentException {
            FilterInvocation fi = (FilterInvocation)object;
            if (this.servletPath.equals(fi.getHttpRequest().getServletPath())) {
                return this.toReturn;
            }
            return null;
        }

        public Collection getConfigAttributeDefinitions() {
            if (!this.provideIterator) {
                return null;
            }
            Vector<ConfigAttributeDefinition> list = new Vector<ConfigAttributeDefinition>();
            list.add(this.toReturn);
            return list;
        }

        public boolean supports(Class clazz) {
            return true;
        }
    }

    private class MockFilterChain
    implements FilterChain {
        private boolean expectToProceed;

        public MockFilterChain(boolean expectToProceed) {
            this.expectToProceed = expectToProceed;
        }

        private MockFilterChain() {
        }

        public void doFilter(ServletRequest request, ServletResponse response) throws IOException, ServletException {
            if (this.expectToProceed) {
                Assert.assertTrue((boolean)true);
            } else {
                Assert.fail((String)"Did not expect filter chain to proceed");
            }
        }
    }

    private class MockChannelDecisionManager
    implements ChannelDecisionManager {
        private String supportAttribute;
        private boolean commitAResponse;

        public MockChannelDecisionManager(boolean commitAResponse, String supportAttribute) {
            this.commitAResponse = commitAResponse;
            this.supportAttribute = supportAttribute;
        }

        public void decide(FilterInvocation invocation, ConfigAttributeDefinition config) throws IOException, ServletException {
            if (this.commitAResponse) {
                invocation.getHttpResponse().sendRedirect("/redirected");
            }
        }

        public boolean supports(ConfigAttribute attribute) {
            return attribute.getAttribute().equals(this.supportAttribute);
        }
    }
}

