/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.providers.rememberme;

import junit.framework.TestCase;
import junit.textui.TestRunner;
import org.springframework.security.GrantedAuthority;
import org.springframework.security.GrantedAuthorityImpl;
import org.springframework.security.providers.UsernamePasswordAuthenticationToken;
import org.springframework.security.providers.rememberme.RememberMeAuthenticationToken;

public class RememberMeAuthenticationTokenTests
extends TestCase {
    public RememberMeAuthenticationTokenTests() {
    }

    public RememberMeAuthenticationTokenTests(String arg0) {
        super(arg0);
    }

    public static void main(String[] args) {
        TestRunner.run(RememberMeAuthenticationTokenTests.class);
    }

    public final void setUp() throws Exception {
        super.setUp();
    }

    public void testConstructorRejectsNulls() {
        try {
            new RememberMeAuthenticationToken(null, (Object)"Test", new GrantedAuthority[]{new GrantedAuthorityImpl("ROLE_ONE"), new GrantedAuthorityImpl("ROLE_TWO")});
            RememberMeAuthenticationTokenTests.fail((String)"Should have thrown IllegalArgumentException");
        }
        catch (IllegalArgumentException expected) {
            RememberMeAuthenticationTokenTests.assertTrue((boolean)true);
        }
        try {
            new RememberMeAuthenticationToken("key", null, new GrantedAuthority[]{new GrantedAuthorityImpl("ROLE_ONE"), new GrantedAuthorityImpl("ROLE_TWO")});
            RememberMeAuthenticationTokenTests.fail((String)"Should have thrown IllegalArgumentException");
        }
        catch (IllegalArgumentException expected) {
            RememberMeAuthenticationTokenTests.assertTrue((boolean)true);
        }
        try {
            new RememberMeAuthenticationToken("key", (Object)"Test", new GrantedAuthority[]{null});
            RememberMeAuthenticationTokenTests.fail((String)"Should have thrown IllegalArgumentException");
        }
        catch (IllegalArgumentException expected) {
            RememberMeAuthenticationTokenTests.assertTrue((boolean)true);
        }
    }

    public void testEqualsWhenEqual() {
        RememberMeAuthenticationToken token1 = new RememberMeAuthenticationToken("key", (Object)"Test", new GrantedAuthority[]{new GrantedAuthorityImpl("ROLE_ONE"), new GrantedAuthorityImpl("ROLE_TWO")});
        RememberMeAuthenticationToken token2 = new RememberMeAuthenticationToken("key", (Object)"Test", new GrantedAuthority[]{new GrantedAuthorityImpl("ROLE_ONE"), new GrantedAuthorityImpl("ROLE_TWO")});
        RememberMeAuthenticationTokenTests.assertEquals((Object)token1, (Object)token2);
    }

    public void testGetters() {
        RememberMeAuthenticationToken token = new RememberMeAuthenticationToken("key", (Object)"Test", new GrantedAuthority[]{new GrantedAuthorityImpl("ROLE_ONE"), new GrantedAuthorityImpl("ROLE_TWO")});
        RememberMeAuthenticationTokenTests.assertEquals((int)"key".hashCode(), (int)token.getKeyHash());
        RememberMeAuthenticationTokenTests.assertEquals((Object)"Test", (Object)token.getPrincipal());
        RememberMeAuthenticationTokenTests.assertEquals((Object)"", (Object)token.getCredentials());
        RememberMeAuthenticationTokenTests.assertEquals((String)"ROLE_ONE", (String)token.getAuthorities()[0].getAuthority());
        RememberMeAuthenticationTokenTests.assertEquals((String)"ROLE_TWO", (String)token.getAuthorities()[1].getAuthority());
        RememberMeAuthenticationTokenTests.assertTrue((boolean)token.isAuthenticated());
    }

    public void testNoArgConstructorDoesntExist() {
        Class<RememberMeAuthenticationToken> clazz = RememberMeAuthenticationToken.class;
        try {
            clazz.getDeclaredConstructor(null);
            RememberMeAuthenticationTokenTests.fail((String)"Should have thrown NoSuchMethodException");
        }
        catch (NoSuchMethodException expected) {
            RememberMeAuthenticationTokenTests.assertTrue((boolean)true);
        }
    }

    public void testNotEqualsDueToAbstractParentEqualsCheck() {
        RememberMeAuthenticationToken token1 = new RememberMeAuthenticationToken("key", (Object)"Test", new GrantedAuthority[]{new GrantedAuthorityImpl("ROLE_ONE"), new GrantedAuthorityImpl("ROLE_TWO")});
        RememberMeAuthenticationToken token2 = new RememberMeAuthenticationToken("key", (Object)"DIFFERENT_PRINCIPAL", new GrantedAuthority[]{new GrantedAuthorityImpl("ROLE_ONE"), new GrantedAuthorityImpl("ROLE_TWO")});
        RememberMeAuthenticationTokenTests.assertFalse((boolean)token1.equals((Object)token2));
    }

    public void testNotEqualsDueToDifferentAuthenticationClass() {
        RememberMeAuthenticationToken token1 = new RememberMeAuthenticationToken("key", (Object)"Test", new GrantedAuthority[]{new GrantedAuthorityImpl("ROLE_ONE"), new GrantedAuthorityImpl("ROLE_TWO")});
        UsernamePasswordAuthenticationToken token2 = new UsernamePasswordAuthenticationToken((Object)"Test", (Object)"Password", new GrantedAuthority[]{new GrantedAuthorityImpl("ROLE_ONE"), new GrantedAuthorityImpl("ROLE_TWO")});
        RememberMeAuthenticationTokenTests.assertFalse((boolean)token1.equals((Object)token2));
    }

    public void testNotEqualsDueToKey() {
        RememberMeAuthenticationToken token1 = new RememberMeAuthenticationToken("key", (Object)"Test", new GrantedAuthority[]{new GrantedAuthorityImpl("ROLE_ONE"), new GrantedAuthorityImpl("ROLE_TWO")});
        RememberMeAuthenticationToken token2 = new RememberMeAuthenticationToken("DIFFERENT_KEY", (Object)"Test", new GrantedAuthority[]{new GrantedAuthorityImpl("ROLE_ONE"), new GrantedAuthorityImpl("ROLE_TWO")});
        RememberMeAuthenticationTokenTests.assertFalse((boolean)token1.equals((Object)token2));
    }

    public void testSetAuthenticatedIgnored() {
        RememberMeAuthenticationToken token = new RememberMeAuthenticationToken("key", (Object)"Test", new GrantedAuthority[]{new GrantedAuthorityImpl("ROLE_ONE"), new GrantedAuthorityImpl("ROLE_TWO")});
        RememberMeAuthenticationTokenTests.assertTrue((boolean)token.isAuthenticated());
        token.setAuthenticated(false);
        RememberMeAuthenticationTokenTests.assertTrue((!token.isAuthenticated() ? 1 : 0) != 0);
    }
}

