/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.providers.preauth;

import org.junit.Assert;
import org.junit.Test;
import org.springframework.security.Authentication;
import org.springframework.security.GrantedAuthority;
import org.springframework.security.providers.UsernamePasswordAuthenticationToken;
import org.springframework.security.providers.preauth.PreAuthenticatedAuthenticationProvider;
import org.springframework.security.providers.preauth.PreAuthenticatedAuthenticationToken;
import org.springframework.security.userdetails.AuthenticationUserDetailsService;
import org.springframework.security.userdetails.User;
import org.springframework.security.userdetails.UserDetails;
import org.springframework.security.userdetails.UsernameNotFoundException;

public class PreAuthenticatedAuthenticationProviderTests {
    private static final String SUPPORTED_USERNAME = "dummyUser";

    @Test(expected=IllegalArgumentException.class)
    public final void afterPropertiesSet() {
        PreAuthenticatedAuthenticationProvider provider = new PreAuthenticatedAuthenticationProvider();
        provider.afterPropertiesSet();
    }

    @Test
    public final void authenticateInvalidToken() throws Exception {
        User ud = new User(SUPPORTED_USERNAME, "dummyPwd", true, true, true, true, new GrantedAuthority[0]);
        PreAuthenticatedAuthenticationProvider provider = this.getProvider((UserDetails)ud);
        UsernamePasswordAuthenticationToken request = new UsernamePasswordAuthenticationToken((Object)SUPPORTED_USERNAME, (Object)"dummyPwd");
        Authentication result = provider.authenticate((Authentication)request);
        Assert.assertNull((Object)result);
    }

    @Test
    public final void nullPrincipalReturnsNullAuthentication() throws Exception {
        PreAuthenticatedAuthenticationProvider provider = new PreAuthenticatedAuthenticationProvider();
        PreAuthenticatedAuthenticationToken request = new PreAuthenticatedAuthenticationToken(null, (Object)"dummyPwd");
        Authentication result = provider.authenticate((Authentication)request);
        Assert.assertNull((Object)result);
    }

    @Test
    public final void authenticateKnownUser() throws Exception {
        User ud = new User(SUPPORTED_USERNAME, "dummyPwd", true, true, true, true, new GrantedAuthority[0]);
        PreAuthenticatedAuthenticationProvider provider = this.getProvider((UserDetails)ud);
        PreAuthenticatedAuthenticationToken request = new PreAuthenticatedAuthenticationToken((Object)SUPPORTED_USERNAME, (Object)"dummyPwd");
        Authentication result = provider.authenticate((Authentication)request);
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((Object)result.getPrincipal(), (Object)ud);
    }

    @Test
    public final void authenticateIgnoreCredentials() throws Exception {
        User ud = new User("dummyUser1", "dummyPwd1", true, true, true, true, new GrantedAuthority[0]);
        PreAuthenticatedAuthenticationProvider provider = this.getProvider((UserDetails)ud);
        PreAuthenticatedAuthenticationToken request = new PreAuthenticatedAuthenticationToken((Object)"dummyUser1", (Object)"dummyPwd2");
        Authentication result = provider.authenticate((Authentication)request);
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((Object)result.getPrincipal(), (Object)ud);
    }

    @Test(expected=UsernameNotFoundException.class)
    public final void authenticateUnknownUserThrowsException() throws Exception {
        User ud = new User("dummyUser1", "dummyPwd", true, true, true, true, new GrantedAuthority[0]);
        PreAuthenticatedAuthenticationProvider provider = this.getProvider((UserDetails)ud);
        PreAuthenticatedAuthenticationToken request = new PreAuthenticatedAuthenticationToken((Object)"dummyUser2", (Object)"dummyPwd");
        provider.authenticate((Authentication)request);
    }

    @Test
    public final void supportsArbitraryObject() throws Exception {
        PreAuthenticatedAuthenticationProvider provider = this.getProvider(null);
        Assert.assertFalse((boolean)provider.supports(Authentication.class));
    }

    @Test
    public final void supportsPreAuthenticatedAuthenticationToken() throws Exception {
        PreAuthenticatedAuthenticationProvider provider = this.getProvider(null);
        Assert.assertTrue((boolean)provider.supports(PreAuthenticatedAuthenticationToken.class));
    }

    @Test
    public void getSetOrder() throws Exception {
        PreAuthenticatedAuthenticationProvider provider = this.getProvider(null);
        provider.setOrder(333);
        Assert.assertEquals((long)provider.getOrder(), (long)333L);
    }

    private PreAuthenticatedAuthenticationProvider getProvider(UserDetails aUserDetails) throws Exception {
        PreAuthenticatedAuthenticationProvider result = new PreAuthenticatedAuthenticationProvider();
        result.setPreAuthenticatedUserDetailsService(this.getPreAuthenticatedUserDetailsService(aUserDetails));
        result.afterPropertiesSet();
        return result;
    }

    private AuthenticationUserDetailsService getPreAuthenticatedUserDetailsService(final UserDetails aUserDetails) {
        return new AuthenticationUserDetailsService(){

            public UserDetails loadUserDetails(Authentication token) throws UsernameNotFoundException {
                if (aUserDetails != null && aUserDetails.getUsername().equals(token.getName())) {
                    return aUserDetails;
                }
                throw new UsernameNotFoundException("notfound");
            }
        };
    }
}

