/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.providers.anonymous;

import junit.framework.TestCase;
import org.springframework.security.Authentication;
import org.springframework.security.BadCredentialsException;
import org.springframework.security.GrantedAuthority;
import org.springframework.security.GrantedAuthorityImpl;
import org.springframework.security.providers.TestingAuthenticationToken;
import org.springframework.security.providers.anonymous.AnonymousAuthenticationProvider;
import org.springframework.security.providers.anonymous.AnonymousAuthenticationToken;

public class AnonymousAuthenticationProviderTests
extends TestCase {
    public AnonymousAuthenticationProviderTests() {
    }

    public AnonymousAuthenticationProviderTests(String arg0) {
        super(arg0);
    }

    public void testDetectsAnInvalidKey() throws Exception {
        AnonymousAuthenticationProvider aap = new AnonymousAuthenticationProvider();
        aap.setKey("qwerty");
        AnonymousAuthenticationToken token = new AnonymousAuthenticationToken("WRONG_KEY", (Object)"Test", new GrantedAuthority[]{new GrantedAuthorityImpl("ROLE_ONE"), new GrantedAuthorityImpl("ROLE_TWO")});
        try {
            Authentication result = aap.authenticate((Authentication)token);
            AnonymousAuthenticationProviderTests.fail((String)"Should have thrown BadCredentialsException");
        }
        catch (BadCredentialsException badCredentialsException) {
            // empty catch block
        }
    }

    public void testDetectsMissingKey() throws Exception {
        AnonymousAuthenticationProvider aap = new AnonymousAuthenticationProvider();
        try {
            aap.afterPropertiesSet();
            AnonymousAuthenticationProviderTests.fail((String)"Should have thrown IllegalArgumentException");
        }
        catch (IllegalArgumentException expected) {
            AnonymousAuthenticationProviderTests.assertTrue((boolean)true);
        }
    }

    public void testGettersSetters() throws Exception {
        AnonymousAuthenticationProvider aap = new AnonymousAuthenticationProvider();
        aap.setKey("qwerty");
        aap.afterPropertiesSet();
        AnonymousAuthenticationProviderTests.assertEquals((String)"qwerty", (String)aap.getKey());
    }

    public void testIgnoresClassesItDoesNotSupport() throws Exception {
        AnonymousAuthenticationProvider aap = new AnonymousAuthenticationProvider();
        aap.setKey("qwerty");
        TestingAuthenticationToken token = new TestingAuthenticationToken((Object)"user", (Object)"password", new GrantedAuthority[]{new GrantedAuthorityImpl("ROLE_A")});
        AnonymousAuthenticationProviderTests.assertFalse((boolean)aap.supports(TestingAuthenticationToken.class));
        AnonymousAuthenticationProviderTests.assertNull((Object)aap.authenticate((Authentication)token));
    }

    public void testNormalOperation() throws Exception {
        AnonymousAuthenticationProvider aap = new AnonymousAuthenticationProvider();
        aap.setKey("qwerty");
        AnonymousAuthenticationToken token = new AnonymousAuthenticationToken("qwerty", (Object)"Test", new GrantedAuthority[]{new GrantedAuthorityImpl("ROLE_ONE"), new GrantedAuthorityImpl("ROLE_TWO")});
        Authentication result = aap.authenticate((Authentication)token);
        AnonymousAuthenticationProviderTests.assertEquals((Object)result, (Object)token);
    }

    public void testSupports() {
        AnonymousAuthenticationProvider aap = new AnonymousAuthenticationProvider();
        AnonymousAuthenticationProviderTests.assertTrue((boolean)aap.supports(AnonymousAuthenticationToken.class));
        AnonymousAuthenticationProviderTests.assertFalse((boolean)aap.supports(TestingAuthenticationToken.class));
    }
}

