/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.intercept.web;

import javax.servlet.FilterChain;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.mock.web.MockHttpServletResponse;
import org.springframework.security.ConfigAttributeDefinition;
import org.springframework.security.MockFilterChain;
import org.springframework.security.intercept.web.DefaultFilterInvocationDefinitionSource;
import org.springframework.security.intercept.web.FilterInvocation;
import org.springframework.security.util.AntUrlPathMatcher;
import org.springframework.security.util.InMemoryXmlApplicationContext;
import org.springframework.security.util.UrlMatcher;

public class DefaultFilterInvocationDefinitionSourceTests {
    DefaultFilterInvocationDefinitionSource map;

    @Before
    public void createMap() {
        this.map = new DefaultFilterInvocationDefinitionSource((UrlMatcher)new AntUrlPathMatcher());
        this.map.setStripQueryStringFromUrls(true);
    }

    @Test
    public void convertUrlToLowercaseIsTrueByDefault() {
        Assert.assertTrue((boolean)this.map.isConvertUrlToLowercaseBeforeComparison());
    }

    @Test
    public void lookupNotRequiringExactMatchSuccessIfNotMatching() {
        ConfigAttributeDefinition def = new ConfigAttributeDefinition("ROLE_ONE");
        this.map.addSecureUrl("/secure/super/**", def);
        FilterInvocation fi = this.createFilterInvocation("/SeCuRE/super/somefile.html", null);
        ConfigAttributeDefinition response = this.map.lookupAttributes(fi.getRequestUrl());
        Assert.assertEquals((Object)def, (Object)response);
    }

    @Test
    public void lookupNotRequiringExactMatchSucceedsIfSecureUrlPathContainsUpperCase() {
        ConfigAttributeDefinition def = new ConfigAttributeDefinition("ROLE_ONE");
        this.map.addSecureUrl("/SeCuRE/super/**", def);
        FilterInvocation fi = this.createFilterInvocation("/secure/super/somefile.html", null);
        ConfigAttributeDefinition response = this.map.lookupAttributes(fi.getRequestUrl());
        Assert.assertEquals((Object)def, (Object)response);
    }

    @Test
    public void lookupRequiringExactMatchFailsIfNotMatching() {
        this.map = new DefaultFilterInvocationDefinitionSource((UrlMatcher)new AntUrlPathMatcher(false));
        ConfigAttributeDefinition def = new ConfigAttributeDefinition("ROLE_ONE");
        this.map.addSecureUrl("/secure/super/**", def);
        FilterInvocation fi = this.createFilterInvocation("/SeCuRE/super/somefile.html", null);
        ConfigAttributeDefinition response = this.map.lookupAttributes(fi.getRequestUrl());
        Assert.assertEquals(null, (Object)response);
    }

    @Test
    public void lookupRequiringExactMatchIsSuccessful() {
        this.map = new DefaultFilterInvocationDefinitionSource((UrlMatcher)new AntUrlPathMatcher(false));
        ConfigAttributeDefinition def = new ConfigAttributeDefinition("ROLE_ONE");
        this.map.addSecureUrl("/SeCurE/super/**", def);
        FilterInvocation fi = this.createFilterInvocation("/SeCurE/super/somefile.html", null);
        ConfigAttributeDefinition response = this.map.lookupAttributes(fi.getRequestUrl());
        Assert.assertEquals((Object)def, (Object)response);
    }

    @Test
    public void lookupRequiringExactMatchWithAdditionalSlashesIsSuccessful() {
        ConfigAttributeDefinition def = new ConfigAttributeDefinition("ROLE_ONE");
        this.map.addSecureUrl("/someAdminPage.html**", def);
        FilterInvocation fi = this.createFilterInvocation("/someAdminPage.html?a=/test", null);
        ConfigAttributeDefinition response = this.map.lookupAttributes(fi.getRequestUrl());
        Assert.assertEquals((Object)def, (Object)response);
    }

    @Test(expected=IllegalArgumentException.class)
    public void unknownHttpMethodIsRejected() {
        ConfigAttributeDefinition def = new ConfigAttributeDefinition("ROLE_ONE");
        this.map.addSecureUrl("/someAdminPage.html**", "UNKNOWN", def);
    }

    @Test
    public void httpMethodLookupSucceeds() {
        ConfigAttributeDefinition def = new ConfigAttributeDefinition("ROLE_ONE");
        this.map.addSecureUrl("/somepage**", "GET", def);
        FilterInvocation fi = this.createFilterInvocation("/somepage", "GET");
        ConfigAttributeDefinition attrs = this.map.getAttributes((Object)fi);
        Assert.assertEquals((Object)def, (Object)attrs);
    }

    @Test
    public void requestWithDifferentHttpMethodDoesntMatch() {
        ConfigAttributeDefinition def = new ConfigAttributeDefinition("ROLE_ONE");
        this.map.addSecureUrl("/somepage**", "GET", def);
        FilterInvocation fi = this.createFilterInvocation("/somepage", null);
        ConfigAttributeDefinition attrs = this.map.getAttributes((Object)fi);
        Assert.assertNull((Object)attrs);
    }

    @Test
    public void httpMethodSpecificUrlTakesPrecedence() {
        ConfigAttributeDefinition allMethodDef = new ConfigAttributeDefinition("ROLE_ONE");
        this.map.addSecureUrl("/**", null, allMethodDef);
        ConfigAttributeDefinition postOnlyDef = new ConfigAttributeDefinition("ROLE_TWO");
        this.map.addSecureUrl("/somepage**", "POST", postOnlyDef);
        FilterInvocation fi = this.createFilterInvocation("/somepage", "POST");
        ConfigAttributeDefinition attrs = this.map.getAttributes((Object)fi);
        Assert.assertEquals((Object)postOnlyDef, (Object)attrs);
    }

    @Test
    public void extraQuestionMarkStillMatches() {
        ConfigAttributeDefinition def = new ConfigAttributeDefinition("ROLE_ONE");
        this.map.addSecureUrl("/someAdminPage.html*", def);
        FilterInvocation fi = this.createFilterInvocation("/someAdminPage.html?x=2/aa?y=3", null);
        ConfigAttributeDefinition response = this.map.lookupAttributes(fi.getRequestUrl());
        Assert.assertEquals((Object)def, (Object)response);
        fi = this.createFilterInvocation("/someAdminPage.html??", null);
        response = this.map.lookupAttributes(fi.getRequestUrl());
        Assert.assertEquals((Object)def, (Object)response);
    }

    @Test
    public void xmlMapConfigurationIsSuccessful() {
        InMemoryXmlApplicationContext context = new InMemoryXmlApplicationContext("<b:bean id='fids' class='org.springframework.security.intercept.web.DefaultFilterInvocationDefinitionSource'>    <b:constructor-arg>        <b:bean class='org.springframework.security.util.AntUrlPathMatcher'/>    </b:constructor-arg>    <b:constructor-arg>        <b:map>             <b:entry>               <b:key>                   <b:bean class='org.springframework.security.intercept.web.RequestKey'>                     <b:constructor-arg index='0' value='/**'/>                     <b:constructor-arg index='1' value='GET'/>                   </b:bean>               </b:key>               <b:bean class='org.springframework.security.ConfigAttributeDefinition'>                   <b:constructor-arg value='ROLE_A'/>               </b:bean>             </b:entry>        </b:map>    </b:constructor-arg></b:bean>");
        DefaultFilterInvocationDefinitionSource fids = (DefaultFilterInvocationDefinitionSource)context.getBean("fids");
        ConfigAttributeDefinition cad = fids.lookupAttributes("/anything", "GET");
        Assert.assertNotNull((Object)cad);
        Assert.assertEquals((long)1L, (long)cad.getConfigAttributes().size());
        context.close();
    }

    private FilterInvocation createFilterInvocation(String path, String method) {
        MockHttpServletRequest request = new MockHttpServletRequest();
        request.setRequestURI(null);
        request.setMethod(method);
        request.setServletPath(path);
        return new FilterInvocation((ServletRequest)request, (ServletResponse)new MockHttpServletResponse(), (FilterChain)new MockFilterChain());
    }
}

