/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.acl.basic;

import junit.framework.TestCase;
import junit.textui.TestRunner;
import org.springframework.security.acl.basic.NamedEntityObjectIdentity;
import org.springframework.security.acl.basic.SomeDomain;

public class NamedEntityObjectIdentityTests
extends TestCase {
    public NamedEntityObjectIdentityTests() {
    }

    public NamedEntityObjectIdentityTests(String arg0) {
        super(arg0);
    }

    public static void main(String[] args) {
        TestRunner.run(NamedEntityObjectIdentityTests.class);
    }

    public final void setUp() throws Exception {
        super.setUp();
    }

    public void testConstructionViaReflection() throws Exception {
        SomeDomain domainObject = new SomeDomain();
        domainObject.setId(34);
        NamedEntityObjectIdentity name = new NamedEntityObjectIdentity((Object)domainObject);
        NamedEntityObjectIdentityTests.assertEquals((String)"34", (String)name.getId());
        NamedEntityObjectIdentityTests.assertEquals((String)domainObject.getClass().getName(), (String)name.getClassname());
        name.toString();
    }

    public void testConstructionViaReflectionFailsIfNoGetIdMethod() throws Exception {
        try {
            new NamedEntityObjectIdentity((Object)new Integer(45));
            NamedEntityObjectIdentityTests.fail((String)"Should have thrown IllegalArgumentException");
        }
        catch (IllegalArgumentException expected) {
            NamedEntityObjectIdentityTests.assertTrue((boolean)true);
        }
    }

    public void testConstructionViaReflectionFailsIfNullPassed() throws Exception {
        try {
            new NamedEntityObjectIdentity(null);
            NamedEntityObjectIdentityTests.fail((String)"Should have thrown IllegalArgumentException");
        }
        catch (IllegalArgumentException expected) {
            NamedEntityObjectIdentityTests.assertTrue((boolean)true);
        }
    }

    public void testEquality() {
        NamedEntityObjectIdentity original = new NamedEntityObjectIdentity("foo", "12");
        NamedEntityObjectIdentityTests.assertFalse((boolean)original.equals(null));
        NamedEntityObjectIdentityTests.assertFalse((boolean)original.equals((Object)new Integer(354)));
        NamedEntityObjectIdentityTests.assertFalse((boolean)original.equals((Object)new NamedEntityObjectIdentity("foo", "23232")));
        NamedEntityObjectIdentityTests.assertTrue((boolean)original.equals((Object)new NamedEntityObjectIdentity("foo", "12")));
        NamedEntityObjectIdentityTests.assertTrue((boolean)original.equals((Object)original));
    }

    public void testNoArgConstructorDoesntExist() {
        Class<NamedEntityObjectIdentity> clazz = NamedEntityObjectIdentity.class;
        try {
            clazz.getDeclaredConstructor(null);
            NamedEntityObjectIdentityTests.fail((String)"Should have thrown NoSuchMethodException");
        }
        catch (NoSuchMethodException expected) {
            NamedEntityObjectIdentityTests.assertTrue((boolean)true);
        }
    }

    public void testNormalConstructionRejectedIfInvalidArguments() throws Exception {
        try {
            new NamedEntityObjectIdentity(null, "12");
            NamedEntityObjectIdentityTests.fail((String)"Should have thrown IllegalArgumentException");
        }
        catch (IllegalArgumentException expected) {
            NamedEntityObjectIdentityTests.assertTrue((boolean)true);
        }
        try {
            new NamedEntityObjectIdentity("classname", null);
            NamedEntityObjectIdentityTests.fail((String)"Should have thrown IllegalArgumentException");
        }
        catch (IllegalArgumentException expected) {
            NamedEntityObjectIdentityTests.assertTrue((boolean)true);
        }
        try {
            new NamedEntityObjectIdentity("", "12");
            NamedEntityObjectIdentityTests.fail((String)"Should have thrown IllegalArgumentException");
        }
        catch (IllegalArgumentException expected) {
            NamedEntityObjectIdentityTests.assertTrue((boolean)true);
        }
        try {
            new NamedEntityObjectIdentity("classname", "");
            NamedEntityObjectIdentityTests.fail((String)"Should have thrown IllegalArgumentException");
        }
        catch (IllegalArgumentException expected) {
            NamedEntityObjectIdentityTests.assertTrue((boolean)true);
        }
    }

    public void testNormalOperation() {
        NamedEntityObjectIdentity name = new NamedEntityObjectIdentity("domain", "id");
        NamedEntityObjectIdentityTests.assertEquals((String)"domain", (String)name.getClassname());
        NamedEntityObjectIdentityTests.assertEquals((String)"id", (String)name.getId());
    }
}

