/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.acl;

import java.util.Vector;
import junit.framework.TestCase;
import org.springframework.security.Authentication;
import org.springframework.security.GrantedAuthority;
import org.springframework.security.GrantedAuthorityImpl;
import org.springframework.security.acl.AclEntry;
import org.springframework.security.acl.AclProvider;
import org.springframework.security.acl.AclProviderManager;
import org.springframework.security.acl.basic.AclObjectIdentity;
import org.springframework.security.acl.basic.NamedEntityObjectIdentity;
import org.springframework.security.acl.basic.SimpleAclEntry;
import org.springframework.security.providers.UsernamePasswordAuthenticationToken;

public class AclProviderManagerTests
extends TestCase {
    public AclProviderManagerTests() {
    }

    public AclProviderManagerTests(String arg0) {
        super(arg0);
    }

    private AclProviderManager makeProviderManager() {
        MockProvider provider1 = new MockProvider();
        Vector<MockProvider> providers = new Vector<MockProvider>();
        providers.add(provider1);
        AclProviderManager mgr = new AclProviderManager();
        mgr.setProviders(providers);
        return mgr;
    }

    public final void setUp() throws Exception {
        super.setUp();
    }

    public void testAclLookupFails() {
        AclProviderManager mgr = this.makeProviderManager();
        AclProviderManagerTests.assertNull((Object)mgr.getAcls((Object)new Integer(5)));
    }

    public void testAclLookupForGivenAuthenticationSuccess() {
        AclProviderManager mgr = this.makeProviderManager();
        AclProviderManagerTests.assertNotNull((Object)mgr.getAcls((Object)"STRING", (Authentication)new UsernamePasswordAuthenticationToken((Object)"rod", (Object)"not used")));
    }

    public void testAclLookupSuccess() {
        AclProviderManager mgr = this.makeProviderManager();
        AclProviderManagerTests.assertNotNull((Object)mgr.getAcls((Object)"STRING"));
    }

    public void testRejectsNulls() {
        AclProviderManager mgr = new AclProviderManager();
        try {
            mgr.getAcls(null);
            AclProviderManagerTests.fail((String)"Should have thrown IllegalArgumentException");
        }
        catch (IllegalArgumentException expected) {
            AclProviderManagerTests.assertTrue((boolean)true);
        }
        try {
            mgr.getAcls(null, (Authentication)new UsernamePasswordAuthenticationToken((Object)"rod", (Object)"not used"));
            AclProviderManagerTests.fail((String)"Should have thrown IllegalArgumentException");
        }
        catch (IllegalArgumentException expected) {
            AclProviderManagerTests.assertTrue((boolean)true);
        }
        try {
            mgr.getAcls((Object)"SOME_DOMAIN_INSTANCE", null);
            AclProviderManagerTests.fail((String)"Should have thrown IllegalArgumentException");
        }
        catch (IllegalArgumentException expected) {
            AclProviderManagerTests.assertTrue((boolean)true);
        }
    }

    public void testReturnsNullIfNoSupportingProvider() {
        AclProviderManager mgr = this.makeProviderManager();
        AclProviderManagerTests.assertNull((Object)mgr.getAcls((Object)new Integer(4), (Authentication)new UsernamePasswordAuthenticationToken((Object)"rod", (Object)"not used")));
        AclProviderManagerTests.assertNull((Object)mgr.getAcls((Object)new Integer(4)));
    }

    public void testStartupFailsIfProviderListNotContainingProviders() throws Exception {
        Vector<String> providers = new Vector<String>();
        providers.add("THIS_IS_NOT_A_PROVIDER");
        AclProviderManager mgr = new AclProviderManager();
        try {
            mgr.setProviders(providers);
            AclProviderManagerTests.fail((String)"Should have thrown IllegalArgumentException");
        }
        catch (IllegalArgumentException expected) {
            AclProviderManagerTests.assertTrue((boolean)true);
        }
    }

    public void testStartupFailsIfProviderListNotSet() throws Exception {
        AclProviderManager mgr = new AclProviderManager();
        try {
            mgr.afterPropertiesSet();
            AclProviderManagerTests.fail((String)"Should have thrown IllegalArgumentException");
        }
        catch (IllegalArgumentException expected) {
            AclProviderManagerTests.assertTrue((boolean)true);
        }
    }

    public void testStartupFailsIfProviderListNull() throws Exception {
        AclProviderManager mgr = new AclProviderManager();
        try {
            mgr.setProviders(null);
            AclProviderManagerTests.fail((String)"Should have thrown IllegalArgumentException");
        }
        catch (IllegalArgumentException expected) {
            AclProviderManagerTests.assertTrue((boolean)true);
        }
    }

    public void testSuccessfulStartup() throws Exception {
        AclProviderManager mgr = this.makeProviderManager();
        mgr.afterPropertiesSet();
        AclProviderManagerTests.assertTrue((boolean)true);
        AclProviderManagerTests.assertEquals((int)1, (int)mgr.getProviders().size());
    }

    private class MockProvider
    implements AclProvider {
        private UsernamePasswordAuthenticationToken rod = new UsernamePasswordAuthenticationToken((Object)"rod", (Object)"not used", new GrantedAuthority[]{new GrantedAuthorityImpl("ROLE_FOO"), new GrantedAuthorityImpl("ROLE_BAR")});
        private SimpleAclEntry entry100rod = new SimpleAclEntry(this.rod.getPrincipal(), (AclObjectIdentity)new NamedEntityObjectIdentity("OBJECT", "100"), null, 2);
        private UsernamePasswordAuthenticationToken scott = new UsernamePasswordAuthenticationToken((Object)"scott", (Object)"not used", new GrantedAuthority[]{new GrantedAuthorityImpl("ROLE_FOO"), new GrantedAuthorityImpl("ROLE_MANAGER")});
        private SimpleAclEntry entry100Scott = new SimpleAclEntry(this.scott.getPrincipal(), (AclObjectIdentity)new NamedEntityObjectIdentity("OBJECT", "100"), null, 4);

        private MockProvider() {
        }

        public AclEntry[] getAcls(Object domainInstance, Authentication authentication) {
            if (authentication.getPrincipal().equals(this.scott.getPrincipal())) {
                return new AclEntry[]{this.entry100Scott};
            }
            if (authentication.getPrincipal().equals(this.rod.getPrincipal())) {
                return new AclEntry[]{this.entry100rod};
            }
            return null;
        }

        public AclEntry[] getAcls(Object domainInstance) {
            return new AclEntry[]{this.entry100rod, this.entry100Scott};
        }

        public boolean supports(Object domainInstance) {
            return domainInstance instanceof String;
        }
    }
}

