/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.surefire.report;

import java.io.BufferedOutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import org.apache.maven.surefire.report.AbstractReporter;
import org.apache.maven.surefire.report.ReportEntry;

public class SummaryConsoleReporter
extends AbstractReporter {
    private static final int BUFFER_SIZE = 4096;
    private PrintWriter writer = new PrintWriter(new OutputStreamWriter(new BufferedOutputStream(System.out, 4096)));

    public void writeMessage(String message) {
        this.writer.println(message);
        this.writer.flush();
    }

    public void runStarting(int testCount) {
        this.writer.println();
        this.writer.println("-------------------------------------------------------");
        this.writer.println(" T E S T S");
        this.writer.println("-------------------------------------------------------");
        this.writer.flush();
    }

    public void runAborted(ReportEntry report) {
        this.writer.println("RUN ABORTED");
        this.writer.println(report.getSource().getClass().getName());
        this.writer.println(report.getName());
        this.writer.println(report.getMessage());
        this.writer.println(report.getThrowable().getMessage());
        this.writer.flush();
    }

    public void batteryAborted(ReportEntry report) {
        this.writer.println("BATTERY ABORTED");
        this.writer.println(report.getSource().getClass().getName());
        this.writer.println(report.getName());
        this.writer.println(report.getMessage());
        this.writer.println(report.getThrowable().getMessage());
        this.writer.flush();
    }

    public void batteryCompleted(ReportEntry report) {
        if (this.failures > 0 || this.errors > 0) {
            this.writer.println("[surefire] " + report.getName() + " <<<<<<<< FAILURE !! ");
        }
        this.writer.flush();
        this.completedCount = 0;
        this.errors = 0;
        this.failures = 0;
    }
}

