/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.export.modules.scheduling;

import com.jaspersoft.jasperserver.api.JSValidationException;
import com.jaspersoft.jasperserver.api.engine.scheduling.domain.ReportJob;
import com.jaspersoft.jasperserver.api.engine.scheduling.domain.ReportJobSummary;
import com.jaspersoft.jasperserver.api.metadata.common.domain.ResourceLookup;
import com.jaspersoft.jasperserver.api.metadata.jasperreports.domain.ReportUnit;
import com.jaspersoft.jasperserver.api.metadata.view.domain.FilterCriteria;
import com.jaspersoft.jasperserver.api.metadata.view.domain.FilterElement;
import com.jaspersoft.jasperserver.export.modules.BaseImporterModule;
import com.jaspersoft.jasperserver.export.modules.ImporterModuleContext;
import com.jaspersoft.jasperserver.export.modules.repository.ResourceImporter;
import com.jaspersoft.jasperserver.export.modules.scheduling.SchedulingModuleConfiguration;
import com.jaspersoft.jasperserver.export.modules.scheduling.beans.ReportJobBean;
import com.jaspersoft.jasperserver.export.modules.scheduling.beans.ReportUnitJobsIndexBean;
import com.jaspersoft.jasperserver.export.util.PathUtils;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dom4j.Element;

public class ReportJobsImporter
extends BaseImporterModule {
    private static final Log log = LogFactory.getLog(ResourceImporter.class);
    protected SchedulingModuleConfiguration configuration;
    private String prependPathArg;
    protected String prependPath;
    private Map userIndicator;

    public void init(ImporterModuleContext moduleContext) {
        super.init(moduleContext);
        this.prependPath = this.getPrependPath();
    }

    protected String getPrependPath() {
        String path = this.getParameterValue(this.getPrependPathArg());
        if (path != null) {
            if ((path = PathUtils.normalizePath(path)).length() == 0 || path.equals("/")) {
                path = null;
            } else if (!path.startsWith("/")) {
                path = "/" + path;
            }
        }
        return path;
    }

    public void process() {
        this.initProcess();
        Iterator i = this.indexElement.elementIterator(this.configuration.getIndexReportUnitElement());
        while (i.hasNext()) {
            Element ruElement = (Element)i.next();
            String uri = ruElement.getText();
            this.processReportUnit(uri);
        }
    }

    protected void initProcess() {
        this.userIndicator = new HashMap();
    }

    protected void processReportUnit(String uri) {
        String newUri = this.prependedPath(uri);
        if (this.checkReportUnit(newUri)) {
            if (this.isUpdateResource(newUri)) {
                commandOut.warn("Report " + newUri + " was updated in repository, skipping jobs");
            } else {
                String ruPath = PathUtils.concatPaths(this.configuration.getReportJobsDir(), uri);
                ReportUnitJobsIndexBean indexBean = (ReportUnitJobsIndexBean)this.deserialize(ruPath, this.configuration.getReportUnitIndexFilename(), this.configuration.getSerializer());
                long[] jobIds = indexBean.getJobIds();
                int imported = 0;
                for (int i = 0; i < jobIds.length; ++i) {
                    long jobId = jobIds[i];
                    if (!this.importReportJob(newUri, ruPath, jobId)) continue;
                    ++imported;
                }
                commandOut.info("Created " + imported + " job(s) for report " + newUri);
            }
        } else {
            commandOut.warn("Report unit " + newUri + " not found in repository, skipping jobs");
        }
    }

    protected boolean checkReportUnit(String uri) {
        PathUtils.SplittedPath splittedPath = PathUtils.splitPath(uri);
        FilterCriteria filter = FilterCriteria.createFilter(ReportUnit.class);
        filter.addFilterElement((FilterElement)FilterCriteria.createParentFolderFilter((String)splittedPath.parentPath));
        filter.addFilterElement((FilterElement)FilterCriteria.createPropertyEqualsFilter((String)"name", (Object)splittedPath.name));
        ResourceLookup[] lookups = this.configuration.getRepository().findResource(this.executionContext, filter);
        return lookups != null && lookups.length > 0;
    }

    protected boolean isUpdateResource(String resourceUri) {
        Collection updateResources = (Collection)this.getContextAttributes().getAttribute("updateResources");
        return updateResources != null && updateResources.contains(resourceUri);
    }

    protected boolean importReportJob(String reportUri, String jobsPath, long jobId) {
        boolean imported;
        String jobFilename = this.getJobFilename(jobId);
        ReportJobBean jobBean = (ReportJobBean)this.deserialize(jobsPath, jobFilename, this.configuration.getSerializer());
        if (this.userExists(jobBean.getUsername())) {
            imported = this.importJob(reportUri, jobBean);
        } else {
            commandOut.warn("User " + jobBean.getUsername() + " does not exist, skipping job " + jobBean.getId() + " of report " + reportUri);
            imported = false;
        }
        return imported;
    }

    protected String getJobFilename(long jobId) {
        return jobId + ".xml";
    }

    protected boolean userExists(String username) {
        Boolean indicator = (Boolean)this.userIndicator.get(username);
        if (indicator == null) {
            indicator = this.configuration.getAuthorityService().getUser(this.executionContext, username) != null;
            this.userIndicator.put(username, indicator);
        }
        return indicator;
    }

    protected boolean importJob(String newUri, ReportJobBean jobBean) {
        ReportJob job = new ReportJob();
        jobBean.copyTo(job, newUri, this.getConfiguration());
        List existingJobs = this.configuration.getReportScheduler().getScheduledJobs(this.executionContext, newUri);
        boolean exist = false;
        for (int i = 0; i < existingJobs.size(); ++i) {
            ReportJobSummary rjs = (ReportJobSummary)existingJobs.get(i);
            long rjId = rjs.getId();
            ReportJob rj = this.configuration.getReportScheduler().getScheduledJob(this.executionContext, rjId);
            if (!rj.equals(job)) continue;
            exist = true;
            break;
        }
        if (!exist) {
            try {
                ReportJob savedJob = this.configuration.getInternalReportScheduler().saveJob(this.executionContext, job);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Created job " + savedJob.getId() + " for report " + newUri + " (old id " + jobBean.getId() + ")"));
                }
                return true;
            }
            catch (JSValidationException e) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Skipped job for report " + newUri + " (old id " + jobBean.getId() + "). " + e.getErrors().toString()));
                }
                return false;
            }
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Skipped existing job for report " + newUri + " (old id " + jobBean.getId() + ")"));
        }
        return false;
    }

    protected String prependedPath(String uri) {
        return PathUtils.concatPaths(this.prependPath, uri);
    }

    public SchedulingModuleConfiguration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(SchedulingModuleConfiguration configuration) {
        this.configuration = configuration;
    }

    public String getPrependPathArg() {
        return this.prependPathArg;
    }

    public void setPrependPathArg(String prependPathArg) {
        this.prependPathArg = prependPathArg;
    }
}

