/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.export.modules.mt;

import com.jaspersoft.jasperserver.api.metadata.user.domain.Tenant;
import com.jaspersoft.jasperserver.api.metadata.user.service.TenantService;
import com.jaspersoft.jasperserver.export.modules.BaseExporterModule;
import com.jaspersoft.jasperserver.export.modules.ExporterModuleContext;
import com.jaspersoft.jasperserver.export.modules.mt.TenantModuleConfiguration;
import java.util.LinkedList;
import java.util.Queue;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dom4j.Element;

public class TenantExporter
extends BaseExporterModule {
    private static final Log log = LogFactory.getLog(TenantExporter.class);
    private TenantModuleConfiguration moduleConfiguration;
    private boolean exportTenants;
    protected Queue<String> tenantIdQueue;

    public void init(ExporterModuleContext moduleContext) {
        super.init(moduleContext);
        boolean bl = this.exportTenants = this.exportEverything || this.hasParameter(this.moduleConfiguration.getTenantsArgument());
        if (log.isDebugEnabled()) {
            log.debug((Object)("Exporting tenants: " + this.exportTenants));
        }
        this.tenantIdQueue = new LinkedList<String>();
    }

    protected TenantService getTenantService() {
        return this.moduleConfiguration.getTenantService();
    }

    protected boolean isToProcess() {
        return this.exportTenants;
    }

    public void process() {
        this.mkdir(this.moduleConfiguration.getTenantsDirectory());
        String rootTenantId = this.moduleConfiguration.getTenantExportConfiguration().getRootTenantId();
        Tenant rootTenant = this.getTenantService().getTenant(this.executionContext, rootTenantId);
        if (rootTenant == null) {
            commandOut.info("Root tenant \"" + rootTenantId + "\" not found, skipping tenants");
        } else {
            this.process(rootTenant);
        }
    }

    protected void process(Tenant tenant) {
        commandOut.info("Exporting tenant " + tenant.getId() + " (" + tenant.getTenantUri() + ")");
        this.serialize(tenant, this.moduleConfiguration.getTenantsDirectory(), this.getTenantFileName(tenant), this.moduleConfiguration.getTenantSerializer());
        this.addTenantIndexEntry(tenant);
        this.tenantIdQueue.add(tenant.getId());
    }

    protected String getTenantFileName(Tenant tenant) {
        return tenant.getId() + ".xml";
    }

    protected void addTenantIndexEntry(Tenant tenant) {
        Element indexElement = this.getIndexElement();
        Element tenantElement = indexElement.addElement(this.moduleConfiguration.getTenantIndexElement());
        tenantElement.addText(tenant.getId());
    }

    public TenantModuleConfiguration getModuleConfiguration() {
        return this.moduleConfiguration;
    }

    public void setModuleConfiguration(TenantModuleConfiguration moduleConfiguration) {
        this.moduleConfiguration = moduleConfiguration;
    }
}

