/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.export.modules.auth.beans;

import com.jaspersoft.jasperserver.api.metadata.user.domain.ProfileAttribute;
import com.jaspersoft.jasperserver.api.metadata.user.domain.Role;
import com.jaspersoft.jasperserver.api.metadata.user.domain.User;
import com.jaspersoft.jasperserver.export.modules.auth.AuthorityImportHandler;
import com.jaspersoft.jasperserver.export.modules.common.ProfileAttributeBean;
import com.jaspersoft.jasperserver.export.modules.common.TenantQualifiedName;
import com.jaspersoft.jasperserver.export.util.CommandOut;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class UserBean {
    private static final CommandOut commandOut = CommandOut.getInstance();
    private String username;
    private String fullName;
    private String password;
    private String emailAddress;
    private boolean externallyDefined = false;
    private boolean enabled = false;
    private TenantQualifiedName[] roleNames;
    private ProfileAttributeBean[] attributes;
    private Date previousPasswordChangeTime;
    private String tenantId;

    public void copyFrom(User user) {
        this.setUsername(user.getUsername());
        this.setFullName(user.getFullName());
        this.setPassword(user.getPassword());
        this.setEmailAddress(user.getEmailAddress());
        this.setExternallyDefined(user.isExternallyDefined());
        this.setEnabled(user.isEnabled());
        this.setPreviousPasswordChangeTime(user.getPreviousPasswordChangeTime());
        this.setTenantId(user.getTenantId());
        this.copyRolesFrom(user);
        this.copyAttributesFrom(user);
    }

    protected void copyRolesFrom(User user) {
        TenantQualifiedName[] names;
        Set roles = user.getRoles();
        if (roles != null && !roles.isEmpty()) {
            names = new TenantQualifiedName[roles.size()];
            int c = 0;
            for (Role role : roles) {
                names[c] = new TenantQualifiedName(role.getTenantId(), role.getRoleName());
                ++c;
            }
        } else {
            names = null;
        }
        this.setRoleNames(names);
    }

    public void copyAttributesFrom(User user) {
        List userAttributes = user.getAttributes();
        if (userAttributes == null || userAttributes.isEmpty()) {
            this.attributes = null;
        } else {
            this.attributes = new ProfileAttributeBean[userAttributes.size()];
            int idx = 0;
            for (ProfileAttribute attr : userAttributes) {
                this.attributes[idx] = new ProfileAttributeBean();
                this.attributes[idx].copyFrom(attr);
                ++idx;
            }
        }
    }

    public void copyTo(User user, AuthorityImportHandler importHandler) {
        user.setUsername(this.getUsername());
        user.setFullName(this.getFullName());
        user.setPassword(this.getPassword());
        user.setEmailAddress(this.getEmailAddress());
        user.setExternallyDefined(this.isExternallyDefined());
        user.setEnabled(this.isEnabled());
        user.setPreviousPasswordChangeTime(this.getPreviousPasswordChangeTime());
        user.setTenantId(this.getTenantId());
        this.copyRolesTo(user, importHandler);
    }

    protected void copyRolesTo(User user, AuthorityImportHandler importHandler) {
        HashSet<Role> roles;
        if (this.roleNames == null) {
            roles = null;
        } else {
            roles = new HashSet<Role>();
            for (int i = 0; i < this.roleNames.length; ++i) {
                TenantQualifiedName roleName = this.roleNames[i];
                Role role = importHandler.resolveRole(roleName);
                if (role == null) {
                    commandOut.warn("Role " + roleName.getName() + (roleName.getTenantId() == null ? "" : " of tenant " + roleName.getTenantId()) + " not found while copying user " + this.getUsername() + ", skipping.");
                    continue;
                }
                roles.add(role);
            }
        }
        user.setRoles(roles);
    }

    public String getEmailAddress() {
        return this.emailAddress;
    }

    public void setEmailAddress(String emailAddress) {
        this.emailAddress = emailAddress;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public boolean isExternallyDefined() {
        return this.externallyDefined;
    }

    public void setExternallyDefined(boolean externallyDefined) {
        this.externallyDefined = externallyDefined;
    }

    public String getFullName() {
        return this.fullName;
    }

    public void setFullName(String fullName) {
        this.fullName = fullName;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public TenantQualifiedName[] getRoleNames() {
        return this.roleNames;
    }

    public void setRoleNames(TenantQualifiedName[] roleNames) {
        this.roleNames = roleNames;
    }

    public ProfileAttributeBean[] getAttributes() {
        return this.attributes;
    }

    public void setAttributes(ProfileAttributeBean[] attributes) {
        this.attributes = attributes;
    }

    public Date getPreviousPasswordChangeTime() {
        return this.previousPasswordChangeTime;
    }

    public void setPreviousPasswordChangeTime(Date previousPasswordChangeTime) {
        this.previousPasswordChangeTime = previousPasswordChangeTime;
    }

    public String getTenantId() {
        return this.tenantId;
    }

    public void setTenantId(String tenantId) {
        this.tenantId = tenantId;
    }
}

