/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.export.io;

import com.jaspersoft.jasperserver.api.JSException;
import com.jaspersoft.jasperserver.export.Parameters;
import com.jaspersoft.jasperserver.export.io.FileSystemInput;
import com.jaspersoft.jasperserver.export.io.FileSystemInputManager;
import com.jaspersoft.jasperserver.export.io.ImportInput;
import com.jaspersoft.jasperserver.export.io.ImportInputFactory;
import com.jaspersoft.jasperserver.export.io.PathProcessor;
import com.jaspersoft.jasperserver.export.io.PathProcessorFactory;
import java.util.Properties;

public class FileSystemInputFactory
implements ImportInputFactory,
FileSystemInputManager {
    private String inputDirParameter;
    private PathProcessorFactory pathProcessorFactory;
    private String propertyPathProcessorId;

    public boolean matches(Parameters parameters) {
        return parameters.hasParameter(this.inputDirParameter);
    }

    public ImportInput createInput(Parameters parameters) {
        String rootDir = parameters.getParameterValue(this.inputDirParameter);
        if (rootDir == null) {
            throw new JSException("jsexception.no.import.folder.specified");
        }
        String processorId = this.pathProcessorFactory.getDefaultInputProcessor();
        PathProcessor processor = this.pathProcessorFactory.getProcessor(processorId);
        return new FileSystemInput(rootDir, processor, this);
    }

    public void updateInputProperties(FileSystemInput input, Properties properties) {
        String pathProcessorId = properties.getProperty(this.propertyPathProcessorId);
        if (pathProcessorId != null && !pathProcessorId.equals(this.pathProcessorFactory.getDefaultInputProcessor())) {
            PathProcessor processor = this.pathProcessorFactory.getProcessor(pathProcessorId);
            input.setPathProcessor(processor);
        }
    }

    public String getInputDirParameter() {
        return this.inputDirParameter;
    }

    public void setInputDirParameter(String inputDirParameter) {
        this.inputDirParameter = inputDirParameter;
    }

    public String getPropertyPathProcessorId() {
        return this.propertyPathProcessorId;
    }

    public void setPropertyPathProcessorId(String propertyPathProcessorId) {
        this.propertyPathProcessorId = propertyPathProcessorId;
    }

    public PathProcessorFactory getPathProcessorFactory() {
        return this.pathProcessorFactory;
    }

    public void setPathProcessorFactory(PathProcessorFactory pathProcessorFactory) {
        this.pathProcessorFactory = pathProcessorFactory;
    }
}

