/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.export;

import com.jaspersoft.jasperserver.api.JSException;
import com.jaspersoft.jasperserver.api.JSExceptionWrapper;
import com.jaspersoft.jasperserver.export.CommandBean;
import com.jaspersoft.jasperserver.export.CommandHelp;
import com.jaspersoft.jasperserver.export.CommandMetadata;
import com.jaspersoft.jasperserver.export.Parameters;
import com.jaspersoft.jasperserver.export.util.CommandOut;
import com.jaspersoft.jasperserver.export.util.CommandUtils;
import java.io.IOException;
import java.util.Locale;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.xml.XmlBeanDefinitionReader;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.support.GenericApplicationContext;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.Resource;

public abstract class BaseExportImportCommand {
    protected static final Log log = LogFactory.getLog(BaseExportImportCommand.class);
    protected static final CommandOut commandOut = CommandOut.getInstance();
    public static final String ARG_CONFIG_FILES = "configFiles";
    public static final String ARG_CONFIG_RESOURCES = "configResources";
    public static final String ARG_COMMAND_BEAN = "commandBean";
    public static final String ARG_HELP = "help";
    public static final String HELP_BEAN_NAME = "helpPrintBean";
    private final String defaultBeanName;
    private final String commandMetaBeanName;
    protected static final SpringResourceFactory fileSystemResourceFactory = new SpringResourceFactory(){

        public Resource create(String location) {
            commandOut.debug("Loading Spring configuration file " + location);
            return new FileSystemResource(location);
        }
    };
    protected static final SpringResourceFactory classPathResourceFactory = new SpringResourceFactory(){

        public Resource create(String location) {
            commandOut.debug("Loading Spring configuration classpath resource " + location);
            return new ClassPathResource(location);
        }
    };

    protected BaseExportImportCommand(String defaultBeanName, String commandMetaBeanName) {
        this.defaultBeanName = defaultBeanName;
        this.commandMetaBeanName = commandMetaBeanName;
    }

    protected static void debugArgs(String[] args) {
        if (log.isDebugEnabled()) {
            for (int i = 0; i < args.length; ++i) {
                log.debug((Object)("arg #" + i + " = \"" + args[i] + "\""));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean process(String[] args) throws IOException {
        Parameters exportParameters = this.parseArgs(args);
        ConfigurableApplicationContext ctx = exportParameters.hasParameter(ARG_HELP) ? this.createSpringContext(exportParameters, "helpApplicationContext-export-import*.xml") : this.createSpringContext(exportParameters, "applicationContext*.xml");
        try {
            boolean success = true;
            CommandMetadata metadataBean = this.getCommandMetadataBean((ApplicationContext)ctx);
            if (exportParameters.hasParameter(ARG_HELP)) {
                CommandHelp helpBean = this.getHelpBean((ApplicationContext)ctx);
                helpBean.printHelp(args[0], metadataBean, System.out);
            } else {
                CommandBean commandBean = this.getCommandBean(exportParameters, (ApplicationContext)ctx);
                try {
                    metadataBean.validateParameters(exportParameters);
                    commandBean.process(exportParameters);
                }
                catch (JSExceptionWrapper e) {
                    throw e;
                }
                catch (JSException e) {
                    success = false;
                    if (log.isInfoEnabled()) {
                        log.info((Object)e.getMessage(), (Throwable)e);
                    }
                    String message = ctx.getMessage(e.getMessage(), e.getArgs(), Locale.getDefault());
                    System.err.println(message);
                }
            }
            boolean bl = success;
            return bl;
        }
        finally {
            ctx.close();
        }
    }

    protected Parameters parseArgs(String[] args) {
        Parameters exportParameters = CommandUtils.parse(args);
        return exportParameters;
    }

    protected ConfigurableApplicationContext createSpringContext(Parameters exportParameters, String resourceFileName) throws IOException {
        Resource[] resources;
        GenericApplicationContext ctx = new GenericApplicationContext();
        XmlBeanDefinitionReader configReader = new XmlBeanDefinitionReader((BeanDefinitionRegistry)ctx);
        for (Resource resource : resources = ctx.getResources(resourceFileName)) {
            configReader.loadBeanDefinitions(resource);
        }
        ctx.refresh();
        return ctx;
    }

    protected void registerConfig(String[] locations, XmlBeanDefinitionReader reader, SpringResourceFactory resourceFactory) {
        if (locations != null && locations.length > 0) {
            for (int i = 0; i < locations.length; ++i) {
                String location = locations[i];
                Resource resource = resourceFactory.create(location);
                reader.loadBeanDefinitions(resource);
            }
        }
    }

    protected String getConfigSeparator() {
        return System.getProperty("path.separator");
    }

    protected CommandBean getCommandBean(Parameters exportParameters, ApplicationContext ctx) {
        String beanName = this.getCommandBeanName(exportParameters);
        return (CommandBean)ctx.getBean(beanName, CommandBean.class);
    }

    protected CommandHelp getHelpBean(ApplicationContext ctx) {
        return (CommandHelp)ctx.getBean(HELP_BEAN_NAME, CommandHelp.class);
    }

    protected CommandMetadata getCommandMetadataBean(ApplicationContext ctx) {
        return (CommandMetadata)ctx.getBean(this.commandMetaBeanName, CommandMetadata.class);
    }

    protected String getCommandBeanName(Parameters exportParameters) {
        String beanName = exportParameters.getParameterValue(ARG_COMMAND_BEAN);
        if (beanName == null) {
            commandOut.debug("Using default " + this.defaultBeanName + " command bean");
            beanName = this.defaultBeanName;
        } else {
            commandOut.debug("Using " + beanName + " command bean");
        }
        return beanName;
    }

    protected static interface SpringResourceFactory {
        public Resource create(String var1);
    }
}

