/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.util.test;

import com.jaspersoft.jasperserver.api.common.domain.ExecutionContext;
import com.jaspersoft.jasperserver.api.common.domain.impl.ExecutionContextImpl;
import com.jaspersoft.jasperserver.api.engine.common.service.EngineService;
import com.jaspersoft.jasperserver.api.engine.jasperreports.service.impl.JdbcReportDataSourceServiceFactory;
import com.jaspersoft.jasperserver.api.engine.jasperreports.service.impl.JndiJdbcReportDataSourceServiceFactory;
import com.jaspersoft.jasperserver.api.engine.scheduling.service.ReportSchedulingService;
import com.jaspersoft.jasperserver.api.metadata.common.domain.FileResource;
import com.jaspersoft.jasperserver.api.metadata.common.domain.Folder;
import com.jaspersoft.jasperserver.api.metadata.common.domain.InternalURI;
import com.jaspersoft.jasperserver.api.metadata.common.domain.Resource;
import com.jaspersoft.jasperserver.api.metadata.common.domain.client.FolderImpl;
import com.jaspersoft.jasperserver.api.metadata.common.service.RepositoryService;
import com.jaspersoft.jasperserver.api.metadata.jasperreports.domain.JdbcReportDataSource;
import com.jaspersoft.jasperserver.api.metadata.jasperreports.domain.JndiJdbcReportDataSource;
import com.jaspersoft.jasperserver.api.metadata.jasperreports.domain.ReportDataSource;
import com.jaspersoft.jasperserver.api.metadata.jasperreports.domain.client.JdbcReportDataSourceImpl;
import com.jaspersoft.jasperserver.api.metadata.jasperreports.service.ReportDataSourceService;
import com.jaspersoft.jasperserver.api.metadata.olap.service.OlapConnectionService;
import com.jaspersoft.jasperserver.api.metadata.user.domain.ObjectPermission;
import com.jaspersoft.jasperserver.api.metadata.user.domain.ProfileAttribute;
import com.jaspersoft.jasperserver.api.metadata.user.domain.Role;
import com.jaspersoft.jasperserver.api.metadata.user.domain.Tenant;
import com.jaspersoft.jasperserver.api.metadata.user.domain.User;
import com.jaspersoft.jasperserver.api.metadata.user.domain.client.TenantImpl;
import com.jaspersoft.jasperserver.api.metadata.user.service.ObjectPermissionService;
import com.jaspersoft.jasperserver.api.metadata.user.service.ProfileAttributeService;
import com.jaspersoft.jasperserver.api.metadata.user.service.TenantService;
import com.jaspersoft.jasperserver.api.metadata.user.service.UserAuthorityService;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.util.Date;
import java.util.HashMap;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.security.Authentication;
import org.springframework.security.acl.basic.SimpleAclEntry;
import org.springframework.security.context.SecurityContextHolder;
import org.springframework.security.providers.TestingAuthenticationToken;
import org.springframework.security.userdetails.UserDetails;
import org.springframework.security.userdetails.UserDetailsService;
import org.springframework.test.AbstractDependencyInjectionSpringContextTests;

public abstract class BaseJasperServerTest
extends AbstractDependencyInjectionSpringContextTests {
    public static String adminUserName = "admin";
    public static String userRoleName = "ROLE_USER";
    public static String administratorRoleName = "ROLE_ADMINISTRATOR";
    protected ExecutionContext exContext = new ExecutionContextImpl();
    private Properties jdbcProps;
    private JdbcReportDataSourceServiceFactory jdbcDataSourceServiceFactory;
    private JndiJdbcReportDataSourceServiceFactory jndiJdbcDataSourceServiceFactory;
    private RepositoryService repositoryService;
    private RepositoryService unsecureRepositoryService;
    private UserAuthorityService userAuthorityService;
    private ProfileAttributeService profileAttributeService;
    private ObjectPermissionService objectPermissionService;
    private ReportSchedulingService reportSchedulingService;
    private OlapConnectionService olapConnectionService;
    private EngineService engineService;
    protected final Log logger = LogFactory.getLog(((Object)((Object)this)).getClass());
    private TenantService tenantService;
    protected static final String USER_JASPERADMIN = "jasperadmin";
    protected static final String ROLE_ADMINISTRATOR = "ROLE_ADMINISTRATOR";

    public BaseJasperServerTest() {
        this.setAutowireMode(1);
    }

    public BaseJasperServerTest(String name) {
        super(name);
        this.setAutowireMode(1);
    }

    protected String[] getConfigLocations() {
        return new String[]{"applicationContext*.xml"};
    }

    public String getNameFromURI(String uri) {
        String[] pathParts = uri.split("/");
        return pathParts[pathParts.length - 1];
    }

    protected FileResource loadAndPrepareFileResource(String resourcePath, String uri, String fileType) throws Exception {
        String resultString = this.loadFile(resourcePath);
        String name = this.getNameFromURI(uri);
        return this.prepareFile(name, name, name, resultString, fileType);
    }

    protected String loadFile(String fileName) throws IOException {
        InputStream is = ((Object)((Object)this)).getClass().getResourceAsStream(fileName);
        BufferedReader br = new BufferedReader(new InputStreamReader(is));
        StringBuffer sb = new StringBuffer();
        char[] cbuf = new char[1024];
        int k = 0;
        while ((k = br.read(cbuf)) != -1) {
            sb.append(cbuf, 0, k);
        }
        br.close();
        return sb.toString();
    }

    protected FileResource prepareFile(String name, String label, String description, String content, String fileType) {
        FileResource schemaRes = (FileResource)this.getRepositoryService().newResource(this.exContext, FileResource.class);
        schemaRes.setFileType(fileType);
        schemaRes.setName(name);
        schemaRes.setLabel(label);
        schemaRes.setDescription(description);
        schemaRes.setData(content.getBytes());
        return schemaRes;
    }

    protected Folder ensureParentFolderExists(String uri) {
        StringBuffer folderPath = this.getParentURI(uri);
        Folder got = this.getRepositoryService().getFolder(this.exContext, folderPath.toString());
        if (got != null) {
            this.logger.debug((Object)("Folder: " + folderPath.toString() + " exists"));
            return got;
        }
        this.logger.debug((Object)("Creating Folder: " + folderPath.toString()));
        String[] pathParts = folderPath.toString().split("/");
        folderPath = new StringBuffer();
        Folder parentFolder = null;
        for (int i = 0; i < pathParts.length; ++i) {
            if (pathParts[i].length() == 0) continue;
            folderPath.append("/").append(pathParts[i]);
            got = this.getRepositoryService().getFolder(this.exContext, folderPath.toString());
            if (got == null) {
                got = new FolderImpl();
                got.setName(pathParts[i]);
                got.setLabel(pathParts[i]);
                got.setDescription(pathParts[i] + " description");
                got.setParentFolder(parentFolder);
                this.getRepositoryService().saveFolder(null, got);
            }
            parentFolder = got;
        }
        return got;
    }

    public StringBuffer getParentURI(String uri) {
        String[] pathParts = uri.split("/");
        StringBuffer folderPath = new StringBuffer();
        for (int i = 0; i < pathParts.length - 1; ++i) {
            if (pathParts[i].length() == 0) continue;
            folderPath.append("/").append(pathParts[i]);
        }
        return folderPath;
    }

    public Properties getJdbcProps() {
        return this.jdbcProps;
    }

    public void setJdbcProps(Properties jdbcProps) {
        this.jdbcProps = jdbcProps;
    }

    public String getDatabaseProductName(String dsUri) {
        ReportDataSource ds = (ReportDataSource)this.getRepositoryService().getResource(this.exContext, dsUri);
        ReportDataSourceService jdss = ds instanceof JndiJdbcReportDataSource ? this.jndiJdbcDataSourceServiceFactory.createService(ds) : this.jdbcDataSourceServiceFactory.createService(ds);
        HashMap params = new HashMap();
        jdss.setReportParameterValues(params);
        try {
            Connection conn = (Connection)params.get("REPORT_CONNECTION");
            DatabaseMetaData metadata = conn.getMetaData();
            jdss.closeConnection();
            return metadata.getDatabaseProductName();
        }
        catch (SQLException ex) {
            throw new IllegalArgumentException("Cannot get database vendor name", ex);
        }
    }

    public boolean useUpperCaseNames() throws Exception {
        return Boolean.parseBoolean(this.getJdbcProps().getProperty("foodmart.upperCaseNames"));
    }

    public JdbcReportDataSourceServiceFactory getJdbcDataSourceServiceFactory() {
        return this.jdbcDataSourceServiceFactory;
    }

    public void setJdbcDataSourceServiceFactory(JdbcReportDataSourceServiceFactory jdbcDataSourceServiceFactory) {
        this.jdbcDataSourceServiceFactory = jdbcDataSourceServiceFactory;
    }

    public JndiJdbcReportDataSourceServiceFactory getJndiJdbcDataSourceServiceFactory() {
        return this.jndiJdbcDataSourceServiceFactory;
    }

    public void setJndiJdbcDataSourceServiceFactory(JndiJdbcReportDataSourceServiceFactory jndiJdbcDataSourceServiceFactory) {
        this.jndiJdbcDataSourceServiceFactory = jndiJdbcDataSourceServiceFactory;
    }

    protected JdbcReportDataSource createJdbcReportDataSourceFromProperties(String prefix) throws Exception {
        JdbcReportDataSourceImpl ds = new JdbcReportDataSourceImpl();
        ds.setDriverClass(this.getJdbcProps().getProperty(prefix + ".jdbc.driverClassName"));
        ds.setConnectionUrl(this.getJdbcProps().getProperty(prefix + ".jdbc.url"));
        ds.setUsername(this.getJdbcProps().getProperty(prefix + ".jdbc.username"));
        ds.setPassword(this.getJdbcProps().getProperty(prefix + ".jdbc.password"));
        if (ds.getDriverClass() == null || ds.getConnectionUrl() == null || ds.getUsername() == null || ds.getPassword() == null) {
            throw new IllegalArgumentException("some jdbc props missing for prefix " + prefix);
        }
        return ds;
    }

    protected JdbcReportDataSource createAndSaveJdbcDSFromProps(String folderURI, String prefix) throws Exception {
        String dsURI = folderURI + "/" + prefix;
        JdbcReportDataSource ds = (JdbcReportDataSource)this.getRepositoryService().getResource(this.exContext, dsURI);
        if (ds == null) {
            ds = this.createJdbcReportDataSourceFromProperties(prefix);
            ds.setName(prefix);
            ds.setParentFolder(this.ensureParentFolderExists(dsURI));
            ds.setLabel(prefix);
            this.getRepositoryService().saveResource(this.exContext, (Resource)ds);
        }
        return ds;
    }

    protected ProfileAttribute createTestAttr(Object principal, String name, String value) {
        ProfileAttribute attr = this.getProfileAttributeService().newProfileAttribute(null);
        attr.setPrincipal(principal);
        attr.setAttrName(name);
        attr.setAttrValue(value);
        return attr;
    }

    protected Authentication setAuthenticatedUser(String username) {
        UserDetails userDetails = ((UserDetailsService)this.getUserAuthorityService()).loadUserByUsername(username);
        TestingAuthenticationToken aUser = new TestingAuthenticationToken((Object)userDetails, (Object)userDetails.getPassword(), userDetails.getAuthorities());
        aUser.setAuthenticated(true);
        SecurityContextHolder.getContext().setAuthentication((Authentication)aUser);
        this.logger.debug((Object)("Principal: " + aUser.getPrincipal()));
        return aUser;
    }

    protected void basicAuthSetup() {
        Tenant defaultTenant = this.tenantService.getDefaultTenant(null);
        if (defaultTenant == null) {
            this.createTenantForRoot();
        }
        Role userRole = this.getOrCreateRole(userRoleName);
        Role adminRole = this.getOrCreateRole(administratorRoleName);
        User adminUser = this.findOrCreateUser(adminUserName);
        this.getUserAuthorityService().addRole(null, adminUser, adminRole);
        Folder root = this.getUnsecureRepositoryService().getFolder(this.exContext, "/");
        if (root == null) {
            root = new FolderImpl();
            root.setName("/");
            root.setLabel("root");
            root.setDescription("Root of the folder hierarchy");
            this.getUnsecureRepositoryService().saveFolder(null, root);
        }
        this.createObjectPermission("/", (Object)adminRole, SimpleAclEntry.ADMINISTRATION);
        this.setAuthenticatedUser(adminUserName);
    }

    protected Role getOrCreateRole(String roleName) {
        Role r = this.getUserAuthorityService().getRole(null, roleName);
        if (r == null) {
            r = this.getUserAuthorityService().newRole(null);
            r.setRoleName(roleName);
            r.setExternallyDefined(false);
            this.getUserAuthorityService().putRole(null, r);
        }
        return r;
    }

    protected User findOrCreateUser(String username) {
        User workingUser = this.getUserAuthorityService().getUser(null, username);
        if (workingUser == null) {
            workingUser = this.getUserAuthorityService().newUser(null);
            workingUser.setUsername(username);
            workingUser.setPassword(username);
            workingUser.setFullName(username + " user");
            workingUser.setEnabled(true);
            workingUser.setPreviousPasswordChangeTime(new Date());
            this.getUserAuthorityService().putUser(null, workingUser);
        }
        return workingUser;
    }

    private FileResource saveOrUpdateFile(String uri, String name, String label, String description, String content, String fileType) {
        FileResource schemaRes = (FileResource)this.getRepositoryService().getResource(this.exContext, uri);
        if (schemaRes == null) {
            this.logger.debug((Object)("File: " + uri + " being created"));
            schemaRes = this.prepareFile(name, label, description, content, fileType);
            schemaRes.setParentFolder(this.ensureParentFolderExists(uri));
            this.getRepositoryService().saveResource(this.exContext, (Resource)schemaRes);
        }
        return schemaRes;
    }

    protected FileResource loadAndSaveFileResource(String resourcePath, String uri, String fileType) throws Exception {
        String resultString = this.loadFile(resourcePath);
        String name = this.getNameFromURI(uri);
        return this.saveOrUpdateFile(uri, name, name, name, resultString, fileType);
    }

    public RepositoryService getRepositoryService() {
        return this.repositoryService;
    }

    public void setRepositoryService(RepositoryService repository) {
        this.repositoryService = repository;
    }

    public void setUnsecureRepositoryService(RepositoryService unsecureRepositoryService) {
        this.unsecureRepositoryService = unsecureRepositoryService;
    }

    public RepositoryService getUnsecureRepositoryService() {
        return this.unsecureRepositoryService;
    }

    public void setUserAuthorityService(UserAuthorityService userAuthorityService) {
        this.userAuthorityService = userAuthorityService;
    }

    public UserAuthorityService getUserAuthorityService() {
        return this.userAuthorityService;
    }

    public void setObjectPermissionService(ObjectPermissionService objectPermissionService) {
        this.objectPermissionService = objectPermissionService;
    }

    public ObjectPermissionService getObjectPermissionService() {
        return this.objectPermissionService;
    }

    public void setReportSchedulingService(ReportSchedulingService reportSchedulingService) {
        this.reportSchedulingService = reportSchedulingService;
    }

    public ProfileAttributeService getProfileAttributeService() {
        return this.profileAttributeService;
    }

    public ReportSchedulingService getReportSchedulingService() {
        return this.reportSchedulingService;
    }

    public void setOlapConnectionService(OlapConnectionService olapConnectionService) {
        this.olapConnectionService = olapConnectionService;
    }

    public OlapConnectionService getOlapConnectionService() {
        return this.olapConnectionService;
    }

    protected void logPermission(ObjectPermission perm) {
        if (perm == null) {
            return;
        }
        Object rpt = perm.getPermissionRecipient();
        String name = "?";
        if (rpt instanceof Role) {
            Role r = (Role)rpt;
            name = r.getRoleName() + (r.getTenantId() == null ? "" : "|" + r.getTenantId());
        } else if (rpt instanceof User) {
            User u = (User)rpt;
            name = u.getUsername() + (u.getTenantId() == null ? "" : "|" + u.getTenantId());
        }
        this.logger.warn((Object)("Creating permission : " + perm.getURI() + " will have mask " + perm.getPermissionMask() + " for " + name));
    }

    protected ObjectPermission createObjectPermission(InternalURI target, Object recipient, int permissionMask) {
        ObjectPermission permission = this.getObjectPermissionService().newObjectPermission(null);
        permission.setURI(target.getURI());
        permission.setPermissionRecipient(recipient);
        permission.setPermissionMask(permissionMask);
        this.logPermission(permission);
        this.getObjectPermissionService().putObjectPermission(null, permission);
        return permission;
    }

    protected ObjectPermission createObjectPermission(String targetPath, Object recipient, int permissionMask) {
        ObjectPermission permission = this.getObjectPermissionService().newObjectPermission(null);
        permission.setURI("repo:" + targetPath);
        permission.setPermissionRecipient(recipient);
        permission.setPermissionMask(permissionMask);
        ExecutionContextImpl ectx = new ExecutionContextImpl();
        ectx.getAttributes().add("PRIVILEGED_OPERATION");
        this.logPermission(permission);
        this.getObjectPermissionService().putObjectPermission((ExecutionContext)ectx, permission);
        return permission;
    }

    protected void deleteObjectPermission(InternalURI target, Object recipient) {
        ObjectPermission op = this.getObjectPermissionService().newObjectPermission(null);
        String targetURI = target.getURI();
        op.setURI(targetURI);
        op.setPermissionRecipient(recipient);
        this.logger.info((Object)("deleteObjectPermission: about to get: " + targetURI + ", recipient: " + recipient));
        ObjectPermission op2 = this.getObjectPermissionService().getObjectPermission(null, op);
        if (op2 != null) {
            this.logger.info((Object)("deleteObjectPermission: got " + op2 + ". about to delete: " + targetURI + ", recipient: " + recipient));
            this.getObjectPermissionService().deleteObjectPermission(null, op);
            this.logger.info((Object)("deleted permission for uri: " + targetURI + ", recipient: " + recipient));
        } else {
            this.logger.info((Object)("Can't delete permission for uri: " + targetURI + ", recipient: " + recipient + " because it does not exist"));
        }
    }

    public void setTenantService(TenantService tenantService) {
        this.tenantService = tenantService;
    }

    public TenantService getTenantService() {
        return this.tenantService;
    }

    protected void createTenantForRoot() {
        this.createTenant("", "organizations", "root", "organizations", " ", "/", "/", "default");
    }

    public void createTenant(String parentTenantId, String tenantId, String tenantName, String tenantDesc, String tenantNote, String relativeUri, String uri, String theme) {
        TenantImpl aTenant = new TenantImpl();
        if (!"organizations".equals(tenantId) && !"organizations".equals(parentTenantId)) {
            tenantId = parentTenantId + "_" + tenantId;
        }
        aTenant.setParentId(parentTenantId);
        aTenant.setId(tenantId);
        aTenant.setAlias(tenantId);
        aTenant.setTenantName(tenantName);
        aTenant.setTenantDesc(tenantDesc);
        aTenant.setTenantNote(tenantNote);
        aTenant.setTenantUri(relativeUri);
        aTenant.setTenantFolderUri(uri);
        aTenant.setTheme(theme);
        this.tenantService.putTenant(null, (Tenant)aTenant);
    }

    public void setProfileAttributeService(ProfileAttributeService profileAttributeService) {
        this.profileAttributeService = profileAttributeService;
    }

    public void setEngineService(EngineService engineService) {
        this.engineService = engineService;
    }

    public EngineService getEngineService() {
        return this.engineService;
    }
}

