/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.api.metadata.view.service.impl;

import com.jaspersoft.jasperserver.api.metadata.common.service.impl.hibernate.persistent.RepoFolder;
import com.jaspersoft.jasperserver.api.metadata.jasperreports.domain.impl.RepoReportUnit;
import com.jaspersoft.jasperserver.api.metadata.user.domain.Role;
import com.jaspersoft.jasperserver.api.metadata.user.domain.User;
import com.jaspersoft.jasperserver.api.metadata.user.domain.impl.hibernate.RepoRole;
import com.jaspersoft.jasperserver.api.metadata.user.domain.impl.hibernate.RepoTenant;
import com.jaspersoft.jasperserver.api.metadata.user.domain.impl.hibernate.RepoUser;
import com.jaspersoft.jasperserver.util.test.BaseJasperServerTest;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Properties;
import junit.textui.TestRunner;
import org.hibernate.SessionFactory;
import org.hibernate.classic.Session;
import org.springframework.orm.hibernate3.HibernateTemplate;
import org.springframework.orm.hibernate3.SessionFactoryUtils;
import org.springframework.orm.hibernate3.SessionHolder;
import org.springframework.orm.hibernate3.support.HibernateDaoSupport;
import org.springframework.transaction.support.TransactionSynchronizationManager;

public class HibernateAccessTest
extends BaseJasperServerTest {
    public static int NUMBER_OF_TEST_ROLES = 5;
    SessionFactory sessionFactory;
    RepoReportUnit testObject;
    RepoFolder root;
    HibernateTemplate template;
    HibernateDaoSupport jasperServerDao;
    private Properties jdbcProps;
    User testUser;
    List testRoles = new ArrayList(NUMBER_OF_TEST_ROLES);
    Long testTenantId;

    public HibernateDaoSupport getJasperServerDao() {
        return this.jasperServerDao;
    }

    public void setJasperServerDao(HibernateDaoSupport jasperServerDao) {
        this.jasperServerDao = jasperServerDao;
    }

    public SessionFactory getSessionFactory() {
        return this.sessionFactory;
    }

    public void setSessionFactory(SessionFactory sessionFactory) {
        this.sessionFactory = sessionFactory;
    }

    public HibernateAccessTest(String name) {
        super(name);
        this.setAutowireMode(1);
    }

    public static void main(String[] args) {
        TestRunner.run(HibernateAccessTest.class);
    }

    protected void onSetUp() throws Exception {
        System.out.println("Setup HibernateAccessTest");
        Session s = this.sessionFactory.openSession();
        TransactionSynchronizationManager.bindResource((Object)this.sessionFactory, (Object)new SessionHolder((org.hibernate.Session)s));
        this.template = this.jasperServerDao.getHibernateTemplate();
        RepoFolder root = new RepoFolder();
        root.setCreationDate(new Date());
        root.setUpdateDate(new Date());
        root.setName("/");
        root.setLabel("root");
        root.setDescription("Root of the folder hierarchy");
        root.setURI("/");
        root.setHidden(false);
        root.setParent(null);
        this.template.save((Object)root);
    }

    public void onTearDown() {
        System.out.println("Tear down HibernateAccessTest");
        SessionHolder holder = (SessionHolder)TransactionSynchronizationManager.getResource((Object)this.sessionFactory);
        org.hibernate.Session s = holder.getSession();
        s.flush();
        TransactionSynchronizationManager.unbindResource((Object)this.sessionFactory);
        SessionFactoryUtils.releaseSession((org.hibernate.Session)s, (SessionFactory)this.sessionFactory);
    }

    public void createReportUnit() throws Exception {
        System.out.println("createReportUnit");
        RepoReportUnit testObjectImpl = new RepoReportUnit();
        testObjectImpl.setCreationDate(new Date());
        testObjectImpl.setDescription("Test");
        testObjectImpl.setName("Test");
        testObjectImpl.setLabel("Test");
        testObjectImpl.setParent(this.root);
        Long testObjectId = (Long)this.template.save((Object)testObjectImpl);
        HibernateAccessTest.assertNotNull((String)"testObjectId", (Object)testObjectId);
        this.testObject = (RepoReportUnit)this.template.load(RepoReportUnit.class, (Serializable)testObjectId);
        HibernateAccessTest.assertNotNull((String)"testObject", (Object)this.testObject);
    }

    public void createUser() throws Exception {
        System.out.println("createUser");
        RepoUser testUserImpl = new RepoUser();
        testUserImpl.setUsername("TestUser");
        testUserImpl.setFullName("TestUser");
        testUserImpl.setPassword("newPassword");
        testUserImpl.setEnabled(true);
        testUserImpl.setExternallyDefined(false);
        RepoTenant defaultTenant = (RepoTenant)this.template.load(RepoTenant.class, (Serializable)this.testTenantId);
        testUserImpl.setTenant(defaultTenant);
        Long testObjectId = (Long)this.template.save((Object)testUserImpl);
        this.testUser = (User)this.template.load(RepoUser.class, (Serializable)testObjectId);
        HibernateAccessTest.assertNotNull((String)"testUser null", (Object)this.testUser);
    }

    public void createRoles() throws Exception {
        System.out.println("testCreateRoles");
        for (int i = 0; i < NUMBER_OF_TEST_ROLES; ++i) {
            RepoRole testRoleImpl = new RepoRole();
            String roleName = "TestRole" + i;
            testRoleImpl.setRoleName(roleName);
            testRoleImpl.setExternallyDefined(false);
            RepoTenant defaultTenant = (RepoTenant)this.template.load(RepoTenant.class, (Serializable)this.testTenantId);
            testRoleImpl.setTenant(defaultTenant);
            this.template.saveOrUpdate((Object)testRoleImpl);
            this.testRoles.add(testRoleImpl);
            this.testUser.addRole((Role)testRoleImpl);
        }
        this.template.saveOrUpdate((Object)this.testUser);
        HibernateAccessTest.assertTrue((String)"testUser.getRoles().size()", (this.testUser.getRoles().size() == NUMBER_OF_TEST_ROLES ? 1 : 0) != 0);
    }

    public void createDefaultTenant() {
        System.out.println("createDefaultTenant");
        RepoTenant aTenant = new RepoTenant();
        aTenant.setTenantId("organizations");
        aTenant.setTenantAlias("organizations");
        aTenant.setParent(null);
        aTenant.setTenantName("root");
        aTenant.setTenantDesc("default tenant");
        aTenant.setTenantNote("");
        aTenant.setTenantUri("/");
        aTenant.setTenantFolderUri("/");
        this.testTenantId = (Long)this.template.save((Object)aTenant);
    }

    public void disabled_testReportUnitQuery() throws Exception {
        this.createReportUnit();
        System.out.println("testQuery");
        List result = this.template.find("from RepoReportUnit where name = ?", (Object)"Test");
        HibernateAccessTest.assertNotNull((String)"result", (Object)result);
        HibernateAccessTest.assertTrue((String)"result.size() == 1", (result.size() == 1 ? 1 : 0) != 0);
        this.testObject = (RepoReportUnit)result.get(0);
    }

    public void testUserQuery() throws Exception {
        this.createDefaultTenant();
        this.createUser();
        this.createRoles();
        this.template.flush();
        System.out.println("testUserQuery");
        List result = this.template.find("from RepoUser where username = ?", (Object)"TestUser");
        HibernateAccessTest.assertNotNull((String)"result", (Object)result);
        HibernateAccessTest.assertTrue((String)"result.size() == 1", (result.size() == 1 ? 1 : 0) != 0);
        System.out.println("testUserQuery: found result OK");
        this.testUser = (User)result.get(0);
        HibernateAccessTest.assertNotNull((String)"testUser", (Object)this.testUser);
        HibernateAccessTest.assertNotNull((String)"testUser.getRoles()", (Object)this.testUser.getRoles());
        HibernateAccessTest.assertTrue((String)"testUser.getRoles().size()", (this.testUser.getRoles().size() == NUMBER_OF_TEST_ROLES ? 1 : 0) != 0);
        System.out.println("testUserQuery: roles OK");
    }
}

