/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.api.metadata.view.service.impl;

import com.jaspersoft.jasperserver.api.metadata.user.domain.Role;
import com.jaspersoft.jasperserver.api.metadata.user.domain.User;
import com.jaspersoft.jasperserver.api.metadata.view.service.impl.MockStringAuthenticationProvider;
import com.jaspersoft.jasperserver.util.test.BaseJasperServerTest;
import java.io.IOException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import junit.framework.TestCase;
import junit.textui.TestRunner;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.mock.web.MockHttpServletResponse;
import org.springframework.security.Authentication;
import org.springframework.security.GrantedAuthority;
import org.springframework.security.GrantedAuthorityImpl;
import org.springframework.security.context.SecurityContextHolder;
import org.springframework.security.ui.webapp.AuthenticationProcessingFilter;
import org.springframework.security.util.FilterChainProxy;

public class AuthenticationTest
extends BaseJasperServerTest {
    private static Log log = LogFactory.getLog(AuthenticationTest.class);
    public static final String testExternalUserName = "TestExternalUser";
    public static final String testExternalPassword = "password";
    public static final String testExternalRoleNamePrefix = "TestExternalRole";
    public static final String testInternalRoleNamePrefix = "ROLE_TestInternalRole";
    public static final String testUserDetailsUserName = "tomcat";
    public static final String testUserDetailsPassword = "tomcat";
    Properties jdbcProps;

    public AuthenticationTest(String name) {
        super(name);
        this.setAutowireMode(1);
    }

    public static void main(String[] args) {
        TestRunner.run(AuthenticationTest.class);
    }

    public void onSetUp() throws Exception {
        log.debug((Object)"Setup");
    }

    public void onTearDown() {
        log.debug((Object)"Tear down");
        this.getUserAuthorityService().deleteUser(null, testExternalUserName);
        User workingUser = this.getUserAuthorityService().getUser(null, "tomcat");
        Role workRole = this.getUserAuthorityService().getRole(null, "ROLE_TestExternalRole0");
        this.getUserAuthorityService().removeRole(null, workingUser, workRole);
        for (int i = 0; i < 3; ++i) {
            this.getUserAuthorityService().deleteRole(null, "ROLE_TestExternalRole" + i);
            this.getUserAuthorityService().deleteRole(null, testInternalRoleNamePrefix + i);
        }
    }

    public Role addRole(User user, String roleName) {
        log.debug((Object)"addRole");
        Role role = this.getUserAuthorityService().getRole(null, roleName);
        if (role == null) {
            role = this.getUserAuthorityService().newRole(null);
            role.setRoleName(roleName);
            role.setExternallyDefined(false);
            this.getUserAuthorityService().putRole(null, role);
        }
        this.getUserAuthorityService().addRole(null, user, role);
        return role;
    }

    public void loginUser(String userName, String password, int noOfExternalRoles) throws Exception {
        FilterChainProxy filterChainProxy = (FilterChainProxy)this.applicationContext.getBean("filterChainProxy", FilterChainProxy.class);
        filterChainProxy.init((FilterConfig)new MockFilterConfig());
        GrantedAuthority[] grantedAuthorities = AuthenticationTest.generateGrantedAuthorities(testExternalRoleNamePrefix, noOfExternalRoles);
        MockStringAuthenticationProvider mockAuthenticationProvider = (MockStringAuthenticationProvider)this.applicationContext.getBean("stringPrincipalAuthenticationProvider", MockStringAuthenticationProvider.class);
        mockAuthenticationProvider.setGrantedAuthorities(grantedAuthorities);
        AuthenticationProcessingFilter authenticationProcessingFilter = (AuthenticationProcessingFilter)this.applicationContext.getBean("authenticationProcessingFilter", AuthenticationProcessingFilter.class);
        MockHttpServletRequest request = new MockHttpServletRequest();
        request.setServletPath(authenticationProcessingFilter.getFilterProcessesUrl());
        request.setRequestURI(authenticationProcessingFilter.getFilterProcessesUrl());
        log.debug((Object)("request.getContextPath(): '" + request.getContextPath() + "', request.getRequestURI(): '" + request.getRequestURI() + "'"));
        request.setParameter("j_username", userName);
        request.setParameter("j_password", password);
        MockHttpServletResponse response = new MockHttpServletResponse();
        MockFilterChain chain = new MockFilterChain(true);
        filterChainProxy.doFilter((ServletRequest)request, (ServletResponse)response, (FilterChain)chain);
        Authentication auth = SecurityContextHolder.getContext().getAuthentication();
        AuthenticationTest.assertTrue((String)"login not successful", (auth != null ? 1 : 0) != 0);
        request = new MockHttpServletRequest();
        request.setServletPath("/a/random/url");
        response = new MockHttpServletResponse();
        chain = new MockFilterChain(true);
        filterChainProxy.doFilter((ServletRequest)request, (ServletResponse)response, (FilterChain)chain);
    }

    public void testRolesForExternalStringPrincipal() throws Exception {
    }

    public void testRolesForExternalUserDetailsPrincipal() throws Exception {
    }

    private void checkUserAndRoles(User user, String prefix, int expectedExternalCount, int expectedInternalCount) {
        AuthenticationTest.assertTrue((String)(prefix + ": missing user"), (user != null ? 1 : 0) != 0);
        AuthenticationTest.assertTrue((String)(prefix + ": not external"), (boolean)user.isExternallyDefined());
        Set roles = user.getRoles();
        AuthenticationTest.assertTrue((String)(prefix + ": not " + (expectedExternalCount + expectedInternalCount) + " roles, got " + roles.size()), (expectedExternalCount + expectedInternalCount == roles.size() ? 1 : 0) != 0);
        int externalCount = 0;
        int internalCount = 0;
        for (Role r : roles) {
            if (r.isExternallyDefined()) {
                ++externalCount;
                continue;
            }
            ++internalCount;
        }
        AuthenticationTest.assertTrue((String)(prefix + ": saw " + externalCount + " external roles, not " + expectedExternalCount), (externalCount == expectedExternalCount ? 1 : 0) != 0);
        AuthenticationTest.assertTrue((String)(prefix + ": saw " + internalCount + " internal roles, not " + expectedInternalCount), (internalCount == expectedInternalCount ? 1 : 0) != 0);
    }

    private static GrantedAuthority[] generateGrantedAuthorities(String prefix, int length) {
        GrantedAuthority[] newAuthorities = new GrantedAuthority[length];
        for (int i = 0; i < length; ++i) {
            newAuthorities[i] = new GrantedAuthorityImpl(prefix + i);
        }
        return newAuthorities;
    }

    public class MockFilterChain
    implements FilterChain {
        private boolean expectToProceed;

        public MockFilterChain(boolean expectToProceed) {
            this.expectToProceed = expectToProceed;
        }

        public void doFilter(ServletRequest request, ServletResponse response) throws IOException, ServletException {
            if (this.expectToProceed) {
                TestCase.assertTrue((boolean)true);
            } else {
                TestCase.fail((String)"Did not expect filter chain to proceed");
            }
        }
    }

    public class MockFilterConfig
    implements FilterConfig {
        private Map map = new HashMap();

        public String getFilterName() {
            throw new UnsupportedOperationException("mock method not implemented");
        }

        public String getInitParameter(String arg0) {
            Object result = this.map.get(arg0);
            if (result != null) {
                return (String)result;
            }
            return null;
        }

        public Enumeration getInitParameterNames() {
            throw new UnsupportedOperationException("mock method not implemented");
        }

        public void setInitParmeter(String parameter, String value) {
            this.map.put(parameter, value);
        }

        public ServletContext getServletContext() {
            throw new UnsupportedOperationException("mock method not implemented");
        }
    }
}

