/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.api.metadata;

import com.jaspersoft.jasperserver.api.common.domain.ExecutionContext;
import com.jaspersoft.jasperserver.api.common.domain.impl.ExecutionContextImpl;
import com.jaspersoft.jasperserver.api.metadata.OlapConnectionTest;
import com.jaspersoft.jasperserver.api.metadata.common.domain.FileResource;
import com.jaspersoft.jasperserver.api.metadata.common.domain.Folder;
import com.jaspersoft.jasperserver.api.metadata.common.domain.Resource;
import com.jaspersoft.jasperserver.api.metadata.jasperreports.domain.JdbcReportDataSource;
import com.jaspersoft.jasperserver.api.metadata.olap.domain.MondrianConnection;
import com.jaspersoft.jasperserver.api.metadata.olap.service.impl.OlapConnectionServiceImpl;
import com.jaspersoft.jasperserver.api.metadata.user.domain.Role;
import com.jaspersoft.jasperserver.util.test.BaseJasperServerTest;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import junit.textui.TestRunner;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.olap4j.CellSet;
import org.olap4j.OlapConnection;
import org.olap4j.layout.RectangularCellSetFormatter;
import org.olap4j.layout.TraditionalCellSetFormatter;
import org.olap4j.metadata.Cube;
import org.olap4j.metadata.Dimension;
import org.olap4j.metadata.Hierarchy;
import org.olap4j.metadata.Level;
import org.olap4j.metadata.Schema;
import org.springframework.security.acl.basic.SimpleAclEntry;

public class Olap4jConnectionTest
extends BaseJasperServerTest {
    private static final Log log = LogFactory.getLog(Olap4jConnectionTest.class);
    protected final String foodMartSchema2006URI = "/queries/FoodmartSchema2006.xml";
    protected final String foodMartSchema2006UpperURI = "/queries/FoodmartSchema2006Upper.xml";
    protected final String foodMartJaSchemaURI = "/queries/FoodMart_ja.xml";
    protected final String sugarCRMSchemaURI = "/queries/SugarCRMSchema.xml";
    protected final String sugarCRMSchemaUpperURI = "/queries/SugarcrmSchemaUpper.xml";
    protected final String tempDir = "/temp_olap4j";
    protected final String mdsUri = "/temp_olap4j/foodmartMDX_DS";
    public static String SAMPLE_FOODMART_MDX_QUERY = "select {[Measures].[Unit Sales], [Measures].[Store Cost], [Measures].[Store Sales]} on columns, {([Promotion Media].[All Media], [Product].[All Products])} ON rows from Sales where ([Time].[2006].[Q4].[12])";
    private ExecutionContext executionContext;
    private OlapConnectionServiceImpl olapConnectionServiceTarget;
    private MondrianConnection mondrianDataSource;

    public Olap4jConnectionTest() {
        this.setAutowireMode(1);
    }

    public Olap4jConnectionTest(String name) {
        super(name);
        this.setAutowireMode(1);
    }

    public static void main(String[] args) {
        TestRunner.run(OlapConnectionTest.class);
    }

    protected void onSetUp() throws Exception {
        this.executionContext = new ExecutionContextImpl();
        this.basicAuthSetup();
        Folder tempFolder = this.getRepositoryService().getFolder(null, "/temp_olap4j");
        if (tempFolder != null) {
            this.getRepositoryService().deleteFolder(null, "/temp_olap4j");
        }
        tempFolder = this.ensureParentFolderExists("/temp_olap4j/x");
        Role adminRole = this.getOrCreateRole(administratorRoleName);
        this.createObjectPermission("/temp_olap4j", (Object)adminRole, SimpleAclEntry.ADMINISTRATION);
        this.createMondrianDataSource("/temp_olap4j/foodmartMDX_DS", "foodmart", "/queries/FoodmartSchema2006.xml");
    }

    protected MondrianConnection createMondrianDataSource(String uri, String dsName, String schemaPath) throws Exception {
        if (this.mondrianDataSource == null) {
            Resource oldDS = this.getRepositoryService().getResource(null, uri);
            if (oldDS != null) {
                this.getRepositoryService().deleteResource(null, uri);
            }
            String name = this.getNameFromURI(uri);
            Folder parent = this.ensureParentFolderExists(uri);
            this.mondrianDataSource = (MondrianConnection)this.getRepositoryService().newResource(null, MondrianConnection.class);
            this.mondrianDataSource.setName(name);
            this.mondrianDataSource.setLabel(name);
            this.mondrianDataSource.setParentFolder(parent);
            FileResource schema = (FileResource)this.getRepositoryService().newResource(null, FileResource.class);
            schema.setFileType("xml");
            schema.setName(name + "_schema");
            schema.setLabel(name + "_schema");
            schema.setParentFolder(parent);
            InputStream schemaIS = ((Object)((Object)this)).getClass().getResourceAsStream(schemaPath);
            schema.readData(schemaIS);
            this.getRepositoryService().saveResource(null, (Resource)schema);
            this.mondrianDataSource.setSchemaReference(schema.getURIString());
            JdbcReportDataSource ds = this.createAndSaveJdbcDSFromProps(parent.getURIString(), dsName);
            this.mondrianDataSource.setDataSourceReference(ds.getURIString());
            this.getRepositoryService().saveResource(null, (Resource)this.mondrianDataSource);
        }
        return this.mondrianDataSource;
    }

    public void runOlap4jQuery(String connResourceName, String mdxQuery) throws Exception {
        OlapConnection monConnection = this.getOlapConnectionServiceTarget().getOlapConnection(null, connResourceName);
        CellSet result = monConnection.prepareOlapStatement(mdxQuery).executeQuery();
        String resultString = Olap4jConnectionTest.toString(result, Format.COMPACT_RECTANGULAR);
        log.warn((Object)resultString);
    }

    static String toString(CellSet cellSet, Format format) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        switch (format) {
            case TRADITIONAL: {
                new TraditionalCellSetFormatter().format(cellSet, pw);
                break;
            }
            case COMPACT_RECTANGULAR: 
            case RECTANGULAR: {
                new RectangularCellSetFormatter(format == Format.COMPACT_RECTANGULAR).format(cellSet, pw);
            }
        }
        pw.flush();
        return sw.toString();
    }

    public void testSampleFoodmartQuery() throws Exception {
        this.runOlap4jQuery("/temp_olap4j/foodmartMDX_DS", SAMPLE_FOODMART_MDX_QUERY);
    }

    public void testMetadata() throws Exception {
        OlapConnection monConnection = this.getOlapConnectionServiceTarget().getOlapConnection(null, "/temp_olap4j/foodmartMDX_DS");
        Schema schema = monConnection.getSchema();
        for (Cube cube : schema.getCubes()) {
            log.warn((Object)("cube: " + cube.getName() + ", " + cube.getDescription(null)));
            for (Dimension d : cube.getDimensions()) {
                log.warn((Object)("  dimension: " + d.getName()));
                Hierarchy h = d.getDefaultHierarchy();
                for (Level l : h.getLevels()) {
                    log.warn((Object)("    level: " + l.getName()));
                }
            }
        }
    }

    public void setOlapConnectionServiceTarget(OlapConnectionServiceImpl olapConnectionServiceTarget) {
        this.olapConnectionServiceTarget = olapConnectionServiceTarget;
    }

    public OlapConnectionServiceImpl getOlapConnectionServiceTarget() {
        return this.olapConnectionServiceTarget;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Format {
        TRADITIONAL,
        COMPACT_RECTANGULAR,
        RECTANGULAR;

    }
}

