/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.remote.services;

import com.jaspersoft.jasperserver.api.metadata.common.domain.Resource;
import com.jaspersoft.jasperserver.remote.AbstractService;
import com.jaspersoft.jasperserver.remote.ResourceHandler;
import com.jaspersoft.jasperserver.remote.ServiceException;
import com.jaspersoft.jasperserver.remote.services.ListService;
import java.util.HashMap;
import org.apache.axis.AxisFault;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.context.ApplicationContext;

public class DeleteService
extends AbstractService {
    private static final Log log = LogFactory.getLog(ListService.class);

    public DeleteService(ApplicationContext context) {
        super(context);
    }

    public void deleteResource(String uri) throws ServiceException {
        long currentTime = System.currentTimeMillis();
        this.getManagementServices().getAuditHelper().createAuditEvent("deleteResource");
        log.debug((Object)("list for uri: " + uri));
        if (uri == null) {
            log.warn((Object)("Delete: null resourceDescriptor for " + uri));
            throw new ServiceException(400, this.getMessage("remote.error.resourceNotFound"));
        }
        Resource resource = this.getManagementServices().locateResource(uri);
        if (resource == null) {
            log.warn((Object)("Delete: no access or not existing resource " + uri));
            throw new ServiceException(404, this.getMessage("remote.error.resourceNotFound"));
        }
        ResourceHandler rh = this.getManagementServices().getHandlerRegistry().getHandler(resource);
        if (rh == null) {
            log.warn((Object)("Delete: no resource handler found for resource " + uri));
            throw new ServiceException(404, "Unsupported resource type");
        }
        try {
            rh.delete(rh.get(resource, new HashMap()));
        }
        catch (ServiceException ex) {
            ex.setErrorCode(403);
            throw ex;
        }
    }

    public void deleteJob(long jobId) {
        try {
            this.getManagementServices().getSchedulerService().deleteJob(jobId);
        }
        catch (AxisFault axisFault) {
            throw new ServiceException(500, axisFault.getLocalizedMessage());
        }
    }
}

