/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.tool.hbm2x;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.hibernate.cfg.Configuration;
import org.hibernate.mapping.Table;
import org.hibernate.tool.hbm2x.AbstractExporter;
import org.hibernate.tool.hbm2x.ExporterException;
import org.hibernate.tool.hbm2x.VelocityProducer;
import org.hibernate.tool.hbm2x.doc.DocFile;
import org.hibernate.tool.hbm2x.doc.DocFileManager;
import org.hibernate.tool.hbm2x.doc.DocHelper;
import org.hibernate.tool.hbm2x.pojo.POJOClass;

public class DocExporter
extends AbstractExporter {
    private static final String FILE_CSS_DEFINITION = "doc/doc-style.css";
    private static final String FILE_HIBERNATE_IMAGE = "doc/hibernate_logo.gif";
    private static final String FILE_INDEX = "doc/index.html";
    private static final String FILE_HEADER = "doc/header.html";
    private static final String VM_TABLES_INDEX = "doc/tables/index.vm";
    private static final String VM_ENTITIES_INDEX = "doc/entities/index.vm";
    private static final String VM_ENTITIES_SUMMARY = "doc/entities/summary.vm";
    private static final String VM_ENTITIES_ENTITY = "doc/entities/entity.vm";
    private static final String VM_ENTITIES_PACKAGE_LIST = "doc/entities/package-list.vm";
    private static final String VM_ENTITIES_ENTITY_LIST = "doc/entities/allEntity-list.vm";
    private static final String VM_ENTITIES_PERPACKAGE_ENTITY_LIST = "doc/entities/perPackageEntity-list.vm";
    private static final String VM_ENTITIES_PACKAGE_SUMMARY = "doc/entities/package-summary.vm";
    private static final String VM_TABLES_SUMMARY = "doc/tables/summary.vm";
    private static final String VM_TABLES_TABLE_LIST = "doc/tables/table-list.vm";
    private static final String VM_TABLES_SCHEMA_LIST = "doc/tables/schema-list.vm";
    private static final String VM_TABLES_SCHEMA_SUMMARY = "doc/tables/schema-summary.vm";
    private static final String VM_TABLES_TABLE = "doc/tables/table.vm";
    private DocHelper docHelper;
    private DocFileManager docFileManager;
    private boolean jdk5 = false;

    public DocExporter(Configuration cfg, File outputdir) {
        super(cfg, outputdir);
    }

    public DocExporter() {
    }

    public void doStart() throws ExporterException {
        this.generateCommmonAndAssets();
        this.generateTablesIndex();
        this.generateTablesSummary();
        this.generateTablesDetails();
        this.generateTablesAllSchemasList();
        this.generateTablesAllTablesList();
        this.generateTablesSchemaTableList();
        this.generateTablesSchemaDetailedInfo();
        this.generateEntitiesIndex();
        this.generatePackageSummary();
        this.generateEntitiesDetails();
        this.generateEntitiesAllPackagesList();
        this.generateEntitiesAllEntitiesList();
        this.generateEntitiesPackageEntityList();
        this.generateEntitiesPackageDetailedInfo();
    }

    protected void setupContext() {
        this.getProperties().put("jdk5", "" + this.useJdk5());
        super.setupContext();
        this.docHelper = new DocHelper(this.getConfiguration(), this.getCfg2JavaTool());
        this.docFileManager = new DocFileManager(this.docHelper, this.getOutputDirectory());
        this.getTemplateHelper().putInContext("dochelper", this.docHelper);
        this.getTemplateHelper().putInContext("docFileManager", this.docFileManager);
    }

    public void generateCommmonAndAssets() {
        try {
            DocFile cssStylesDocFile = this.docFileManager.getCssStylesDocFile();
            DocFileManager.copy(FILE_CSS_DEFINITION, cssStylesDocFile.getFile());
            DocFile hibernateLogoDocFile = this.docFileManager.getHibernateImageDocFile();
            DocFileManager.copy(FILE_HIBERNATE_IMAGE, hibernateLogoDocFile.getFile());
            DocFile mainIndexDocFile = this.docFileManager.getMainIndexDocFile();
            DocFileManager.copy(FILE_INDEX, mainIndexDocFile.getFile());
            DocFile headerFile = this.docFileManager.getHeaderDocFile();
            DocFileManager.copy(FILE_HEADER, headerFile.getFile());
        }
        catch (IOException ioe) {
            throw new RuntimeException("Error while copying files.", ioe);
        }
    }

    public void generateTablesIndex() {
        DocFile docFile = this.docFileManager.getTableIndexDocFile();
        File file = docFile.getFile();
        HashMap<String, DocFile> parameters = new HashMap<String, DocFile>();
        parameters.put("docFile", docFile);
        this.processTemplate(parameters, VM_TABLES_INDEX, file);
    }

    public void generateEntitiesIndex() {
        DocFile docFile = this.docFileManager.getClassIndexDocFile();
        File file = docFile.getFile();
        HashMap<String, DocFile> parameters = new HashMap<String, DocFile>();
        parameters.put("docFile", docFile);
        this.processTemplate(parameters, VM_ENTITIES_INDEX, file);
    }

    public void generateTablesSummary() {
        DocFile docFile = this.docFileManager.getTableSummaryDocFile();
        File file = this.docFileManager.getTableSummaryDocFile().getFile();
        HashMap<String, DocFile> parameters = new HashMap<String, DocFile>();
        parameters.put("docFile", docFile);
        this.processTemplate(parameters, VM_TABLES_SUMMARY, file);
    }

    public void generatePackageSummary() {
        DocFile docFile = this.docFileManager.getClassSummaryFile();
        File file = docFile.getFile();
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("docFile", docFile);
        List list = this.docHelper.getPackages();
        list.remove(0);
        parameters.put("packageList", list);
        this.processTemplate(parameters, VM_ENTITIES_SUMMARY, file);
    }

    public void generateTablesDetails() {
        Iterator tables = this.getConfiguration().getTableMappings();
        while (tables.hasNext()) {
            Table table = (Table)tables.next();
            DocFile docFile = this.docFileManager.getTableDocFile(table);
            File file = docFile.getFile();
            HashMap<String, DocFile> parameters = new HashMap<String, DocFile>();
            parameters.put("docFile", docFile);
            parameters.put("table", (DocFile)table);
            this.processTemplate(parameters, VM_TABLES_TABLE, file);
        }
    }

    public void generateEntitiesDetails() {
        Iterator classes = this.docHelper.getClasses().iterator();
        while (classes.hasNext()) {
            POJOClass pcObj = (POJOClass)classes.next();
            pcObj.getPropertiesForMinimalConstructor();
            DocFile docFile = this.docFileManager.getEntityDocFile(pcObj);
            File file = docFile.getFile();
            HashMap<String, Object> parameters = new HashMap<String, Object>();
            parameters.put("docFile", docFile);
            parameters.put("class", pcObj);
            this.processTemplate(parameters, VM_ENTITIES_ENTITY, file);
        }
    }

    public void generateEntitiesAllPackagesList() {
        DocFile docFile = this.docFileManager.getAllPackagesDocFile();
        File file = docFile.getFile();
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("docFile", docFile);
        parameters.put("title", "Package List");
        List list = this.docHelper.getPackages();
        list.remove(0);
        parameters.put("packageList", list);
        this.processTemplate(parameters, VM_ENTITIES_PACKAGE_LIST, file);
    }

    public void generateEntitiesAllEntitiesList() {
        DocFile docFile = this.docFileManager.getAllEntitiesDocFile();
        File file = docFile.getFile();
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("docFile", docFile);
        parameters.put("title", "All Entities");
        parameters.put("classList", this.docHelper.getClasses());
        this.processTemplate(parameters, VM_ENTITIES_ENTITY_LIST, file);
    }

    public void generateEntitiesPackageEntityList() {
        Iterator packages = this.docHelper.getPackages().iterator();
        while (packages.hasNext()) {
            String packageName = (String)packages.next();
            if (packageName.equals("All Entities")) continue;
            DocFile docFile = this.docFileManager.getPackageEntityListDocFile(packageName);
            File file = docFile.getFile();
            HashMap<String, Object> parameters = new HashMap<String, Object>();
            parameters.put("docFile", docFile);
            parameters.put("title", packageName);
            parameters.put("classList", this.docHelper.getClasses(packageName));
            this.processTemplate(parameters, VM_ENTITIES_PERPACKAGE_ENTITY_LIST, file);
        }
    }

    public void generateEntitiesPackageDetailedInfo() {
        List packageList = this.docHelper.getPackages();
        packageList.remove(0);
        Iterator packages = packageList.iterator();
        while (packages.hasNext()) {
            String packageName = (String)packages.next();
            DocFile summaryDocFile = this.docFileManager.getPackageSummaryDocFile(packageName);
            HashMap<String, Object> parameters = new HashMap<String, Object>();
            parameters.put("docFile", summaryDocFile);
            parameters.put("package", packageName);
            parameters.put("classList", this.docHelper.getClasses(packageName));
            this.processTemplate(parameters, VM_ENTITIES_PACKAGE_SUMMARY, summaryDocFile.getFile());
        }
    }

    public void generateTablesAllSchemasList() {
        DocFile docFile = this.docFileManager.getAllSchemasDocFile();
        File file = docFile.getFile();
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("docFile", docFile);
        parameters.put("title", "Schema List");
        parameters.put("schemaList", this.docHelper.getSchemas());
        this.processTemplate(parameters, VM_TABLES_SCHEMA_LIST, file);
    }

    public void generateTablesAllTablesList() {
        DocFile docFile = this.docFileManager.getAllTablesDocFile();
        File file = docFile.getFile();
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("docFile", docFile);
        parameters.put("title", "All Tables");
        parameters.put("tableList", this.docHelper.getTables());
        this.processTemplate(parameters, VM_TABLES_TABLE_LIST, file);
    }

    public void generateTablesSchemaTableList() {
        Iterator schemas = this.docHelper.getSchemas().iterator();
        while (schemas.hasNext()) {
            String schemaName = (String)schemas.next();
            DocFile docFile = this.docFileManager.getSchemaTableListDocFile(schemaName);
            File file = docFile.getFile();
            HashMap<String, Object> parameters = new HashMap<String, Object>();
            parameters.put("docFile", docFile);
            parameters.put("title", "Tables for " + schemaName);
            parameters.put("tableList", this.docHelper.getTables(schemaName));
            this.processTemplate(parameters, VM_TABLES_TABLE_LIST, file);
        }
    }

    public void generateTablesSchemaDetailedInfo() {
        Iterator schemas = this.docHelper.getSchemas().iterator();
        while (schemas.hasNext()) {
            String schemaName = (String)schemas.next();
            DocFile summaryDocFile = this.docFileManager.getSchemaSummaryDocFile(schemaName);
            HashMap<String, Object> parameters = new HashMap<String, Object>();
            parameters.put("docFile", summaryDocFile);
            parameters.put("schema", schemaName);
            this.processTemplate(parameters, VM_TABLES_SCHEMA_SUMMARY, summaryDocFile.getFile());
            DocFile tableListDocFile = this.docFileManager.getSchemaSummaryDocFile(schemaName);
            parameters = new HashMap();
            parameters.put("docFile", tableListDocFile);
            parameters.put("schema", schemaName);
            this.processTemplate(parameters, VM_TABLES_SCHEMA_SUMMARY, tableListDocFile.getFile());
        }
    }

    protected void processTemplate(Map parameters, String templateName, File outputFile) {
        VelocityProducer producer = new VelocityProducer(this.getTemplateHelper(), this.getArtifactCollector());
        String filename = outputFile.toString();
        producer.produce(parameters, templateName, outputFile, templateName);
    }

    public String getName() {
        return "hbm2doc";
    }

    public boolean useJdk5() {
        return this.jdk5;
    }

    public void setJdk5(boolean jdk5) {
        this.jdk5 = jdk5;
    }
}

