<%--
  ~ Copyright (C) 2005 - 2011 Jaspersoft Corporation. All rights reserved.
  ~ http://www.jaspersoft.com.
  ~
  ~ Unless you have purchased  a commercial license agreement from Jaspersoft,
  ~ the following license terms  apply:
  ~
  ~ This program is free software: you can redistribute it and/or  modify
  ~ it under the terms of the GNU Affero General Public License  as
  ~ published by the Free Software Foundation, either version 3 of  the
  ~ License, or (at your option) any later version.
  ~
  ~ This program is distributed in the hope that it will be useful,
  ~ but WITHOUT ANY WARRANTY; without even the implied warranty of
  ~ MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
  ~ GNU Affero  General Public License for more details.
  ~
  ~ You should have received a copy of the GNU Affero General Public  License
  ~ along with this program. If not, see <http://www.gnu.org/licenses/>.
  --%>

<%@ page contentType="text/html" %>

<%@ taglib uri="http://java.sun.com/jsp/jstl/core" prefix="c" %>
<%@ taglib uri="http://java.sun.com/jsp/jstl/functions" prefix="fn" %>
<%@ taglib uri="/spring" prefix="spring" %>
<%@ taglib uri="/WEB-INF/jasperserver.tld" prefix="js" %>
<%@ taglib prefix="tiles" uri="http://tiles.apache.org/tags-tiles" %>

<%@ page import="org.apache.commons.lang.StringEscapeUtils" %>
<%@ page import="com.jaspersoft.jasperserver.war.webHelp.WebHelpLookup" %>
<%@ page import="com.jaspersoft.jasperserver.api.engine.common.service.impl.NavigationActionModelSupport" %>

<html>
<head>
    <title>Jaspersoft: <decorator:title/></title>
    <meta http-equiv="Content-Type" content="text/html; charset=${requestScope['com.jaspersoft.ji.characterEncoding']}">
    <meta http-equiv="X-UA-Compatible" content="IE=8"/>
    <link rel="shortcut icon" href="favicon.ico"/>

    <!-- General JasperServer Styles -->
    <link rel="stylesheet" href="${pageContext.request.contextPath}/themes/reset.css" type="text/css" media="screen">
    <!-- Theme -->

    <link rel="stylesheet" href="${pageContext.request.contextPath}/<spring:theme code="theme.css"/>" type="text/css" media="screen"/>
    <link rel="stylesheet" href="${pageContext.request.contextPath}/<spring:theme code="pages.css"/>" type="text/css" media="screen"/>
    <link rel="stylesheet" href="${pageContext.request.contextPath}/<spring:theme code="containers.css"/>" type="text/css" media="screen"/>
    <link rel="stylesheet" href="${pageContext.request.contextPath}/<spring:theme code="buttons.css"/>" type="text/css" media="screen"/>
    <link rel="stylesheet" href="${pageContext.request.contextPath}/<spring:theme code="lists.css"/>" type="text/css" media="screen"/>
    <link rel="stylesheet" href="${pageContext.request.contextPath}/<spring:theme code="controls.css"/>" type="text/css" media="screen"/>
    <link rel="stylesheet" href="${pageContext.request.contextPath}/<spring:theme code="dataDisplays.css"/>" type="text/css" media="screen"/>
    <link rel="stylesheet" href="${pageContext.request.contextPath}/<spring:theme code="pageSpecific.css"/>" type="text/css" media="screen"/>
    <link rel="stylesheet" href="${pageContext.request.contextPath}/<spring:theme code="dialogSpecific.css"/>" type="text/css" media="screen"/>

    <!--[if IE 7.0]>
    <link rel="stylesheet" href="${pageContext.request.contextPath}/<spring:theme code="overrides_ie7.css"/>" type="text/css" media="screen"/>
    <![endif]-->

    <!--[if IE 8.0]>
    <link rel="stylesheet" href="${pageContext.request.contextPath}/<spring:theme code="overrides_ie8.css"/>" type="text/css" media="screen"/>
    <![endif]-->

    <link rel="stylesheet" href="${pageContext.request.contextPath}/<spring:theme code="overrides_custom.css"/>" type="text/css" media="screen"/>

    <%--Online Help--%>
    <%@ include file="../jsp/modules/webHelp/webHelp.jsp" %>
    <%--Dynarch Caleandar Picker--%>
    <jsp:include page="/cal/calendar.jsp" flush="true"/>

    <!--script type="text/javascript" src="${pageContext.request.contextPath}/scripts/ext.utils.prototype.touch.js"></script-->
    <script type="text/javascript" src="${pageContext.request.contextPath}/scripts/ext.utils.prototype.js"></script>
    <script type="text/javascript" src="${pageContext.request.contextPath}/scripts/ext.utils.nwmatcher.js"></script>
    <script type="text/javascript" src="${pageContext.request.contextPath}/scripts/ext.utils.scriptaculous.js"></script>
    <!--script type="text/javascript" src="${pageContext.request.contextPath}/scripts/ext.utils.dragdrop.touch.js"></script-->
    <script type="text/javascript" src="${pageContext.request.contextPath}/scripts/ext.utils.dragdrop.extra.js"></script>
    <script type="text/javascript" src="${pageContext.request.contextPath}/scripts/tools.truncator.js"></script>
    <script type="text/javascript" src="${pageContext.request.contextPath}/scripts/utils.common.js"></script>
    <script type="text/javascript" src="${pageContext.request.contextPath}/scripts/core.layout.js"></script>
    <script type="text/javascript" src="${pageContext.request.contextPath}/scripts/core.events.js"></script>
    <script type="text/javascript" src="${pageContext.request.contextPath}/scripts/core.key.events.js"></script>
    <!--script type="text/javascript" src="${pageContext.request.contextPath}/scripts/core.touch.events.js"></script-->
    <script type="text/javascript" src="${pageContext.request.contextPath}/scripts/utils.animation.js"></script>
    <script type="text/javascript" src="${pageContext.request.contextPath}/scripts/tools.drag.js"></script>
    <script type="text/javascript" src="${pageContext.request.contextPath}/scripts/core.ajax.js"></script>
    <script type="text/javascript" src="${pageContext.request.contextPath}/scripts/actionModel.modelGenerator.js"></script>
    <script type="text/javascript" src="${pageContext.request.contextPath}/scripts/actionModel.primaryNavigation.js"></script>
    <script type="text/javascript" src="${pageContext.request.contextPath}/scripts/core.edition.js"></script>
    <script type="text/javascript" src="${pageContext.request.contextPath}/scripts/components.dialogs.js"></script>
    <script type="text/javascript" src="${pageContext.request.contextPath}/scripts/components.customTooltip.js"></script>
    <script type="text/javascript" src="${pageContext.request.contextPath}/scripts/components.tooltip.js"></script>
    <!--script type="text/javascript" src='${pageContext.request.contextPath}/scripts/components.tabs.js'></script-->
    <script type="text/javascript" src='${pageContext.request.contextPath}/scripts/components.toolbarButtons.js'></script>
    <script type="text/javascript" src='${pageContext.request.contextPath}/scripts/components.toolbarButtons.events.js'></script>
    <!--<script type="text/javascript" src='${pageContext.request.contextPath}/scripts/components.searchBox.js'></script>-->
    <script type="text/javascript" src="${pageContext.request.contextPath}/scripts/components.dialogs.js"></script>
    <!--<script type="text/javascript" src="${pageContext.request.contextPath}/scripts/components.about.js"></script>-->
    <script type="text/javascript" src="${pageContext.request.contextPath}/scripts/components.pickers.js"></script>
    <script type="text/javascript" src='${pageContext.request.contextPath}/scripts/list.base.js'></script>
    <script type="text/javascript" src='${pageContext.request.contextPath}/scripts/tree.nanotree.js'></script>
    <script type="text/javascript" src='${pageContext.request.contextPath}/scripts/tree.events.js'></script>
    <script type="text/javascript" src='${pageContext.request.contextPath}/scripts/tree.treenode.js'></script>
    <script type="text/javascript" src='${pageContext.request.contextPath}/scripts/tree.treesupport.js'></script>
    <script type="text/javascript" src="${pageContext.request.contextPath}/scripts/tree.utils.js"></script>
    <!--<script type="text/javascript" src="${pageContext.request.contextPath}/scripts/repository.search.globalSearchBoxInit.js"></script>-->
    <script type="text/javascript" src="${pageContext.request.contextPath}/scripts/core.initialize.js"></script>
    <script type="text/javascript" src="${pageContext.request.contextPath}/scripts/components.heartbeat.js"></script>

    <decorator:head/>
</head>

<body id="<decorator:getProperty property='body.id'/>" class="noDecoration <decorator:getProperty property='body.class'/>">

<%-- Markup that is common to all or most pages --%>

<%@ include file="../jsp/modules/webHelp/webHelp.jsp" %>
<%@ include file="../jsp/modules/common/jsEdition.jsp" %>

<%--
***********************************************************************
templates (for cloning) shared by all/most JasperServer pages
***********************************************************************
--%>
<%@ include file="../jsp/templates/menu.jsp" %>
<%@ include file="../jsp/templates/list.jsp" %>
<%@ include file="../jsp/modules/common/tooltip.jsp" %>
<%@ include file="../jsp/modules/common/dnd.jsp" %>

<%--
***********************************************************************
components (not for cloning) shared by all/most JasperServer pages
***********************************************************************
--%>
<!-- save as dialog -->
<tiles:insertTemplate template="/WEB-INF/jsp/templates/saveAs.jsp">
    <tiles:putAttribute name="containerClass" value="hidden centered_vert centered_horz"/>
    <tiles:putAttribute name="bodyContent">
        <ul class="responsive collapsible folders hideRoot" id="saveAsFoldersTree"></ul>
    </tiles:putAttribute>
</tiles:insertTemplate>

<!-- system confirm --><%-- not used? --%>
<jsp:include page="../jsp/modules/system/systemConfirm.jsp"/>

<!-- loading cue -->
<tiles:insertTemplate template="/WEB-INF/jsp/templates/loading.jsp">
    <tiles:putAttribute name="containerID" value="loading"/>
    <tiles:putAttribute name="containerClass" value="hidden"/>
</tiles:insertTemplate>

<!-- ajax alert popup dialog -->
<t:insertTemplate template="/WEB-INF/jsp/templates/standardAlert.jsp">
    <t:putAttribute name="containerClass" value="sizeable hidden"/>
    <t:putAttribute name="bodyContent">
        <div id="errorPopupContents"></div>
    </t:putAttribute>
</t:insertTemplate>

<%--
***********************************************************************
authorization for logged in user
***********************************************************************
--%>
<ul id="metaLinks" class="horizontal">
    <li id="userID">
        <authz:authorize ifNotGranted="ROLE_ANONYMOUS">
            <span id="casted">
                <c:if test="<%= com.jaspersoft.jasperserver.api.metadata.user.service.impl.UserAuthorityServiceImpl.isUserSwitched() %>">
                    <%= ((com.jaspersoft.jasperserver.api.metadata.user.domain.User)
                            com.jaspersoft.jasperserver.api.metadata.user.service.impl.UserAuthorityServiceImpl.
                                    getSourceAuthentication().getPrincipal()).getFullName() %>
                    <spring:message code="jsp.main.as"/>
                </c:if>
            </span>
            <authz:authentication property="principal.fullName"/>
        </authz:authorize>
    </li>
    <li id="help"><c:if test="${isProVersion}"><a href="#" id="helpLink"><spring:message code="decorator.helpLink"/></a></c:if>
    </li>
    <li id="main_logOut" class="last"><a id="main_logOut_link" href="#"><spring:message code="menu.logout"/></a></li>
</ul>

<%--
Hidden iframe for ajax downloads
--%>
<iframe id="ajax-download-iframe" style="visibility:hidden"></iframe>

<%--
Hidden iframe for ajax uploads
--%>
<iframe id="ajax-upload-iframe" style="visibility:hidden" src="about:blank"></iframe>

<%--heat beat info--%>
<jsp:include page="../jsp/modules/heartbeat/heartbeat.jsp"/>


<div id="frame">

    <c:if test="${pageProperties['meta.noMenu']==null}">
        <div id="mainNavigation" class="menu horizontal primaryNav">
            <ul id="navigationOptions" data-tab-index="2" data-component-type="navigation">
                <li id="main_home" tabIndex="-1" class="leaf"><p class="wrap button"><span class="icon"></span><spring:message code="menu.home"/></p></li>
            </ul>
        </div>
    </c:if>

    <!-- START decorated page content-->
    <decorator:body/>
    <!-- END decorated page content -->

</div>

<%--JavaScript which is common to all pages and requires JSTL access--%>
<%@ include file="../jsp/modules/commonJSTLScripts.jsp" %>
</body>
</html>