/*
 * Copyright (C) 2005 - 2011 Jaspersoft Corporation. All rights reserved.
 * http://www.jaspersoft.com.
 *
 * Unless you have purchased  a commercial license agreement from Jaspersoft,
 * the following license terms  apply:
 *
 * This program is free software: you can redistribute it and/or  modify
 * it under the terms of the GNU Affero General Public License  as
 * published by the Free Software Foundation, either version 3 of  the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU Affero  General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public  License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */

package com.jaspersoft.jasperserver.war.action;

import com.jaspersoft.jasperserver.api.metadata.common.domain.InputControl;
import com.jaspersoft.jasperserver.api.metadata.common.domain.client.InputControlImpl;
import com.jaspersoft.jasperserver.war.BaseUnitTest;
import com.jaspersoft.jasperserver.war.dto.RuntimeInputControlWrapper;
import org.junit.Test;
import org.springframework.webflow.context.servlet.ServletExternalContext;
import org.springframework.webflow.core.collection.MutableAttributeMap;
import org.springframework.webflow.core.collection.SharedAttributeMap;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.RequestContext;
import org.unitils.inject.annotation.TestedObject;
import org.unitils.mock.Mock;

import javax.servlet.http.HttpServletRequest;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import static org.junit.Assert.assertEquals;

/**
 * @author Vladimir Tsukur
 */
public class ViewReportActionTest extends BaseUnitTest {

    @TestedObject
    private ViewReportAction viewReportAction;

    private Mock<RequestContext> requestContext;

    private Mock<MutableAttributeMap> mutableAttributeMap;

    private Mock<ServletExternalContext> externalContext;

    private Mock<SharedAttributeMap> sessionMap;

    private Mock<Map> simpleSessionMap;

    private Mock<Map> sessionUUIDMap;

    private Mock<HttpServletRequest> httpServletRequest;
    
    private static final String DEFAULT_BOOLEAN_PARAMETER_NAME = "boolean";

    @Test
    public void parseRequestParametersForBooleanWhenValueIsNotNull() {
        List<RuntimeInputControlWrapper> wrappers = Arrays.asList(createBooleanInputControlWrapper());

        Map<String, String[]> parameterMap = new HashMap<String, String[]>();
        parameterMap.put(DEFAULT_BOOLEAN_PARAMETER_NAME, new String[] { "not-null-value" });

        programStandardParseRequestParametersMocking(wrappers, parameterMap);

        Event event = viewReportAction.parseRequestParameters(requestContext.getMock());
        assertEquals(event.getId(), "success");
        assertEquals(wrappers.get(0).getValue(), true);
    }

    @Test
    public void parseRequestParametersForBooleanWhenValueIsNull() {
        List<RuntimeInputControlWrapper> wrappers = Arrays.asList(createBooleanInputControlWrapper());

        Map<String, String[]> parameterMap = new HashMap<String, String[]>();
        parameterMap.put(DEFAULT_BOOLEAN_PARAMETER_NAME, new String[] { null });

        programStandardParseRequestParametersMocking(wrappers, parameterMap);

        Event event = viewReportAction.parseRequestParameters(requestContext.getMock());
        assertEquals(event.getId(), "success");
        assertEquals(wrappers.get(0).getValue(), false);
    }
    
    private RuntimeInputControlWrapper createBooleanInputControlWrapper() {
        InputControl inputControl = new InputControlImpl();
        inputControl.setName(DEFAULT_BOOLEAN_PARAMETER_NAME);
        inputControl.setType(InputControl.TYPE_BOOLEAN);
        return new RuntimeInputControlWrapper(inputControl);
    }

    private void programStandardParseRequestParametersMocking(List wrappers, Map parameterMap) {
        String wrappersFlowScopeUUID = "UUID";
        requestContext.returns(mutableAttributeMap).getFlowScope();
        mutableAttributeMap.returns(wrappersFlowScopeUUID).get(ReportParametersAction.WRAPPERS_FLOW_SCOPE_UUID);
        requestContext.returns(externalContext).getExternalContext();
        externalContext.returns(sessionMap).getSessionMap();
        sessionMap.returns(simpleSessionMap).asMap();
        simpleSessionMap.returns(sessionUUIDMap).get(ReportParametersAction.INPUTWRAPPERS_ATTR);
        sessionUUIDMap.returns(wrappers).get(wrappersFlowScopeUUID);

        mutableAttributeMap.returns(wrappers).get(ReportParametersAction.INPUTWRAPPERS_ATTR);
        externalContext.returns(httpServletRequest).getNativeRequest();
        httpServletRequest.returns(parameterMap).getParameterMap();
    }

}
