/*
 * Copyright (C) 2005 - 2011 Jaspersoft Corporation. All rights reserved.
 * http://www.jaspersoft.com.
 *
 * Unless you have purchased  a commercial license agreement from Jaspersoft,
 * the following license terms  apply:
 *
 * This program is free software: you can redistribute it and/or  modify
 * it under the terms of the GNU Affero General Public License  as
 * published by the Free Software Foundation, either version 3 of  the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU Affero  General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public  License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */

package com.jaspersoft.jasperserver.war.tags;

import java.util.HashMap;
import java.util.Map;

import javax.servlet.jsp.JspException;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.jaspersoft.jasperserver.war.dto.RuntimeInputControlWrapper;

/**
 * @author Lucian Chirita
 */
public class InputControlLabelTag extends LabelTag {

    protected static final Log log = LogFactory.getLog(InputControlLabelTag.class);

    public static final String INPUT_CONTROL_ATTRIBUTE_NAME = "control";
    public static final String CONTROL_LABEL_ATTRIBUTE_NAME = "controlLabel";

    private RuntimeInputControlWrapper control;

    protected int doStartTagInternal() {
        setLabelJsp("/WEB-INF/jsp/modules/inputControls/InputControlLabel.jsp");

        return SKIP_BODY;
    }

    @SuppressWarnings({"unchecked"})
    public int doEndTag() throws JspException {
        Map attributes = new HashMap();

        attributes.put(INPUT_CONTROL_ATTRIBUTE_NAME, getControl());
        attributes.put(CONTROL_LABEL_ATTRIBUTE_NAME, resolveLabel());

        includeNested(getLabelJsp(), attributes);

        return EVAL_PAGE;
    }

    protected String resolveLabel() {
        String promptLabel = (control.getControlInfo() != null) ? control.getControlInfo().getPromptLabel() : null;

        return resolveLabel((promptLabel != null && promptLabel.length() > 0) ? promptLabel :
                control.getInputControl().getLabel());
    }

    public RuntimeInputControlWrapper getControl() {
        return control;
    }

    public void setControl(RuntimeInputControlWrapper control) {
        this.control = control;
    }

}
