/*
 * Copyright (C) 2005 - 2011 Jaspersoft Corporation. All rights reserved.
 * http://www.jaspersoft.com.
 *
 * Unless you have purchased  a commercial license agreement from Jaspersoft,
 * the following license terms  apply:
 *
 * This program is free software: you can redistribute it and/or  modify
 * it under the terms of the GNU Affero General Public License  as
 * published by the Free Software Foundation, either version 3 of  the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU Affero  General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public  License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */

package com.jaspersoft.jasperserver.war.action;

import java.util.Map;

import com.jaspersoft.jasperserver.api.engine.common.service.EngineService;
import org.apache.log4j.Logger;
import org.springframework.webflow.action.MultiAction;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.RequestContext;

import com.jaspersoft.jasperserver.api.engine.jasperreports.service.impl.EngineServiceImpl;
import com.jaspersoft.jasperserver.api.metadata.common.domain.Resource;
import com.jaspersoft.jasperserver.api.metadata.common.service.RepositoryService;

public class ResourceTypeMappingAction extends MultiAction {
	private static Logger logger = Logger.getLogger(ResourceTypeMappingAction.class);
	
	private RepositoryService repositoryService;
	private Map<Class, Object> typeToActionBean;
	private String resourceUriAttributeName;
    private EngineService engineService;
	
	public Event doPreExecute(RequestContext context) {
		String resourceUri = context.getFlowScope().getRequiredString(resourceUriAttributeName);
		Resource resource = repositoryService.getResource(engineService.getRuntimeExecutionContext(), resourceUri);
		for (Class testResourceClass : typeToActionBean.keySet()) {
			if (testResourceClass.isInstance(resource)) {
				setTarget(typeToActionBean.get(testResourceClass));
				return null;
			}
		}
		throw new IllegalArgumentException("No matching action map for resource class " + resource.getName());
	}
	
	public RepositoryService getRepositoryService() {
		return repositoryService;
	}

	public void setRepositoryService(RepositoryService repositoryService) {
		this.repositoryService = repositoryService;
	}

	public void setTypeToActionBean(Map<Class, Object> typeToActionBean) {
		this.typeToActionBean = typeToActionBean;
	}

	public Map<Class, Object> getTypeToActionBean() {
		return typeToActionBean;
	}

	public void setResourceUriAttributeName(String resourceUriAttributeName) {
		this.resourceUriAttributeName = resourceUriAttributeName;
	}

	public String getResourceUriAttributeName() {
		return resourceUriAttributeName;
	}

    public void setEngineService(EngineService engineService) {
        this.engineService = engineService;
    }
}
