/*
 * Copyright (C) 2005 - 2011 Jaspersoft Corporation. All rights reserved.
 * http://www.jaspersoft.com.
 *
 * Unless you have purchased  a commercial license agreement from Jaspersoft,
 * the following license terms  apply:
 *
 * This program is free software: you can redistribute it and/or  modify
 * it under the terms of the GNU Affero General Public License  as
 * published by the Free Software Foundation, either version 3 of  the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU Affero  General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public  License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */

package com.jaspersoft.jasperserver.util.test;


import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.jaspersoft.jasperserver.api.metadata.common.service.RepositoryService;
import com.jaspersoft.jasperserver.api.common.domain.ExecutionContext;
import com.jaspersoft.jasperserver.api.metadata.user.service.UserAuthorityService;
import com.jaspersoft.jasperserver.api.common.domain.impl.ExecutionContextImpl;
import com.jaspersoft.jasperserver.export.Parameters;


public class SampleDataExportTest extends BaseExportTestCase {

    protected static Log log = LogFactory.getLog(SampleDataExportTest.class);

    private RepositoryService repo;
    private ExecutionContext context;
    private UserAuthorityService userAuthService;

    private static final String OUTPUT_ZIP_PARAM = "output-zip";
    private static final String OUTPUT_ZIP_DIR = "target/";
    private static final String OUTPUT_ZIP_FILE = "js-catalog-ce.zip";

    private static final String EVERYTHING_PARAM = "everything";
    private static final String URIS_PARAM = "uris";
    private static final String URIS_PARAM_VALUE = "/";

    public SampleDataExportTest(String name) {

    	super(name);
    }

    public void onSetUp() throws Exception {

    	super.onSetUp();

        repo = (RepositoryService) getBean("repositoryService");
        userAuthService = (UserAuthorityService) getBean("userAuthorityService");
        this.context = new ExecutionContextImpl();
    }

    public void testDemoSampleExport() {
    	Parameters params;

    	params = createParameters().addParameterValue(OUTPUT_ZIP_PARAM,
                                                      OUTPUT_ZIP_DIR + OUTPUT_ZIP_FILE);

    	params.addParameter(EVERYTHING_PARAM);

    	performExport(params);
    }

}
