package com.jaspersoft.jasperserver.api.metadata;

import com.jaspersoft.jasperserver.api.metadata.common.domain.*;
import com.jaspersoft.jasperserver.api.metadata.common.domain.client.DataTypeImpl;
import com.jaspersoft.jasperserver.api.metadata.common.domain.client.ListOfValuesItemImpl;
import com.jaspersoft.jasperserver.api.metadata.jasperreports.domain.ReportUnit;
import com.jaspersoft.jasperserver.util.test.BaseJasperServerTest;

import java.io.InputStream;

/**
 *  Adds reports to Sample Reports as an example of multi-lingual ICs usage.
 *
 *  @author Yuriy Plakosh
 */
public class MultiLingualInputControlsTest extends BaseJasperServerTest {

    public MultiLingualInputControlsTest(String name) {
        super(name);
        setAutowireMode(AUTOWIRE_BY_NAME);
    }

    public void testCreateReport() {
        Folder folder = getUnsecureRepositoryService().getFolder(null, "/reports/samples");

        createDepartment(folder);
    }

    private void setCommon(Resource res, String id) {
        res.setName(id);
        res.setLabel(id + "_label");
        res.setDescription(id + " description");
    }

    /**
     * Creates department report.
     *
     * @param folder a folder where report should be created.
     */
    private void createDepartment(Folder folder) {
        FileResource reportRes = (FileResource) getUnsecureRepositoryService().newResource(null, FileResource.class);
        reportRes.setFileType(FileResource.TYPE_JRXML);
        setCommon(reportRes, "DepartmentJRXML");

        InputStream jrxml = getClass().getResourceAsStream("/reports/jasper/Department.jrxml");
        reportRes.readData(jrxml);

        ReportUnit unit = (ReportUnit) getUnsecureRepositoryService().newResource(null, ReportUnit.class);
        unit.setName("Department");
        unit.setLabel("Department");
        unit.setDescription("A report that displays multi-lingual input controls");
        unit.setParentFolder(folder);

        unit.setDataSourceReference("/analysis/datasources/FoodmartDataSourceJNDI");
        unit.setMainReport(reportRes);

        // Gender.
        InputControl listInputControl = (InputControl) getUnsecureRepositoryService().newResource(null, InputControl.class);
        setCommon(listInputControl, "Gender");
        listInputControl.setType(InputControl.TYPE_MULTI_SELECT_LIST_OF_VALUES);
        listInputControl.setMandatory(true);
        listInputControl.setReadOnly(false);
        listInputControl.setVisible(true);
        listInputControl.setLabel("$R{Gender}");
        listInputControl.setName("gender");

        ListOfValues values = (ListOfValues) getUnsecureRepositoryService().newResource(null, ListOfValues.class);
        values.setName("Gender_list_of_values");
        values.setLabel("Gender list of values label");
        values.setDescription("Gender list of values description");
        ListOfValuesItem item = new ListOfValuesItemImpl();
        item.setLabel("$R{Male}");
        item.setValue("M");
        values.addValue(item);
        item = new ListOfValuesItemImpl();
        item.setLabel("$R{Female}");
        item.setValue("F");
        values.addValue(item);
        listInputControl.setListOfValues(values);

        DataType dataType = new DataTypeImpl();
        dataType.setName("gender_type");
        dataType.setLabel("gender_type");
        dataType.setType(DataType.TYPE_TEXT);
        listInputControl.setDataType(dataType);

        unit.addInputControl(listInputControl);

        // Marital status.
        listInputControl = (InputControl) getUnsecureRepositoryService().newResource(null, InputControl.class);
        setCommon(listInputControl, "Marital Status");
        listInputControl.setType(InputControl.TYPE_MULTI_SELECT_LIST_OF_VALUES_CHECKBOX);
        listInputControl.setMandatory(true);
        listInputControl.setReadOnly(false);
        listInputControl.setVisible(true);
        listInputControl.setLabel("$R{MaritalStatus}");
        listInputControl.setName("maritalStatus");

        values = (ListOfValues) getUnsecureRepositoryService().newResource(null, ListOfValues.class);
        values.setName("Marital_status_list_of_values");
        values.setLabel("Marital status list of values label");
        values.setDescription("Marital status list of values description");
        item = new ListOfValuesItemImpl();
        item.setLabel("$R{Married}");
        item.setValue("M");
        values.addValue(item);
        item = new ListOfValuesItemImpl();
        item.setLabel("$R{Single}");
        item.setValue("S");
        values.addValue(item);
        listInputControl.setListOfValues(values);

        dataType = new DataTypeImpl();
        dataType.setName("maritalStatus_type");
        dataType.setLabel("maritalStatus_type");
        dataType.setType(DataType.TYPE_TEXT);
        listInputControl.setDataType(dataType);

        unit.addInputControl(listInputControl);

        // Department.
        listInputControl = (InputControl) getUnsecureRepositoryService().newResource(null, InputControl.class);
        setCommon(listInputControl, "Department");
        listInputControl.setType(InputControl.TYPE_SINGLE_SELECT_LIST_OF_VALUES);
        listInputControl.setMandatory(true);
        listInputControl.setReadOnly(false);
        listInputControl.setVisible(true);
        listInputControl.setLabel("$R{Department}");
        listInputControl.setName("department");

        values = (ListOfValues) getUnsecureRepositoryService().newResource(null, ListOfValues.class);
        values.setName("Department_list_of_values");
        values.setLabel("Department list of values label");
        values.setDescription("Department list of values description");
        item = new ListOfValuesItemImpl();
        item.setLabel("$R{Dep1}");
        item.setValue(1);
        values.addValue(item);
        item = new ListOfValuesItemImpl();
        item.setLabel("$R{Dep2}");
        item.setValue(2);
        values.addValue(item);
        item = new ListOfValuesItemImpl();
        item.setLabel("$R{Dep3}");
        item.setValue(3);
        values.addValue(item);
        item = new ListOfValuesItemImpl();
        item.setLabel("$R{Dep4}");
        item.setValue(4);
        values.addValue(item);
        item = new ListOfValuesItemImpl();
        item.setLabel("$R{Dep5}");
        item.setValue(5);
        values.addValue(item);
        item = new ListOfValuesItemImpl();
        item.setLabel("$R{Dep11}");
        item.setValue(11);
        values.addValue(item);
        item = new ListOfValuesItemImpl();
        item.setLabel("$R{Dep14}");
        item.setValue(14);
        values.addValue(item);
        item = new ListOfValuesItemImpl();
        item.setLabel("$R{Dep15}");
        item.setValue(15);
        values.addValue(item);
        item = new ListOfValuesItemImpl();
        item.setLabel("$R{Dep16}");
        item.setValue(16);
        values.addValue(item);
        item = new ListOfValuesItemImpl();
        item.setLabel("$R{Dep17}");
        item.setValue(17);
        values.addValue(item);
        item = new ListOfValuesItemImpl();
        item.setLabel("$R{Dep18}");
        item.setValue(18);
        values.addValue(item);
        item = new ListOfValuesItemImpl();
        item.setLabel("$R{Dep19}");
        item.setValue(19);
        values.addValue(item);
        listInputControl.setListOfValues(values);

        dataType = new DataTypeImpl();
        dataType.setName("department_type");
        dataType.setLabel("department_type");
        dataType.setType(DataType.TYPE_NUMBER);
        listInputControl.setDataType(dataType);

        unit.addInputControl(listInputControl);

        FileResource resBdl = (FileResource) getRepositoryService().newResource(null, FileResource.class);
        resBdl.setFileType(FileResource.TYPE_RESOURCE_BUNDLE);
        resBdl.readData(getClass().getResourceAsStream("/resource_bundles/department.properties"));
        setCommon(resBdl, "department.properties");
        unit.addResource(resBdl);

        resBdl = (FileResource) getRepositoryService().newResource(null, FileResource.class);
        resBdl.setFileType(FileResource.TYPE_RESOURCE_BUNDLE);
        resBdl.readData(getClass().getResourceAsStream("/resource_bundles/department_fr.properties"));
        setCommon(resBdl, "department_fr.properties");
        unit.addResource(resBdl);

        resBdl = (FileResource) getRepositoryService().newResource(null, FileResource.class);
        resBdl.setFileType(FileResource.TYPE_RESOURCE_BUNDLE);
        resBdl.readData(getClass().getResourceAsStream("/resource_bundles/department_es.properties"));
        setCommon(resBdl, "department_es.properties");
        unit.addResource(resBdl);

        getUnsecureRepositoryService().saveResource(null, unit);
    }
}
