/*
 * Copyright (C) 2005 - 2011 Jaspersoft Corporation. All rights reserved.
 * http://www.jaspersoft.com.
 *
 * Unless you have purchased  a commercial license agreement from Jaspersoft,
 * the following license terms  apply:
 *
 * This program is free software: you can redistribute it and/or  modify
 * it under the terms of the GNU Affero General Public License  as
 * published by the Free Software Foundation, either version 3 of  the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU Affero  General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public  License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */

package com.jaspersoft.jasperserver.api.metadata.common.service.impl.hibernate.util;

import com.jaspersoft.jasperserver.api.JSException;
import com.jaspersoft.jasperserver.api.metadata.common.domain.Folder;

/**
 * @author Lucian Chirita
 *
 */
public class RepositoryUtils {

	public static String getParentPath(String path) {
		if (path.equals(Folder.SEPARATOR)) {
			return null;
		}
		
		int lastSep = path.lastIndexOf(Folder.SEPARATOR);
		if (lastSep < 0) {
			throw new JSException("Path " + path + " is not an absolute repository path");
		}
		
		String parentPath;
		if (lastSep == 0) {
			parentPath = Folder.SEPARATOR;
		} else {
			parentPath = path.substring(0, lastSep);
		}
		return parentPath;
	}
	
	public static String getName(String path) {
		if (path.equals(Folder.SEPARATOR)) {
			return Folder.SEPARATOR;
		}
		
		int lastSep = path.lastIndexOf(Folder.SEPARATOR);
		if (lastSep < 0) {
			throw new JSException("Path " + path + " is not an absolute repository path");
		}
		
		return path.substring(lastSep + 1);
	}

	public static String concatenatePath(String parentPath, String name) {
		StringBuffer concantenated = new StringBuffer(parentPath);
		if (!parentPath.equals(Folder.SEPARATOR)) {
			concantenated.append(Folder.SEPARATOR);
		}
		concantenated.append(name);
		return concantenated.toString();
	}

	public static String concatenatePaths(String parentPath, String path) {
		StringBuffer concantenated = new StringBuffer();
		if (parentPath.equals(Folder.SEPARATOR)) {
			concantenated.append(path);
		} else {
			concantenated.append(parentPath);
			if (!path.equals(Folder.SEPARATOR)) {
				concantenated.append(path);
			}
		}
		return concantenated.toString();
	}
	
	/**
	 * Determines whether a repository path is an ancestor of another path.
	 * 
	 * @param parent the parent path
	 * @param path the path
	 * @return whether <code>parent</code> is an ancestor of <path>
	 */
	public static boolean isAncestorOrEqual(String ancestorPath, String path) {
		//if equal
		if (ancestorPath.equals(path)) {
			return true;
		}
		
		//if ancestor path is not a prefix
		if (!path.startsWith(ancestorPath)) {
			return false;
		}
		
		//if the ancestor is /, or the ancestor is followed by a / in the child path
		return Folder.SEPARATOR.equals(ancestorPath) 
				|| path.substring(ancestorPath.length()).startsWith(Folder.SEPARATOR);
	}
}
