/*
 * Copyright (C) 2005 - 2011 Jaspersoft Corporation. All rights reserved.
 * http://www.jaspersoft.com.
 *
 * Unless you have purchased  a commercial license agreement from Jaspersoft,
 * the following license terms  apply:
 *
 * This program is free software: you can redistribute it and/or  modify
 * it under the terms of the GNU Affero General Public License  as
 * published by the Free Software Foundation, either version 3 of  the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU Affero  General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public  License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */
package com.jaspersoft.jasperserver.api.engine.scheduling;

import com.jaspersoft.jasperserver.api.metadata.common.service.RepositoryEventListenerSupport;
import com.jaspersoft.jasperserver.api.metadata.common.service.impl.FolderMoveEvent;
import com.jaspersoft.jasperserver.api.metadata.common.service.impl.RepositoryListener;
import com.jaspersoft.jasperserver.api.metadata.common.service.impl.ResourceMoveEvent;
import com.jaspersoft.jasperserver.api.metadata.jasperreports.domain.ReportUnit;

/**
 * @author Lucian Chirita (lucianc@users.sourceforge.net)
 * @version $Id: SchedulingReportDeleteListener.java 19922 2010-12-11 14:59:51Z tmatyashovsky $
 */
public class SchedulingReportDeleteListener extends RepositoryEventListenerSupport implements RepositoryListener {

	private ReportSchedulingInternalService schedulingService;
	
	public void onResourceDelete(Class resourceItf, String resourceURI) {
		if (ReportUnit.class.isAssignableFrom(resourceItf)) {
			schedulingService.removeReportUnitJobs(resourceURI);
		}
	}

	public ReportSchedulingInternalService getSchedulingService() {
		return schedulingService;
	}

	public void setSchedulingService(
			ReportSchedulingInternalService schedulingService) {
		this.schedulingService = schedulingService;
	}

	public void folderMoved(FolderMoveEvent folderMove) {
		// NOOP
	}

	public void resourceMoved(ResourceMoveEvent resourceMove) {
		if (ReportUnit.class.isAssignableFrom(resourceMove.getResourceType())) {
			schedulingService.updateReportUnitURI(
					resourceMove.getOldResourceURI(), resourceMove.getNewResourceURI());
		}
	}

}
