/*
// This java file was automatically generated
// from XOM model 'aggregates'
// on Tue Jun 01 16:27:55 GMT-05:00 2010
// Do not edit this file by hand.
*/

package mondrian.rolap.aggmatcher;
/**
 * This is the XML model for defining default aggregate table recognition
 * and level/measure mapping.
 * Revision is $Id: //open/mondrian-release/3.2/src/main/mondrian/rolap/aggmatcher/DefaultRulesSchema.xml#1 $
 * <p>This class was generated from XOM model 'aggregates' on Tue Jun 01 16:27:55 GMT-05:00 2010
 */
public class DefaultDef {

	public static java.lang.Class getXMLDefClass()
	{
		return DefaultDef.class;
	}

	public static String[] _elements = {
		"AggRules",
		"Base",
		"CaseMatcher",
		"NameMatcher",
		"FactCountMatch",
		"ForeignKeyMatch",
		"TableMatch",
		"Mapper",
		"Regex",
		"RegexMapper",
		"Ref",
		"LevelMapRef",
		"MeasureMapRef",
		"IgnoreMapRef",
		"FactCountMatchRef",
		"ForeignKeyMatchRef",
		"TableMatchRef",
		"LevelMap",
		"MeasureMap",
		"IgnoreMap",
		"AggRule"
	};

	/**
	 * The set of "named" rules for matching aggregate tables.
	 * Only one rule can be applied to a given connection. In
	 * addition, one rule must be set as the default - this rule
	 * is always the choice when not selecting by name.
	 * It is very important that the AggRules validate method is called
	 * prior to using any of the object.
	 */
	public static class AggRules extends org.eigenbase.xom.ElementDef
	{
		public AggRules()
		{
		}

		public AggRules(org.eigenbase.xom.DOMWrapper _def)
			throws org.eigenbase.xom.XOMException
		{
			try {
				org.eigenbase.xom.DOMElementParser _parser = new org.eigenbase.xom.DOMElementParser(_def, "", DefaultDef.class);
				org.eigenbase.xom.NodeDef[] _tempArray;
				tag = (String)_parser.getAttribute("tag", "String", null, null, true);
				_tempArray = _parser.getArray(TableMatch.class, 0, 0);
				tableMatches = new TableMatch[_tempArray.length];
				for (int _i = 0; _i < tableMatches.length; _i++)
					tableMatches[_i] = (TableMatch)_tempArray[_i];
				_tempArray = _parser.getArray(FactCountMatch.class, 0, 0);
				factCountMatches = new FactCountMatch[_tempArray.length];
				for (int _i = 0; _i < factCountMatches.length; _i++)
					factCountMatches[_i] = (FactCountMatch)_tempArray[_i];
				_tempArray = _parser.getArray(ForeignKeyMatch.class, 0, 0);
				foreignKeyMatches = new ForeignKeyMatch[_tempArray.length];
				for (int _i = 0; _i < foreignKeyMatches.length; _i++)
					foreignKeyMatches[_i] = (ForeignKeyMatch)_tempArray[_i];
				_tempArray = _parser.getArray(LevelMap.class, 0, 0);
				levelMaps = new LevelMap[_tempArray.length];
				for (int _i = 0; _i < levelMaps.length; _i++)
					levelMaps[_i] = (LevelMap)_tempArray[_i];
				_tempArray = _parser.getArray(MeasureMap.class, 0, 0);
				measureMaps = new MeasureMap[_tempArray.length];
				for (int _i = 0; _i < measureMaps.length; _i++)
					measureMaps[_i] = (MeasureMap)_tempArray[_i];
				_tempArray = _parser.getArray(IgnoreMap.class, 0, 0);
				ignoreMaps = new IgnoreMap[_tempArray.length];
				for (int _i = 0; _i < ignoreMaps.length; _i++)
					ignoreMaps[_i] = (IgnoreMap)_tempArray[_i];
				_tempArray = _parser.getArray(AggRule.class, 1, 0);
				aggRules = new AggRule[_tempArray.length];
				for (int _i = 0; _i < aggRules.length; _i++)
					aggRules[_i] = (AggRule)_tempArray[_i];
			} catch(org.eigenbase.xom.XOMException _ex) {
				throw new org.eigenbase.xom.XOMException("In " + getName() + ": " + _ex.getMessage());
			}
		}

		public String tag;  // required attribute

		/**
		 * All shared TableMatches.
		 */
		public TableMatch[] tableMatches;  //optional array
		/**
		 * All shared FactCountMatches.
		 */
		public FactCountMatch[] factCountMatches;  //optional array
		/**
		 * All shared ForeignKeyMatches.
		 */
		public ForeignKeyMatch[] foreignKeyMatches;  //optional array
		/**
		 * All shared LevelMap.
		 */
		public LevelMap[] levelMaps;  //optional array
		/**
		 * All shared MeasureMap.
		 */
		public MeasureMap[] measureMaps;  //optional array
		/**
		 * All shared IgnoreMap.
		 */
		public IgnoreMap[] ignoreMaps;  //optional array
		/**
		 * All AggRules (at least one).
		 * Also, one of them must be marked with default=true.
		 */
		public AggRule[] aggRules;  //min 1

		public String getName()
		{
			return "AggRules";
		}

		public void display(java.io.PrintWriter _out, int _indent)
		{
			_out.println(getName());
			displayAttribute(_out, "tag", tag, _indent+1);
			displayElementArray(_out, "tableMatches", tableMatches, _indent+1);
			displayElementArray(_out, "factCountMatches", factCountMatches, _indent+1);
			displayElementArray(_out, "foreignKeyMatches", foreignKeyMatches, _indent+1);
			displayElementArray(_out, "levelMaps", levelMaps, _indent+1);
			displayElementArray(_out, "measureMaps", measureMaps, _indent+1);
			displayElementArray(_out, "ignoreMaps", ignoreMaps, _indent+1);
			displayElementArray(_out, "aggRules", aggRules, _indent+1);
		}
		public void displayXML(org.eigenbase.xom.XMLOutput _out, int _indent)
		{
			_out.beginTag("AggRules", new org.eigenbase.xom.XMLAttrVector()
				.add("tag", tag)
				);
			displayXMLElementArray(_out, tableMatches);
			displayXMLElementArray(_out, factCountMatches);
			displayXMLElementArray(_out, foreignKeyMatches);
			displayXMLElementArray(_out, levelMaps);
			displayXMLElementArray(_out, measureMaps);
			displayXMLElementArray(_out, ignoreMaps);
			displayXMLElementArray(_out, aggRules);
			_out.endTag("AggRules");
		}
		public boolean displayDiff(org.eigenbase.xom.ElementDef _other, java.io.PrintWriter _out, int _indent)
		{
			AggRules _cother = (AggRules)_other;
			boolean _diff = displayAttributeDiff("tag", tag, _cother.tag, _out, _indent+1);
			_diff = _diff && displayElementArrayDiff("tableMatches", tableMatches, _cother.tableMatches, _out, _indent+1);
			_diff = _diff && displayElementArrayDiff("factCountMatches", factCountMatches, _cother.factCountMatches, _out, _indent+1);
			_diff = _diff && displayElementArrayDiff("foreignKeyMatches", foreignKeyMatches, _cother.foreignKeyMatches, _out, _indent+1);
			_diff = _diff && displayElementArrayDiff("levelMaps", levelMaps, _cother.levelMaps, _out, _indent+1);
			_diff = _diff && displayElementArrayDiff("measureMaps", measureMaps, _cother.measureMaps, _out, _indent+1);
			_diff = _diff && displayElementArrayDiff("ignoreMaps", ignoreMaps, _cother.ignoreMaps, _out, _indent+1);
			_diff = _diff && displayElementArrayDiff("aggRules", aggRules, _cother.aggRules, _out, _indent+1);
			return _diff;
		}
		// BEGIN pass-through code block ---
private static final org.apache.log4j.Logger LOGGER =
                org.apache.log4j.Logger.getLogger(DefaultDef.class);

            protected static org.apache.log4j.Logger getLogger() {
                return LOGGER;
            }

            public String getTag() {
                return tag;
            }

            public AggRule getAggRule(String tag) {
                for (int i = 0; i < aggRules.length; i++) {
                    AggRule aggRule = aggRules[i];
                    if (aggRule.isEnabled() && aggRule.getTag().equals(tag)) {
                        return aggRule;
                    }
                }
                return null;
            }

            public void validate(final mondrian.recorder.MessageRecorder msgRecorder) {
                msgRecorder.pushContextName(getName());
                try {
                    validate(factCountMatches, msgRecorder);
                    validate(tableMatches, msgRecorder);
                    validate(levelMaps, msgRecorder);
                    validate(measureMaps, msgRecorder);
                    validate(ignoreMaps, msgRecorder);
                    validate(aggRules, msgRecorder);
                } finally {
                    msgRecorder.popContextName();
                }
            }
            private void validate(final Base[] bases,
                                  final mondrian.recorder.MessageRecorder msgRecorder) {
                for (int i = 0; i < bases.length; i++) {
                    Base base = bases[i];
                    if (base.isEnabled()) {
                        base.validate(this, msgRecorder);
                    }
                }
            }

            public boolean hasIgnoreMap(String id) {
                return (lookupIgnoreMap(id) != null);
            }
            public IgnoreMap lookupIgnoreMap(String id) {
                return (IgnoreMap) lookupBase(id, ignoreMaps);
            }

            public boolean hasFactCountMatch(String id) {
                return (lookupFactCountMatch(id) != null);
            }
            public FactCountMatch lookupFactCountMatch(String id) {
                return (FactCountMatch) lookupBase(id, factCountMatches);
            }

            public boolean hasForeignKeyMatch(String id) {
                return (lookupForeignKeyMatch(id) != null);
            }
            public ForeignKeyMatch lookupForeignKeyMatch(String id) {
                return (ForeignKeyMatch) lookupBase(id, foreignKeyMatches);
            }

            public boolean hasTableMatch(String id) {
                return (lookupTableMatch(id) != null);
            }
            public TableMatch lookupTableMatch(String id) {
                return (TableMatch) lookupBase(id, tableMatches);
            }

            public boolean hasLevelMap(String id) {
                return (lookupLevelMap(id) != null);
            }
            public LevelMap lookupLevelMap(String id) {
                return (LevelMap) lookupBase(id, levelMaps);
            }

            public boolean hasMeasureMap(String id) {
                return (lookupMeasureMap(id) != null);
            }
            public MeasureMap lookupMeasureMap(String id) {
                return (MeasureMap) lookupBase(id, measureMaps);
            }

            public boolean hasAggRule(String id) {
                return (lookupAggRule(id) != null);
            }
            public AggRule lookupAggRule(String id) {
                return (AggRule) lookupBase(id, aggRules);
            }

            private Base lookupBase(String tag, Base[] bases) {
                for (int i = 0; i < bases.length; i++) {
                    Base base = bases[i];
                    if (base.isEnabled() && base.getTag().equals(tag)) {
                        return base;
                    }
                }
                return null;
            }

            public IgnoreMap[] getIgnoreMaps() {
                return ignoreMaps;
            }
            public FactCountMatch[] getFactCountMatches() {
                return factCountMatches;
            }
            public ForeignKeyMatch[] getForeignKeyMatches() {
                return foreignKeyMatches;
            }
            public TableMatch[] getTableMatches() {
                return tableMatches;
            }
            public LevelMap[] getLevelMaps() {
                return levelMaps;
            }
            public MeasureMap[] getMeasureMaps() {
                return measureMaps;
            }
            public AggRule[] getAggRules() {
                return aggRules;
            }
		// END pass-through code block ---
	}

	/**
	 * Base is the base class for all of the elements.
	 * All elements can be enabled or not, have a tag, and
	 * can be validated.
	 */
	public static abstract class Base extends org.eigenbase.xom.ElementDef
	{
		public Base()
		{
		}

		public Base(org.eigenbase.xom.DOMWrapper _def)
			throws org.eigenbase.xom.XOMException
		{
			try {
				org.eigenbase.xom.DOMElementParser _parser = new org.eigenbase.xom.DOMElementParser(_def, "", DefaultDef.class);
				enabled = (Boolean)_parser.getAttribute("enabled", "Boolean", "true", null, false);
			} catch(org.eigenbase.xom.XOMException _ex) {
				throw new org.eigenbase.xom.XOMException("In " + getName() + ": " + _ex.getMessage());
			}
		}

		public Boolean enabled;  // attribute default: true


		public String getName()
		{
			return "Base";
		}

		public void display(java.io.PrintWriter _out, int _indent)
		{
			_out.println(getName());
			displayAttribute(_out, "enabled", enabled, _indent+1);
		}
		public void displayXML(org.eigenbase.xom.XMLOutput _out, int _indent)
		{
			_out.beginTag("(%Base;)", new org.eigenbase.xom.XMLAttrVector()
				.add("enabled", enabled)
				);
			_out.endTag("(%Base;)");
		}
		public boolean displayDiff(org.eigenbase.xom.ElementDef _other, java.io.PrintWriter _out, int _indent)
		{
			Base _cother = (Base)_other;
			boolean _diff = displayAttributeDiff("enabled", enabled, _cother.enabled, _out, _indent+1);
			return _diff;
		}
		// BEGIN pass-through code block ---
public boolean isEnabled() {
                return enabled.booleanValue();
            }
            protected abstract String getTag();
            public abstract void validate(final AggRules rules,
                                          final mondrian.recorder.MessageRecorder msgRecorder);
		// END pass-through code block ---
	}

	/**
	 * This is a base class for all elements that can match strings
	 * where the case of the string is important. In addition,
	 * it has an id which services as its tag.
	 */
	public static abstract class CaseMatcher extends Base
	{
		public CaseMatcher()
		{
		}

		public CaseMatcher(org.eigenbase.xom.DOMWrapper _def)
			throws org.eigenbase.xom.XOMException
		{
			try {
				org.eigenbase.xom.DOMElementParser _parser = new org.eigenbase.xom.DOMElementParser(_def, "", DefaultDef.class);
				id = (String)_parser.getAttribute("id", "String", null, null, true);
				charcase = (String)_parser.getAttribute("charcase", "String", "ignore", _charcase_values, false);
				enabled = (Boolean)_parser.getAttribute("enabled", "Boolean", "true", null, false);
			} catch(org.eigenbase.xom.XOMException _ex) {
				throw new org.eigenbase.xom.XOMException("In " + getName() + ": " + _ex.getMessage());
			}
		}

		public String id;  // required attribute
		/** Allowable values for {@link #charcase}. */
		public static final String[] _charcase_values = {"ignore", "exact", "upper", "lower"};
		public String charcase;  // attribute default: ignore


		public String getName()
		{
			return "CaseMatcher";
		}

		public void display(java.io.PrintWriter _out, int _indent)
		{
			_out.println(getName());
			displayAttribute(_out, "id", id, _indent+1);
			displayAttribute(_out, "charcase", charcase, _indent+1);
			displayAttribute(_out, "enabled", enabled, _indent+1);
		}
		public void displayXML(org.eigenbase.xom.XMLOutput _out, int _indent)
		{
			_out.beginTag("(%CaseMatcher;)", new org.eigenbase.xom.XMLAttrVector()
				.add("id", id)
				.add("charcase", charcase)
				.add("enabled", enabled)
				);
			_out.endTag("(%CaseMatcher;)");
		}
		public boolean displayDiff(org.eigenbase.xom.ElementDef _other, java.io.PrintWriter _out, int _indent)
		{
			CaseMatcher _cother = (CaseMatcher)_other;
			boolean _diff = displayAttributeDiff("id", id, _cother.id, _out, _indent+1);
			_diff = _diff && displayAttributeDiff("charcase", charcase, _cother.charcase, _out, _indent+1);
			return _diff;
		}
		// BEGIN pass-through code block ---
public void validate(final AggRules rules,
                                 final mondrian.recorder.MessageRecorder msgRecorder) {
                // empty
            }
            protected String getTag() {
                return getId();
            }
            public String getId() {
                return id;
            }
            public String getCharCase() {
                return charcase;
            }
		// END pass-through code block ---
	}

	/**
	 * A NameMatcher is a CaseMatcher that prepends and appends
	 * regular expressions to a given string as part of creating
	 * the matching regular expression. Both the pre/post
	 * regular expression can be null in which case matches are
	 * applied simply against the name (modulo case considerations).
	 * The purpose of this class is to allow aggregate tables to
	 * be identified when their table names are formed by placing
	 * text before and/or after the base fact table name.
	 */
	public static abstract class NameMatcher extends CaseMatcher
	{
		public NameMatcher()
		{
		}

		public NameMatcher(org.eigenbase.xom.DOMWrapper _def)
			throws org.eigenbase.xom.XOMException
		{
			try {
				org.eigenbase.xom.DOMElementParser _parser = new org.eigenbase.xom.DOMElementParser(_def, "", DefaultDef.class);
				pretemplate = (String)_parser.getAttribute("pretemplate", "String", null, null, false);
				posttemplate = (String)_parser.getAttribute("posttemplate", "String", null, null, false);
				basename = (String)_parser.getAttribute("basename", "String", null, null, false);
				id = (String)_parser.getAttribute("id", "String", null, null, true);
				charcase = (String)_parser.getAttribute("charcase", "String", "ignore", _charcase_values, false);
				enabled = (Boolean)_parser.getAttribute("enabled", "Boolean", "true", null, false);
			} catch(org.eigenbase.xom.XOMException _ex) {
				throw new org.eigenbase.xom.XOMException("In " + getName() + ": " + _ex.getMessage());
			}
		}

		public String pretemplate;  // optional attribute
		public String posttemplate;  // optional attribute
		public String basename;  // optional attribute


		public String getName()
		{
			return "NameMatcher";
		}

		public void display(java.io.PrintWriter _out, int _indent)
		{
			_out.println(getName());
			displayAttribute(_out, "pretemplate", pretemplate, _indent+1);
			displayAttribute(_out, "posttemplate", posttemplate, _indent+1);
			displayAttribute(_out, "basename", basename, _indent+1);
			displayAttribute(_out, "id", id, _indent+1);
			displayAttribute(_out, "charcase", charcase, _indent+1);
			displayAttribute(_out, "enabled", enabled, _indent+1);
		}
		public void displayXML(org.eigenbase.xom.XMLOutput _out, int _indent)
		{
			_out.beginTag("(%NameMatcher;)", new org.eigenbase.xom.XMLAttrVector()
				.add("pretemplate", pretemplate)
				.add("posttemplate", posttemplate)
				.add("basename", basename)
				.add("id", id)
				.add("charcase", charcase)
				.add("enabled", enabled)
				);
			_out.endTag("(%NameMatcher;)");
		}
		public boolean displayDiff(org.eigenbase.xom.ElementDef _other, java.io.PrintWriter _out, int _indent)
		{
			NameMatcher _cother = (NameMatcher)_other;
			boolean _diff = displayAttributeDiff("pretemplate", pretemplate, _cother.pretemplate, _out, _indent+1);
			_diff = _diff && displayAttributeDiff("posttemplate", posttemplate, _cother.posttemplate, _out, _indent+1);
			_diff = _diff && displayAttributeDiff("basename", basename, _cother.basename, _out, _indent+1);
			return _diff;
		}
		// BEGIN pass-through code block ---
java.util.regex.Pattern baseNamePattern = null;
            public void validate(final AggRules rules,
                                 final mondrian.recorder.MessageRecorder msgRecorder) {
                msgRecorder.pushContextName(getName());
                try {
                    super.validate(rules, msgRecorder);

                    if (basename != null) {
                        baseNamePattern =
                            java.util.regex.Pattern.compile(basename);
                    }
                } finally {
                    msgRecorder.popContextName();
                }
            }

            /**
             * Generates a regular expression string by prepending and
             * appending regular expression to the parameter tableName.
             *
             * @param name Table name
             * @return regular expression
             */
            public String getRegex(final String name) {
                StringBuilder buf = new StringBuilder();
                if (pretemplate != null) {
                    buf.append(pretemplate);
                }
                if (name != null) {
                    String n = name;
                    if (baseNamePattern != null) {
                        java.util.regex.Matcher matcher =
                            baseNamePattern.matcher(name);
                        if (matcher.matches() && matcher.groupCount() > 0) {
                            n = matcher.group(1);

                        } else {
                            if (AggRules.getLogger().isDebugEnabled()) {
                                StringBuilder bf = new StringBuilder(64);
                                bf.append(getName());
                                bf.append(".getRegex: for name \"");
                                bf.append(name);
                                bf.append("\" regex is null because basename \"");
                                bf.append(basename);
                                bf.append("\" is not matched.");

                                String msg = bf.toString();
                                AggRules.getLogger().debug(msg);
                            }
                            // If the table name does not match the basename
                            // pattern, then return null for regex.
                            return null;
                        }
                    }
                    buf.append(n);
                }
                if (posttemplate != null) {
                    buf.append(posttemplate);
                }

                String regex = buf.toString();

                if (AggRules.getLogger().isDebugEnabled()) {
                    StringBuilder bf = new StringBuilder(64);
                    bf.append(getName());
                    bf.append(".getRegex: for name \"");
                    bf.append(name);
                    bf.append("\" regex is \"");
                    bf.append(regex);
                    bf.append('"');

                    String msg = bf.toString();
                    AggRules.getLogger().debug(msg);
                }
                return regex;
            }

            protected Recognizer.Matcher getMatcher(String name) {

                final String charcase = getCharCase();
                final String regex;
                int flag = 0;

                if (charcase.equals("ignore")) {
                    // the case of name does not matter
                    // since the Pattern will be create to ignore case
                    regex = getRegex(name);

                    flag = java.util.regex.Pattern.CASE_INSENSITIVE;

                } else if (charcase.equals("exact")) {
                    // the case of name is not changed
                    // since we are interested in exact case matching
                    regex = getRegex(name);

                } else if (charcase.equals("upper")) {
                    // convert name to upper case
                    regex = getRegex(name.toUpperCase());

                } else {
                    // lower
                    // convert name to lower case
                    regex = getRegex(name.toLowerCase());

                }
                // If regex is null, then return a matcher that matches nothing
                if (regex == null) {
                    return new Recognizer.Matcher() {
                        public boolean matches(String name) {
                            return false;
                        }
                    };
                }

                final java.util.regex.Pattern pattern =
                        java.util.regex.Pattern.compile(regex, flag);

                return new Recognizer.Matcher() {
                    public boolean matches(String name) {
                        boolean b = pattern.matcher(name).matches();
                        if (AggRules.getLogger().isDebugEnabled()) {
                            debug(name);
                        }
                        return b;
                    }
                    private void debug(String name) {
                        StringBuilder bf = new StringBuilder(64);
                        bf.append(NameMatcher.this.getName());
                        bf.append(".Matcher.matches:");
                        bf.append(" name \"");
                        bf.append(name);
                        bf.append("\" pattern \"");
                        bf.append(pattern.pattern());
                        bf.append("\"");
                        if ((pattern.flags() &
                            java.util.regex.Pattern.CASE_INSENSITIVE) != 0) {
                            bf.append(" case_insensitive");
                        }

                        String msg = bf.toString();
                        AggRules.getLogger().debug(msg);
                    }
                };
            }
		// END pass-through code block ---
	}

	/**
	 * This is used to identify the "fact_count" column in an aggregate
	 * table. It allows one to match using regular exprssions.
	 * The default is that the name of the fact count colum is simply
	 * the string "fact_count".
	 */
	public static class FactCountMatch extends NameMatcher
	{
		public FactCountMatch()
		{
		}

		public FactCountMatch(org.eigenbase.xom.DOMWrapper _def)
			throws org.eigenbase.xom.XOMException
		{
			try {
				org.eigenbase.xom.DOMElementParser _parser = new org.eigenbase.xom.DOMElementParser(_def, "", DefaultDef.class);
				factCountName = (String)_parser.getAttribute("factCountName", "String", "fact_count", null, true);
				pretemplate = (String)_parser.getAttribute("pretemplate", "String", null, null, false);
				posttemplate = (String)_parser.getAttribute("posttemplate", "String", null, null, false);
				basename = (String)_parser.getAttribute("basename", "String", null, null, false);
				id = (String)_parser.getAttribute("id", "String", null, null, true);
				charcase = (String)_parser.getAttribute("charcase", "String", "ignore", _charcase_values, false);
				enabled = (Boolean)_parser.getAttribute("enabled", "Boolean", "true", null, false);
			} catch(org.eigenbase.xom.XOMException _ex) {
				throw new org.eigenbase.xom.XOMException("In " + getName() + ": " + _ex.getMessage());
			}
		}

		public String factCountName;  // attribute default: fact_count


		public String getName()
		{
			return "FactCountMatch";
		}

		public void display(java.io.PrintWriter _out, int _indent)
		{
			_out.println(getName());
			displayAttribute(_out, "factCountName", factCountName, _indent+1);
			displayAttribute(_out, "pretemplate", pretemplate, _indent+1);
			displayAttribute(_out, "posttemplate", posttemplate, _indent+1);
			displayAttribute(_out, "basename", basename, _indent+1);
			displayAttribute(_out, "id", id, _indent+1);
			displayAttribute(_out, "charcase", charcase, _indent+1);
			displayAttribute(_out, "enabled", enabled, _indent+1);
		}
		public void displayXML(org.eigenbase.xom.XMLOutput _out, int _indent)
		{
			_out.beginTag("FactCountMatch", new org.eigenbase.xom.XMLAttrVector()
				.add("factCountName", factCountName)
				.add("pretemplate", pretemplate)
				.add("posttemplate", posttemplate)
				.add("basename", basename)
				.add("id", id)
				.add("charcase", charcase)
				.add("enabled", enabled)
				);
			_out.endTag("FactCountMatch");
		}
		public boolean displayDiff(org.eigenbase.xom.ElementDef _other, java.io.PrintWriter _out, int _indent)
		{
			FactCountMatch _cother = (FactCountMatch)_other;
			boolean _diff = displayAttributeDiff("factCountName", factCountName, _cother.factCountName, _out, _indent+1);
			return _diff;
		}
		// BEGIN pass-through code block ---
public void validate(final AggRules rules,
                                 final mondrian.recorder.MessageRecorder msgRecorder) {
                msgRecorder.pushContextName(getName());
                try {
                    super.validate(rules, msgRecorder);
                } finally {
                    msgRecorder.popContextName();
                }
            }
            public Recognizer.Matcher getMatcher() {
                return super.getMatcher(factCountName);
            }
		// END pass-through code block ---
	}

	/**
	 * This is used to identify foreign key columns in a candidate
	 * aggregate table given the name of a foreign key column of the
	 * base fact table. This allows such foreign keys to be identified
	 * by using a regular exprsssion. The default is to simply
	 * match the base fact table's foreign key column name.
	 */
	public static class ForeignKeyMatch extends NameMatcher
	{
		public ForeignKeyMatch()
		{
		}

		public ForeignKeyMatch(org.eigenbase.xom.DOMWrapper _def)
			throws org.eigenbase.xom.XOMException
		{
			try {
				org.eigenbase.xom.DOMElementParser _parser = new org.eigenbase.xom.DOMElementParser(_def, "", DefaultDef.class);
				pretemplate = (String)_parser.getAttribute("pretemplate", "String", null, null, false);
				posttemplate = (String)_parser.getAttribute("posttemplate", "String", null, null, false);
				basename = (String)_parser.getAttribute("basename", "String", null, null, false);
				id = (String)_parser.getAttribute("id", "String", null, null, true);
				charcase = (String)_parser.getAttribute("charcase", "String", "ignore", _charcase_values, false);
				enabled = (Boolean)_parser.getAttribute("enabled", "Boolean", "true", null, false);
			} catch(org.eigenbase.xom.XOMException _ex) {
				throw new org.eigenbase.xom.XOMException("In " + getName() + ": " + _ex.getMessage());
			}
		}



		public String getName()
		{
			return "ForeignKeyMatch";
		}

		public void display(java.io.PrintWriter _out, int _indent)
		{
			_out.println(getName());
			displayAttribute(_out, "pretemplate", pretemplate, _indent+1);
			displayAttribute(_out, "posttemplate", posttemplate, _indent+1);
			displayAttribute(_out, "basename", basename, _indent+1);
			displayAttribute(_out, "id", id, _indent+1);
			displayAttribute(_out, "charcase", charcase, _indent+1);
			displayAttribute(_out, "enabled", enabled, _indent+1);
		}
		public void displayXML(org.eigenbase.xom.XMLOutput _out, int _indent)
		{
			_out.beginTag("ForeignKeyMatch", new org.eigenbase.xom.XMLAttrVector()
				.add("pretemplate", pretemplate)
				.add("posttemplate", posttemplate)
				.add("basename", basename)
				.add("id", id)
				.add("charcase", charcase)
				.add("enabled", enabled)
				);
			_out.endTag("ForeignKeyMatch");
		}
		public boolean displayDiff(org.eigenbase.xom.ElementDef _other, java.io.PrintWriter _out, int _indent)
		{
			ForeignKeyMatch _cother = (ForeignKeyMatch)_other;
			return true;
		}
		// BEGIN pass-through code block ---
public void validate(final AggRules rules,
                                 final mondrian.recorder.MessageRecorder msgRecorder) {
                msgRecorder.pushContextName(getName());
                try {
                    super.validate(rules, msgRecorder);
                } finally {
                    msgRecorder.popContextName();
                }
            }
            public Recognizer.Matcher getMatcher(final String foreignKeyName) {
                return super.getMatcher(foreignKeyName);
            }
		// END pass-through code block ---
	}

	/**
	 * This is used to identify which tables in the database might
	 * be aggregate table of a given fact table.
	 * It is expected that aggregate table names will include the
	 * base fact table name with additional text before and/or
	 * after.
	 * It is not allow for both the prepending and appending
	 * regular expression text to be null (if it were, then only
	 * aggregate tables who names were the same as (modulo case)
	 * would match - which is surely not allowed).
	 */
	public static class TableMatch extends NameMatcher
	{
		public TableMatch()
		{
		}

		public TableMatch(org.eigenbase.xom.DOMWrapper _def)
			throws org.eigenbase.xom.XOMException
		{
			try {
				org.eigenbase.xom.DOMElementParser _parser = new org.eigenbase.xom.DOMElementParser(_def, "", DefaultDef.class);
				pretemplate = (String)_parser.getAttribute("pretemplate", "String", null, null, false);
				posttemplate = (String)_parser.getAttribute("posttemplate", "String", null, null, false);
				basename = (String)_parser.getAttribute("basename", "String", null, null, false);
				id = (String)_parser.getAttribute("id", "String", null, null, true);
				charcase = (String)_parser.getAttribute("charcase", "String", "ignore", _charcase_values, false);
				enabled = (Boolean)_parser.getAttribute("enabled", "Boolean", "true", null, false);
			} catch(org.eigenbase.xom.XOMException _ex) {
				throw new org.eigenbase.xom.XOMException("In " + getName() + ": " + _ex.getMessage());
			}
		}



		public String getName()
		{
			return "TableMatch";
		}

		public void display(java.io.PrintWriter _out, int _indent)
		{
			_out.println(getName());
			displayAttribute(_out, "pretemplate", pretemplate, _indent+1);
			displayAttribute(_out, "posttemplate", posttemplate, _indent+1);
			displayAttribute(_out, "basename", basename, _indent+1);
			displayAttribute(_out, "id", id, _indent+1);
			displayAttribute(_out, "charcase", charcase, _indent+1);
			displayAttribute(_out, "enabled", enabled, _indent+1);
		}
		public void displayXML(org.eigenbase.xom.XMLOutput _out, int _indent)
		{
			_out.beginTag("TableMatch", new org.eigenbase.xom.XMLAttrVector()
				.add("pretemplate", pretemplate)
				.add("posttemplate", posttemplate)
				.add("basename", basename)
				.add("id", id)
				.add("charcase", charcase)
				.add("enabled", enabled)
				);
			_out.endTag("TableMatch");
		}
		public boolean displayDiff(org.eigenbase.xom.ElementDef _other, java.io.PrintWriter _out, int _indent)
		{
			TableMatch _cother = (TableMatch)_other;
			return true;
		}
		// BEGIN pass-through code block ---
public void validate(final AggRules rules,
                                 final mondrian.recorder.MessageRecorder msgRecorder) {
                msgRecorder.pushContextName(getName());
                try {
                    if ((pretemplate == null) && (posttemplate == null)) {
                        String msg = "Must have at least one template non-null";
                        msgRecorder.reportError(msg);
                    }
                    super.validate(rules, msgRecorder);
                } finally {
                    msgRecorder.popContextName();
                }
            }
            public Recognizer.Matcher getMatcher(final String name) {
                return super.getMatcher(name);
            }
		// END pass-through code block ---
	}

	/**
	 * This allows one to create an element that matches against a
	 * single template, where the template is an attribute.
	 * While much loved, this is currently not used.
	 */
	public static abstract class Mapper extends CaseMatcher
	{
		public Mapper()
		{
		}

		public Mapper(org.eigenbase.xom.DOMWrapper _def)
			throws org.eigenbase.xom.XOMException
		{
			try {
				org.eigenbase.xom.DOMElementParser _parser = new org.eigenbase.xom.DOMElementParser(_def, "", DefaultDef.class);
				template = (String)_parser.getAttribute("template", "String", null, null, true);
				space = (String)_parser.getAttribute("space", "String", "_", null, false);
				dot = (String)_parser.getAttribute("dot", "String", "_", null, false);
				id = (String)_parser.getAttribute("id", "String", null, null, true);
				charcase = (String)_parser.getAttribute("charcase", "String", "ignore", _charcase_values, false);
				enabled = (Boolean)_parser.getAttribute("enabled", "Boolean", "true", null, false);
			} catch(org.eigenbase.xom.XOMException _ex) {
				throw new org.eigenbase.xom.XOMException("In " + getName() + ": " + _ex.getMessage());
			}
		}

		public String template;  // required attribute
		public String space;  // attribute default: _
		public String dot;  // attribute default: _


		public String getName()
		{
			return "Mapper";
		}

		public void display(java.io.PrintWriter _out, int _indent)
		{
			_out.println(getName());
			displayAttribute(_out, "template", template, _indent+1);
			displayAttribute(_out, "space", space, _indent+1);
			displayAttribute(_out, "dot", dot, _indent+1);
			displayAttribute(_out, "id", id, _indent+1);
			displayAttribute(_out, "charcase", charcase, _indent+1);
			displayAttribute(_out, "enabled", enabled, _indent+1);
		}
		public void displayXML(org.eigenbase.xom.XMLOutput _out, int _indent)
		{
			_out.beginTag("(%Mapper;)", new org.eigenbase.xom.XMLAttrVector()
				.add("template", template)
				.add("space", space)
				.add("dot", dot)
				.add("id", id)
				.add("charcase", charcase)
				.add("enabled", enabled)
				);
			_out.endTag("(%Mapper;)");
		}
		public boolean displayDiff(org.eigenbase.xom.ElementDef _other, java.io.PrintWriter _out, int _indent)
		{
			Mapper _cother = (Mapper)_other;
			boolean _diff = displayAttributeDiff("template", template, _cother.template, _out, _indent+1);
			_diff = _diff && displayAttributeDiff("space", space, _cother.space, _out, _indent+1);
			_diff = _diff && displayAttributeDiff("dot", dot, _cother.dot, _out, _indent+1);
			return _diff;
		}
		// BEGIN pass-through code block ---
public String getTemplate() {
                return template;
            }
            public String getSpace() {
                return space;
            }
            public String getDot() {
                return dot;
            }
            protected static final int BAD_ID = -1;

            protected String[] templateParts;
            protected int[] templateNamePos;

            /**
             * It is hoped that no one will need to match more than 50 names
             * in a template. Currently, this implementation, requires only 3.
             */
            private static final int MAX_SIZE = 50;

            public void validate(final AggRules rules,
                                 final mondrian.recorder.MessageRecorder msgRecorder) {
                msgRecorder.pushContextName(getName());
                try {
                    super.validate(rules, msgRecorder);

                    String[] ss = new String[MAX_SIZE+1];
                    int[] poss = new int[MAX_SIZE];

                    String template = getTemplate();
                    int count = 0;

                    int end = 0;
                    int previousEnd = 0;
                    int start = template.indexOf("${", end);
                    while (count < MAX_SIZE) {
                        if (start == -1) {
                            if (count == 0) {
                                // there are no ${} in template which
                                // is an error
                                String msg = "Bad template \"" +
                                    template +
                                    "\", no ${} entries";
                                msgRecorder.reportError(msg);
                                return;
                            }
                            // its OK, there are "count" ${}
                            templateNamePos = new int[count];
                            System.arraycopy(poss, 0, templateNamePos, 0, count);

                            ss[count++] =
                                template.substring(end, template.length());
                            templateParts = new String[count];
                            System.arraycopy(ss, 0, templateParts, 0, count);

                            return;
                        }

                        previousEnd = end;
                        end = template.indexOf('}', start);
                        if (end == -1) {
                            // there was a "${" but not '}' in template
                            String msg = "Bad template \"" +
                                template +
                                "\", it had a \"${\", but no '}'";
                            msgRecorder.reportError(msg);
                            return;
                        }

                        String name = template.substring(start+2, end);
                        int pos = convertNameToID(name, msgRecorder);
                        if (pos == BAD_ID) {
                            return;
                        }

                        poss[count] = pos;
                        ss[count] = template.substring(previousEnd, start);

                        start = template.indexOf("${", end);
                        end++;

                        count++;
                    }

                } finally {
                    msgRecorder.popContextName();
                }
            }


            protected abstract String[] getTemplateNames();

            private int convertNameToID(final String name,
                                        final mondrian.recorder.MessageRecorder msgRecorder) {

                if (name == null) {
                    String msg = "Template name is null";
                    msgRecorder.reportError(msg);
                    return BAD_ID;
                }

                String[] names = getTemplateNames();
                for (int i = 0; i < names.length; i++) {
                    if (names[i].equals(name)) {
                        return i;
                    }
                }

                String msg = "Bad template name \"" +
                    name +
                    "\"";
                msgRecorder.reportError(msg);
                return BAD_ID;
            }

            public String getRegex(final String[] names) {
                final String space = getSpace();
                final String dot = getDot();

                final StringBuilder buf = new StringBuilder();

                //
                // Remember that:
                //      templateParts.length == templateNamePos.length+1
                //
                buf.append(templateParts[0]);
                for (int i = 0; i < templateNamePos.length; i++) {
                    String n = names[templateNamePos[i]];

                    if (space != null) {
                        n = n.replaceAll(" ", space);
                    }
                    if (dot != null) {
                        n = n.replaceAll("\\.", dot);
                    }

                    buf.append(n);
                    buf.append(templateParts[i+1]);
                }

                String regex = buf.toString();

                if (AggRules.getLogger().isDebugEnabled()) {
                    StringBuilder bf = new StringBuilder(64);
                    bf.append(getName());
                    bf.append(".getRegex:");
                    bf.append(" for names ");
                    for (int i = 0; i < names.length; i++) {
                        bf.append('"');
                        bf.append(names[i]);
                        bf.append('"');
                        if (i+1 < names.length) {
                            bf.append(", ");
                        }
                    }
                    bf.append(" regex is \"");
                    bf.append(regex);
                    bf.append('"');

                    String msg = bf.toString();
                    AggRules.getLogger().debug(msg);
                }
                return regex;
            }

            protected Recognizer.Matcher getMatcher(final String[] names) {

                final String charcase = getCharCase();
                final String regex;
                int flag = 0;

                if (charcase.equals("ignore")) {
                    // the case of name does not matter
                    // since the Pattern will be create to ignore case
                    regex = getRegex(names);

                    flag = java.util.regex.Pattern.CASE_INSENSITIVE;

                } else if (charcase.equals("exact")) {
                    // the case of name is not changed
                    // since we are interested in exact case matching
                    regex = getRegex(names);

                } else if (charcase.equals("upper")) {
                    // convert name to upper case
                    String[] ucNames = new String[names.length];
                    for (int i = 0; i < names.length; i++) {
                        ucNames[i] = names[i].toUpperCase();
                    }

                    regex = getRegex(ucNames);

                } else {
                    // lower
                    // convert name to lower case
                    String[] lcNames = new String[names.length];
                    for (int i = 0; i < names.length; i++) {
                        lcNames[i] = names[i].toLowerCase();
                    }

                    regex = getRegex(lcNames);

                }
                final java.util.regex.Pattern pattern =
                    java.util.regex.Pattern.compile(regex, flag);

                return new Recognizer.Matcher() {
                    public boolean matches(String name) {
                        boolean b = pattern.matcher(name).matches();
                        if (AggRules.getLogger().isDebugEnabled()) {
                            debug(name);
                        }
                        return b;
                    }
                    private void debug(String name) {
                        StringBuilder bf = new StringBuilder(64);
                        bf.append(Mapper.this.getName());
                        bf.append(".Matcher.matches:");
                        bf.append(" name \"");
                        bf.append(name);
                        bf.append("\" pattern \"");
                        bf.append(pattern.pattern());
                        bf.append("\"");
                        if ((pattern.flags() &
                            java.util.regex.Pattern.CASE_INSENSITIVE) != 0) {
                            bf.append(" case_insensitive");
                        }

                        String msg = bf.toString();
                        AggRules.getLogger().debug(msg);
                    }
                };

            }
		// END pass-through code block ---
	}

	/**
	 * This element is used in a vector of child elements when
	 * one wishes to have one or more regular expressions associated
	 * with matching a given string. The parent element must
	 * initialize Regex object by calling its validate method
	 * passing in an array of template names.
	 * The cdata content is a regular expression with embedded
	 * template names. Each name must be surrounded by "${" and "}".
	 * Each time this is used for a new set of names, the names
	 * replace the template names in the regular expression.
	 * For example, if the charcase="lower", the attribute
	 * dot="-" (the default dot value is "_"), the template names are:
	 * "city", "state", and "country"
	 * and the cdata is:
	 * .*_${country}_.*_${city}
	 * Then when the names:
	 * "San Francisco", "California", and "U.S.A"
	 * are passed in, the regular expression becomes:
	 * .*_u-s-a_.*_san_francisco
	 * Note that a given template name can only appear ONCE in the
	 * template content, the cdata content. As an example, the
	 * following cdata template is not supported:
	 * .*_${country}_.*_${city}_${country}
	 */
	public static class Regex extends CaseMatcher
	{
		public Regex()
		{
		}

		public Regex(org.eigenbase.xom.DOMWrapper _def)
			throws org.eigenbase.xom.XOMException
		{
			try {
				org.eigenbase.xom.DOMElementParser _parser = new org.eigenbase.xom.DOMElementParser(_def, "", DefaultDef.class);
				space = (String)_parser.getAttribute("space", "String", "_", null, false);
				dot = (String)_parser.getAttribute("dot", "String", "_", null, false);
				id = (String)_parser.getAttribute("id", "String", null, null, true);
				charcase = (String)_parser.getAttribute("charcase", "String", "ignore", _charcase_values, false);
				enabled = (Boolean)_parser.getAttribute("enabled", "Boolean", "true", null, false);
				cdata = _parser.getText();
			} catch(org.eigenbase.xom.XOMException _ex) {
				throw new org.eigenbase.xom.XOMException("In " + getName() + ": " + _ex.getMessage());
			}
		}

		public String space;  // attribute default: _
		public String dot;  // attribute default: _

		public String cdata;  // All text goes here
		public String getName()
		{
			return "Regex";
		}

		public void display(java.io.PrintWriter _out, int _indent)
		{
			_out.println(getName());
			displayAttribute(_out, "space", space, _indent+1);
			displayAttribute(_out, "dot", dot, _indent+1);
			displayAttribute(_out, "id", id, _indent+1);
			displayAttribute(_out, "charcase", charcase, _indent+1);
			displayAttribute(_out, "enabled", enabled, _indent+1);
			displayString(_out, "cdata", cdata, _indent+1);
		}
		public void displayXML(org.eigenbase.xom.XMLOutput _out, int _indent)
		{
			_out.beginTag("Regex", new org.eigenbase.xom.XMLAttrVector()
				.add("space", space)
				.add("dot", dot)
				.add("id", id)
				.add("charcase", charcase)
				.add("enabled", enabled)
				);
			_out.cdata(cdata);
			_out.endTag("Regex");
		}
		public boolean displayDiff(org.eigenbase.xom.ElementDef _other, java.io.PrintWriter _out, int _indent)
		{
			Regex _cother = (Regex)_other;
			boolean _diff = displayAttributeDiff("space", space, _cother.space, _out, _indent+1);
			_diff = _diff && displayAttributeDiff("dot", dot, _cother.dot, _out, _indent+1);
			_diff = _diff && displayStringDiff("cdata", cdata, _cother.cdata, _out, _indent+1);
			return _diff;
		}
		// BEGIN pass-through code block ---
public String getSpace() {
                return space;
            }
            public String getDot() {
                return dot;
            }
            public String getTemplate() {
                return cdata;
            }

            protected static final int BAD_ID = -1;

            protected String[] templateParts;

            /**
             * This is a one-to-one mapping, each template name can appear
             * at most once.
             */
            protected int[] templateNamePos;

            /**
             * It is hoped that no one will need to match more than 50 names
             * in a template. Currently, this implementation, requires only 3.
             */
            private static final int MAX_SIZE = 50;

            public void validate(final AggRules rules,
                                 final String[] templateNames,
                                 final mondrian.recorder.MessageRecorder msgRecorder) {
                msgRecorder.pushContextName(getName());
                try {
                    super.validate(rules, msgRecorder);

                    String[] ss = new String[MAX_SIZE+1];
                    int[] poss = new int[MAX_SIZE];

                    String template = getTemplate();
                    int count = 0;

                    int end = 0;
                    int previousEnd = 0;
                    int start = template.indexOf("${", end);
                    // if no templateNames, then there better not be
                    // any ${}s
                    if (templateNames.length == 0) {
                        if (start == -1) {
                            // everything is ok
                            templateParts = new String[1];
                            templateParts[0] = template;
                            templateNamePos = new int[0];
                        } else {
                            String msg = "Bad template \"" +
                                template +
                                "\", no ${} entries but there are "+
                                "template names" ;
                            msgRecorder.reportError(msg);
                        }
                        return;
                    }
                    while (count < MAX_SIZE) {
                        if (start == -1) {
                            if (count == 0) {
                                // there are no ${} in template which
                                // is an error
                                String msg = "Bad template \"" +
                                    template +
                                    "\", no ${} entries";
                                msgRecorder.reportError(msg);
                                return;
                            }
                            // its OK, there are "count" ${}
                            templateNamePos = new int[count];
                            System.arraycopy(poss, 0, templateNamePos, 0, count);

                            ss[count++] =
                                template.substring(end, template.length());
                            templateParts = new String[count];
                            System.arraycopy(ss, 0, templateParts, 0, count);

                            return;
                        }

                        previousEnd = end;
                        end = template.indexOf('}', start);
                        if (end == -1) {
                            // there was a "${" but not '}' in template
                            String msg = "Bad template \"" +
                                template +
                                "\", it had a \"${\", but no '}'";
                            msgRecorder.reportError(msg);
                            return;
                        }

                        String name = template.substring(start+2, end);
                        int pos = convertNameToID(name,
                                                  templateNames,
                                                  msgRecorder);
                        if (pos == BAD_ID) {
                            return;
                        }

                        poss[count] = pos;
                        ss[count] = template.substring(previousEnd, start);

                        start = template.indexOf("${", end);
                        end++;

                        count++;
                    }

                } finally {
                    msgRecorder.popContextName();
                }
            }
            private int convertNameToID(final String name,
                                        final String[] templateNames,
                                        final mondrian.recorder.MessageRecorder msgRecorder) {

                if (name == null) {
                    String msg = "Template name is null";
                    msgRecorder.reportError(msg);
                    return BAD_ID;
                }

                for (int i = 0; i < templateNames.length; i++) {
                    if (templateNames[i].equals(name)) {
                        return i;
                    }
                }

                String msg = "Bad template name \"" +
                    name +
                    "\"";
                msgRecorder.reportError(msg);
                return BAD_ID;
            }
            public String getRegex(final String[] names) {
                final String space = getSpace();
                final String dot = getDot();

                final StringBuilder buf = new StringBuilder();

                //
                // Remember that:
                //      templateParts.length == templateNamePos.length+1
                //
                buf.append(templateParts[0]);
                for (int i = 0; i < templateNamePos.length; i++) {
                    String n = names[templateNamePos[i]];
                    if (n == null) {
                        // its ok for a name to be null, it just
                        // eliminates the current regex from consideration
                        return null;
                    }

                    if (space != null) {
                        n = n.replaceAll(" ", space);
                    }
                    if (dot != null) {
                        n = n.replaceAll("\\.", dot);
                    }

                    buf.append(n);
                    buf.append(templateParts[i+1]);
                }

                String regex = buf.toString();

                if (AggRules.getLogger().isDebugEnabled()) {
                    StringBuilder bf = new StringBuilder(64);
                    bf.append(getName());
                    bf.append(".getRegex:");
                    bf.append(" for names ");
                    for (int i = 0; i < names.length; i++) {
                        bf.append('"');
                        bf.append(names[i]);
                        bf.append('"');
                        if (i+1 < names.length) {
                            bf.append(", ");
                        }
                    }
                    bf.append(" regex is \"");
                    bf.append(regex);
                    bf.append('"');

                    String msg = bf.toString();
                    AggRules.getLogger().debug(msg);
                }

                return regex;
            }
            protected java.util.regex.Pattern getPattern(final String[] names) {

                final String charcase = getCharCase();

                if (charcase.equals("ignore")) {
                    // the case of name does not matter
                    // since the Pattern will be create to ignore case
                    final String regex = getRegex(names);
                    if (regex == null) {
                        return null;
                    }

                    final java.util.regex.Pattern pattern =
                        java.util.regex.Pattern.compile(regex,
                            java.util.regex.Pattern.CASE_INSENSITIVE);

                    return pattern;

                } else if (charcase.equals("exact")) {
                    // the case of name is not changed
                    // since we are interested in exact case matching
                    final String regex = getRegex(names);
                    if (regex == null) {
                        return null;
                    }

                    final java.util.regex.Pattern pattern =
                        java.util.regex.Pattern.compile(regex);

                    return pattern;

                } else if (charcase.equals("upper")) {
                    // convert name to upper case
                    String[] ucNames = new String[names.length];
                    for (int i = 0; i < names.length; i++) {
                        String name = names[i];
                        ucNames[i] = (name == null)
                            ? null: name.toUpperCase();
                    }

                    final String regex = getRegex(ucNames);
                    if (regex == null) {
                        return null;
                    }

                    final java.util.regex.Pattern pattern =
                        java.util.regex.Pattern.compile(regex);

                    return pattern;

                } else {
                    // lower
                    // convert name to lower case
                    String[] lcNames = new String[names.length];
                    for (int i = 0; i < names.length; i++) {
                        String name = names[i];
                        lcNames[i] = (name == null)
                            ? null: name.toLowerCase();
                    }

                    final String regex = getRegex(lcNames);
                    if (regex == null) {
                        return null;
                    }

                    final java.util.regex.Pattern pattern =
                        java.util.regex.Pattern.compile(regex);

                    return pattern;
                }
            }
		// END pass-through code block ---
	}

	/**
	 */
	public static abstract class RegexMapper extends Base
	{
		public RegexMapper()
		{
		}

		public RegexMapper(org.eigenbase.xom.DOMWrapper _def)
			throws org.eigenbase.xom.XOMException
		{
			try {
				org.eigenbase.xom.DOMElementParser _parser = new org.eigenbase.xom.DOMElementParser(_def, "", DefaultDef.class);
				org.eigenbase.xom.NodeDef[] _tempArray;
				id = (String)_parser.getAttribute("id", "String", null, null, true);
				enabled = (Boolean)_parser.getAttribute("enabled", "Boolean", "true", null, false);
				_tempArray = _parser.getArray(Regex.class, 0, 0);
				regexs = new Regex[_tempArray.length];
				for (int _i = 0; _i < regexs.length; _i++)
					regexs[_i] = (Regex)_tempArray[_i];
			} catch(org.eigenbase.xom.XOMException _ex) {
				throw new org.eigenbase.xom.XOMException("In " + getName() + ": " + _ex.getMessage());
			}
		}

		public String id;  // required attribute

		/**
		 * This is an array of Regex. A match occurs if any one of
		 * the Regex matches; it is the equivalent of or-ing the
		 * regular expressions together. A candidate string is processed
		 * sequentially by each Regex in their document order until
		 * one matches. In none match, well, none match.
		 */
		public Regex[] regexs;  //optional array

		public String getName()
		{
			return "RegexMapper";
		}

		public void display(java.io.PrintWriter _out, int _indent)
		{
			_out.println(getName());
			displayAttribute(_out, "id", id, _indent+1);
			displayAttribute(_out, "enabled", enabled, _indent+1);
			displayElementArray(_out, "regexs", regexs, _indent+1);
		}
		public void displayXML(org.eigenbase.xom.XMLOutput _out, int _indent)
		{
			_out.beginTag("(%RegexMapper;)", new org.eigenbase.xom.XMLAttrVector()
				.add("id", id)
				.add("enabled", enabled)
				);
			displayXMLElementArray(_out, regexs);
			_out.endTag("(%RegexMapper;)");
		}
		public boolean displayDiff(org.eigenbase.xom.ElementDef _other, java.io.PrintWriter _out, int _indent)
		{
			RegexMapper _cother = (RegexMapper)_other;
			boolean _diff = displayAttributeDiff("id", id, _cother.id, _out, _indent+1);
			_diff = _diff && displayElementArrayDiff("regexs", regexs, _cother.regexs, _out, _indent+1);
			return _diff;
		}
		// BEGIN pass-through code block ---
protected String getTag() {
                return id;
            }

            public void validate(final AggRules rules,
                                 final mondrian.recorder.MessageRecorder msgRecorder) {
                msgRecorder.pushContextName(getName());
                try {

                    String[] templateNames = getTemplateNames();

                    for (int i = 0; i < regexs.length; i++) {
                        Regex regex = regexs[i];
                        regex.validate(rules, templateNames, msgRecorder);
                    }

                } finally {
                    msgRecorder.popContextName();
                }
            }


            /**
             * This must be defined in derived classes. It returns an array of
             * symbolic names that are the symbolic names allowed to appear
             * in the regular expression templates.
             *
             * @return array of symbol names
             */
            protected abstract String[] getTemplateNames();

            protected Recognizer.Matcher getMatcher(final String[] names) {

                final java.util.regex.Pattern[] patterns =
                    new java.util.regex.Pattern[regexs.length];

                for (int i = 0; i < regexs.length; i++) {
                    Regex regex = regexs[i];
                    patterns[i] = regex.getPattern(names);
                }

                return new Recognizer.Matcher() {
                    public boolean matches(String name) {
                        for (int i = 0; i < patterns.length; i++) {
                            java.util.regex.Pattern pattern = patterns[i];
                            if ((pattern != null) &&
                                    pattern.matcher(name).matches()) {

                                if (AggRules.getLogger().isDebugEnabled()) {
                                    debug(name, pattern);
                                }

                                return true;
                            }
                        }
                        return false;
                    }
                    private void debug(String name, java.util.regex.Pattern p) {
                        StringBuilder bf = new StringBuilder(64);
                        bf.append("DefaultDef.RegexMapper");
                        bf.append(".Matcher.matches:");
                        bf.append(" name \"");
                        bf.append(name);
                        bf.append("\" matches regex \"");
                        bf.append(p.pattern());
                        bf.append("\"");
                        if ((p.flags() &
                            java.util.regex.Pattern.CASE_INSENSITIVE) != 0) {
                            bf.append(" case_insensitive");
                        }

                        String msg = bf.toString();
                        AggRules.getLogger().debug(msg);
                    }
                };
            }
		// END pass-through code block ---
	}

	public static abstract class Ref extends Base
	{
		public Ref()
		{
		}

		public Ref(org.eigenbase.xom.DOMWrapper _def)
			throws org.eigenbase.xom.XOMException
		{
			try {
				org.eigenbase.xom.DOMElementParser _parser = new org.eigenbase.xom.DOMElementParser(_def, "", DefaultDef.class);
				refId = (String)_parser.getAttribute("refId", "String", null, null, true);
				enabled = (Boolean)_parser.getAttribute("enabled", "Boolean", "true", null, false);
			} catch(org.eigenbase.xom.XOMException _ex) {
				throw new org.eigenbase.xom.XOMException("In " + getName() + ": " + _ex.getMessage());
			}
		}

		public String refId;  // required attribute


		public String getName()
		{
			return "Ref";
		}

		public void display(java.io.PrintWriter _out, int _indent)
		{
			_out.println(getName());
			displayAttribute(_out, "refId", refId, _indent+1);
			displayAttribute(_out, "enabled", enabled, _indent+1);
		}
		public void displayXML(org.eigenbase.xom.XMLOutput _out, int _indent)
		{
			_out.beginTag("(%Ref;)", new org.eigenbase.xom.XMLAttrVector()
				.add("refId", refId)
				.add("enabled", enabled)
				);
			_out.endTag("(%Ref;)");
		}
		public boolean displayDiff(org.eigenbase.xom.ElementDef _other, java.io.PrintWriter _out, int _indent)
		{
			Ref _cother = (Ref)_other;
			boolean _diff = displayAttributeDiff("refId", refId, _cother.refId, _out, _indent+1);
			return _diff;
		}
		// BEGIN pass-through code block ---
protected String getTag() {
                return getRefId();
            }
            public String getRefId() {
                return refId;
            }
		// END pass-through code block ---
	}

	public static class LevelMapRef extends Ref
	{
		public LevelMapRef()
		{
		}

		public LevelMapRef(org.eigenbase.xom.DOMWrapper _def)
			throws org.eigenbase.xom.XOMException
		{
			try {
				org.eigenbase.xom.DOMElementParser _parser = new org.eigenbase.xom.DOMElementParser(_def, "", DefaultDef.class);
				refId = (String)_parser.getAttribute("refId", "String", null, null, true);
				enabled = (Boolean)_parser.getAttribute("enabled", "Boolean", "true", null, false);
			} catch(org.eigenbase.xom.XOMException _ex) {
				throw new org.eigenbase.xom.XOMException("In " + getName() + ": " + _ex.getMessage());
			}
		}



		public String getName()
		{
			return "LevelMapRef";
		}

		public void display(java.io.PrintWriter _out, int _indent)
		{
			_out.println(getName());
			displayAttribute(_out, "refId", refId, _indent+1);
			displayAttribute(_out, "enabled", enabled, _indent+1);
		}
		public void displayXML(org.eigenbase.xom.XMLOutput _out, int _indent)
		{
			_out.beginTag("LevelMapRef", new org.eigenbase.xom.XMLAttrVector()
				.add("refId", refId)
				.add("enabled", enabled)
				);
			_out.endTag("LevelMapRef");
		}
		public boolean displayDiff(org.eigenbase.xom.ElementDef _other, java.io.PrintWriter _out, int _indent)
		{
			LevelMapRef _cother = (LevelMapRef)_other;
			return true;
		}
		// BEGIN pass-through code block ---
public void validate(final AggRules rules,
                                 final mondrian.recorder.MessageRecorder msgRecorder) {
                msgRecorder.pushContextName(getName());
                try {
                    if (! rules.hasLevelMap(getRefId())) {
                        String msg = "No LevelMap has id equal to refid \"" +
                            getRefId() +
                            "\"";
                        msgRecorder.reportError(msg);
                    }
                } finally {
                    msgRecorder.popContextName();
                }
            }
		// END pass-through code block ---
	}

	public static class MeasureMapRef extends Ref
	{
		public MeasureMapRef()
		{
		}

		public MeasureMapRef(org.eigenbase.xom.DOMWrapper _def)
			throws org.eigenbase.xom.XOMException
		{
			try {
				org.eigenbase.xom.DOMElementParser _parser = new org.eigenbase.xom.DOMElementParser(_def, "", DefaultDef.class);
				refId = (String)_parser.getAttribute("refId", "String", null, null, true);
				enabled = (Boolean)_parser.getAttribute("enabled", "Boolean", "true", null, false);
			} catch(org.eigenbase.xom.XOMException _ex) {
				throw new org.eigenbase.xom.XOMException("In " + getName() + ": " + _ex.getMessage());
			}
		}



		public String getName()
		{
			return "MeasureMapRef";
		}

		public void display(java.io.PrintWriter _out, int _indent)
		{
			_out.println(getName());
			displayAttribute(_out, "refId", refId, _indent+1);
			displayAttribute(_out, "enabled", enabled, _indent+1);
		}
		public void displayXML(org.eigenbase.xom.XMLOutput _out, int _indent)
		{
			_out.beginTag("MeasureMapRef", new org.eigenbase.xom.XMLAttrVector()
				.add("refId", refId)
				.add("enabled", enabled)
				);
			_out.endTag("MeasureMapRef");
		}
		public boolean displayDiff(org.eigenbase.xom.ElementDef _other, java.io.PrintWriter _out, int _indent)
		{
			MeasureMapRef _cother = (MeasureMapRef)_other;
			return true;
		}
		// BEGIN pass-through code block ---
public void validate(final AggRules rules,
                                 final mondrian.recorder.MessageRecorder msgRecorder) {
                msgRecorder.pushContextName(getName());
                try {
                    if (! rules.hasMeasureMap(getRefId())) {
                        String msg = "No MeasureMap has id equal to refid \"" +
                            getRefId() +
                            "\"";
                        msgRecorder.reportError(msg);
                    }
                } finally {
                    msgRecorder.popContextName();
                }
            }
		// END pass-through code block ---
	}

	public static class IgnoreMapRef extends Ref
	{
		public IgnoreMapRef()
		{
		}

		public IgnoreMapRef(org.eigenbase.xom.DOMWrapper _def)
			throws org.eigenbase.xom.XOMException
		{
			try {
				org.eigenbase.xom.DOMElementParser _parser = new org.eigenbase.xom.DOMElementParser(_def, "", DefaultDef.class);
				refId = (String)_parser.getAttribute("refId", "String", null, null, true);
				enabled = (Boolean)_parser.getAttribute("enabled", "Boolean", "true", null, false);
			} catch(org.eigenbase.xom.XOMException _ex) {
				throw new org.eigenbase.xom.XOMException("In " + getName() + ": " + _ex.getMessage());
			}
		}



		public String getName()
		{
			return "IgnoreMapRef";
		}

		public void display(java.io.PrintWriter _out, int _indent)
		{
			_out.println(getName());
			displayAttribute(_out, "refId", refId, _indent+1);
			displayAttribute(_out, "enabled", enabled, _indent+1);
		}
		public void displayXML(org.eigenbase.xom.XMLOutput _out, int _indent)
		{
			_out.beginTag("IgnoreMapRef", new org.eigenbase.xom.XMLAttrVector()
				.add("refId", refId)
				.add("enabled", enabled)
				);
			_out.endTag("IgnoreMapRef");
		}
		public boolean displayDiff(org.eigenbase.xom.ElementDef _other, java.io.PrintWriter _out, int _indent)
		{
			IgnoreMapRef _cother = (IgnoreMapRef)_other;
			return true;
		}
		// BEGIN pass-through code block ---
public void validate(final AggRules rules,
                                 final mondrian.recorder.MessageRecorder msgRecorder) {
                msgRecorder.pushContextName(getName());
                try {
                    if (! rules.hasIgnoreMap(getRefId())) {
                        String msg = "No IgnoreMap has id equal to refid \"" +
                            getRefId() +
                            "\"";
                        msgRecorder.reportError(msg);
                    }
                } finally {
                    msgRecorder.popContextName();
                }
            }
		// END pass-through code block ---
	}

	public static class FactCountMatchRef extends Ref
	{
		public FactCountMatchRef()
		{
		}

		public FactCountMatchRef(org.eigenbase.xom.DOMWrapper _def)
			throws org.eigenbase.xom.XOMException
		{
			try {
				org.eigenbase.xom.DOMElementParser _parser = new org.eigenbase.xom.DOMElementParser(_def, "", DefaultDef.class);
				refId = (String)_parser.getAttribute("refId", "String", null, null, true);
				enabled = (Boolean)_parser.getAttribute("enabled", "Boolean", "true", null, false);
			} catch(org.eigenbase.xom.XOMException _ex) {
				throw new org.eigenbase.xom.XOMException("In " + getName() + ": " + _ex.getMessage());
			}
		}



		public String getName()
		{
			return "FactCountMatchRef";
		}

		public void display(java.io.PrintWriter _out, int _indent)
		{
			_out.println(getName());
			displayAttribute(_out, "refId", refId, _indent+1);
			displayAttribute(_out, "enabled", enabled, _indent+1);
		}
		public void displayXML(org.eigenbase.xom.XMLOutput _out, int _indent)
		{
			_out.beginTag("FactCountMatchRef", new org.eigenbase.xom.XMLAttrVector()
				.add("refId", refId)
				.add("enabled", enabled)
				);
			_out.endTag("FactCountMatchRef");
		}
		public boolean displayDiff(org.eigenbase.xom.ElementDef _other, java.io.PrintWriter _out, int _indent)
		{
			FactCountMatchRef _cother = (FactCountMatchRef)_other;
			return true;
		}
		// BEGIN pass-through code block ---
public void validate(final AggRules rules,
                                 final mondrian.recorder.MessageRecorder msgRecorder) {
                msgRecorder.pushContextName(getName());
                try {
                    if (! rules.hasFactCountMatch(getRefId())) {
                        String msg = "No FactCountMatch has id equal to refid \"" +
                            getRefId() +
                            "\"";
                        msgRecorder.reportError(msg);
                    }
                } finally {
                    msgRecorder.popContextName();
                }
            }
		// END pass-through code block ---
	}

	public static class ForeignKeyMatchRef extends Ref
	{
		public ForeignKeyMatchRef()
		{
		}

		public ForeignKeyMatchRef(org.eigenbase.xom.DOMWrapper _def)
			throws org.eigenbase.xom.XOMException
		{
			try {
				org.eigenbase.xom.DOMElementParser _parser = new org.eigenbase.xom.DOMElementParser(_def, "", DefaultDef.class);
				refId = (String)_parser.getAttribute("refId", "String", null, null, true);
				enabled = (Boolean)_parser.getAttribute("enabled", "Boolean", "true", null, false);
			} catch(org.eigenbase.xom.XOMException _ex) {
				throw new org.eigenbase.xom.XOMException("In " + getName() + ": " + _ex.getMessage());
			}
		}



		public String getName()
		{
			return "ForeignKeyMatchRef";
		}

		public void display(java.io.PrintWriter _out, int _indent)
		{
			_out.println(getName());
			displayAttribute(_out, "refId", refId, _indent+1);
			displayAttribute(_out, "enabled", enabled, _indent+1);
		}
		public void displayXML(org.eigenbase.xom.XMLOutput _out, int _indent)
		{
			_out.beginTag("ForeignKeyMatchRef", new org.eigenbase.xom.XMLAttrVector()
				.add("refId", refId)
				.add("enabled", enabled)
				);
			_out.endTag("ForeignKeyMatchRef");
		}
		public boolean displayDiff(org.eigenbase.xom.ElementDef _other, java.io.PrintWriter _out, int _indent)
		{
			ForeignKeyMatchRef _cother = (ForeignKeyMatchRef)_other;
			return true;
		}
		// BEGIN pass-through code block ---
public void validate(final AggRules rules,
                                 final mondrian.recorder.MessageRecorder msgRecorder) {
                msgRecorder.pushContextName(getName());
                try {
                    if (! rules.hasForeignKeyMatch(getRefId())) {
                        String msg = "No ForeignKeyMatch has id equal to refid \"" +
                            getRefId() +
                            "\"";
                        msgRecorder.reportError(msg);
                    }
                } finally {
                    msgRecorder.popContextName();
                }
            }
		// END pass-through code block ---
	}

	public static class TableMatchRef extends Ref
	{
		public TableMatchRef()
		{
		}

		public TableMatchRef(org.eigenbase.xom.DOMWrapper _def)
			throws org.eigenbase.xom.XOMException
		{
			try {
				org.eigenbase.xom.DOMElementParser _parser = new org.eigenbase.xom.DOMElementParser(_def, "", DefaultDef.class);
				refId = (String)_parser.getAttribute("refId", "String", null, null, true);
				enabled = (Boolean)_parser.getAttribute("enabled", "Boolean", "true", null, false);
			} catch(org.eigenbase.xom.XOMException _ex) {
				throw new org.eigenbase.xom.XOMException("In " + getName() + ": " + _ex.getMessage());
			}
		}



		public String getName()
		{
			return "TableMatchRef";
		}

		public void display(java.io.PrintWriter _out, int _indent)
		{
			_out.println(getName());
			displayAttribute(_out, "refId", refId, _indent+1);
			displayAttribute(_out, "enabled", enabled, _indent+1);
		}
		public void displayXML(org.eigenbase.xom.XMLOutput _out, int _indent)
		{
			_out.beginTag("TableMatchRef", new org.eigenbase.xom.XMLAttrVector()
				.add("refId", refId)
				.add("enabled", enabled)
				);
			_out.endTag("TableMatchRef");
		}
		public boolean displayDiff(org.eigenbase.xom.ElementDef _other, java.io.PrintWriter _out, int _indent)
		{
			TableMatchRef _cother = (TableMatchRef)_other;
			return true;
		}
		// BEGIN pass-through code block ---
public void validate(final AggRules rules,
                                 final mondrian.recorder.MessageRecorder msgRecorder) {
                msgRecorder.pushContextName(getName());
                try {
                    if (! rules.hasTableMatch(getRefId())) {
                        String msg = "No TableMatch has id equal to refid \"" +
                            getRefId() +
                            "\"";
                        msgRecorder.reportError(msg);
                    }
                } finally {
                    msgRecorder.popContextName();
                }
            }
		// END pass-through code block ---
	}

	/**
	 * This is the template that maps from a combination of level
	 * usage_prefix
	 * hierarchy_name
	 * level_name
	 * level_column_name
	 */
	public static class LevelMap extends RegexMapper
	{
		public LevelMap()
		{
		}

		public LevelMap(org.eigenbase.xom.DOMWrapper _def)
			throws org.eigenbase.xom.XOMException
		{
			try {
				org.eigenbase.xom.DOMElementParser _parser = new org.eigenbase.xom.DOMElementParser(_def, "", DefaultDef.class);
				org.eigenbase.xom.NodeDef[] _tempArray;
				id = (String)_parser.getAttribute("id", "String", null, null, true);
				enabled = (Boolean)_parser.getAttribute("enabled", "Boolean", "true", null, false);
				_tempArray = _parser.getArray(Regex.class, 0, 0);
				regexs = new Regex[_tempArray.length];
				for (int _i = 0; _i < regexs.length; _i++)
					regexs[_i] = (Regex)_tempArray[_i];
			} catch(org.eigenbase.xom.XOMException _ex) {
				throw new org.eigenbase.xom.XOMException("In " + getName() + ": " + _ex.getMessage());
			}
		}



		public String getName()
		{
			return "LevelMap";
		}

		public void display(java.io.PrintWriter _out, int _indent)
		{
			_out.println(getName());
			displayAttribute(_out, "id", id, _indent+1);
			displayAttribute(_out, "enabled", enabled, _indent+1);
			displayElementArray(_out, "regexs", regexs, _indent+1);
		}
		public void displayXML(org.eigenbase.xom.XMLOutput _out, int _indent)
		{
			_out.beginTag("LevelMap", new org.eigenbase.xom.XMLAttrVector()
				.add("id", id)
				.add("enabled", enabled)
				);
			displayXMLElementArray(_out, regexs);
			_out.endTag("LevelMap");
		}
		public boolean displayDiff(org.eigenbase.xom.ElementDef _other, java.io.PrintWriter _out, int _indent)
		{
			LevelMap _cother = (LevelMap)_other;
			boolean _diff = displayElementArrayDiff("regexs", regexs, _cother.regexs, _out, _indent+1);
			return _diff;
		}
		// BEGIN pass-through code block ---
private static final String[] TEMPLATE_NAMES = new String[] {
                "usage_prefix",
                "hierarchy_name",
                "level_name",
                "level_column_name"
            };
            protected String[] getTemplateNames() {
                return TEMPLATE_NAMES;
            }

            protected Recognizer.Matcher getMatcher(
                                            final String usagePrefix,
                                            final String hierarchyName,
                                            final String levelName,
                                            final String levelColumnName) {
                return getMatcher(new String[] {
                    usagePrefix,
                    hierarchyName,
                    levelName,
                    levelColumnName
                });
            }
		// END pass-through code block ---
	}

	/**
	 * This is the template that maps from a combination of measure
	 * measure_name,
	 * measure_column_name, and
	 * aggregate_name ("count", "sum", "avg", "min", "max",
	 * "distinct-count").
	 */
	public static class MeasureMap extends RegexMapper
	{
		public MeasureMap()
		{
		}

		public MeasureMap(org.eigenbase.xom.DOMWrapper _def)
			throws org.eigenbase.xom.XOMException
		{
			try {
				org.eigenbase.xom.DOMElementParser _parser = new org.eigenbase.xom.DOMElementParser(_def, "", DefaultDef.class);
				org.eigenbase.xom.NodeDef[] _tempArray;
				id = (String)_parser.getAttribute("id", "String", null, null, true);
				enabled = (Boolean)_parser.getAttribute("enabled", "Boolean", "true", null, false);
				_tempArray = _parser.getArray(Regex.class, 0, 0);
				regexs = new Regex[_tempArray.length];
				for (int _i = 0; _i < regexs.length; _i++)
					regexs[_i] = (Regex)_tempArray[_i];
			} catch(org.eigenbase.xom.XOMException _ex) {
				throw new org.eigenbase.xom.XOMException("In " + getName() + ": " + _ex.getMessage());
			}
		}



		public String getName()
		{
			return "MeasureMap";
		}

		public void display(java.io.PrintWriter _out, int _indent)
		{
			_out.println(getName());
			displayAttribute(_out, "id", id, _indent+1);
			displayAttribute(_out, "enabled", enabled, _indent+1);
			displayElementArray(_out, "regexs", regexs, _indent+1);
		}
		public void displayXML(org.eigenbase.xom.XMLOutput _out, int _indent)
		{
			_out.beginTag("MeasureMap", new org.eigenbase.xom.XMLAttrVector()
				.add("id", id)
				.add("enabled", enabled)
				);
			displayXMLElementArray(_out, regexs);
			_out.endTag("MeasureMap");
		}
		public boolean displayDiff(org.eigenbase.xom.ElementDef _other, java.io.PrintWriter _out, int _indent)
		{
			MeasureMap _cother = (MeasureMap)_other;
			boolean _diff = displayElementArrayDiff("regexs", regexs, _cother.regexs, _out, _indent+1);
			return _diff;
		}
		// BEGIN pass-through code block ---
private static final String[] TEMPLATE_NAMES = new String[] {
                "measure_name",
                "measure_column_name",
                "aggregate_name"
            };
            protected String[] getTemplateNames() {
                return TEMPLATE_NAMES;
            }
            protected Recognizer.Matcher getMatcher(
                                            final String measureName,
                                            final String measuerColumnName,
                                            final String aggregateName) {
                return getMatcher(new String[] {
                    measureName,
                    measuerColumnName,
                    aggregateName
                });
            }
		// END pass-through code block ---
	}

	/**
	 * This is the template used to specify columns to be ignored.
	 * There are NO template names. One simply uses a regular
	 * expression.
	 */
	public static class IgnoreMap extends RegexMapper
	{
		public IgnoreMap()
		{
		}

		public IgnoreMap(org.eigenbase.xom.DOMWrapper _def)
			throws org.eigenbase.xom.XOMException
		{
			try {
				org.eigenbase.xom.DOMElementParser _parser = new org.eigenbase.xom.DOMElementParser(_def, "", DefaultDef.class);
				org.eigenbase.xom.NodeDef[] _tempArray;
				id = (String)_parser.getAttribute("id", "String", null, null, true);
				enabled = (Boolean)_parser.getAttribute("enabled", "Boolean", "true", null, false);
				_tempArray = _parser.getArray(Regex.class, 0, 0);
				regexs = new Regex[_tempArray.length];
				for (int _i = 0; _i < regexs.length; _i++)
					regexs[_i] = (Regex)_tempArray[_i];
			} catch(org.eigenbase.xom.XOMException _ex) {
				throw new org.eigenbase.xom.XOMException("In " + getName() + ": " + _ex.getMessage());
			}
		}



		public String getName()
		{
			return "IgnoreMap";
		}

		public void display(java.io.PrintWriter _out, int _indent)
		{
			_out.println(getName());
			displayAttribute(_out, "id", id, _indent+1);
			displayAttribute(_out, "enabled", enabled, _indent+1);
			displayElementArray(_out, "regexs", regexs, _indent+1);
		}
		public void displayXML(org.eigenbase.xom.XMLOutput _out, int _indent)
		{
			_out.beginTag("IgnoreMap", new org.eigenbase.xom.XMLAttrVector()
				.add("id", id)
				.add("enabled", enabled)
				);
			displayXMLElementArray(_out, regexs);
			_out.endTag("IgnoreMap");
		}
		public boolean displayDiff(org.eigenbase.xom.ElementDef _other, java.io.PrintWriter _out, int _indent)
		{
			IgnoreMap _cother = (IgnoreMap)_other;
			boolean _diff = displayElementArrayDiff("regexs", regexs, _cother.regexs, _out, _indent+1);
			return _diff;
		}
		// BEGIN pass-through code block ---
private static final String[] TEMPLATE_NAMES = new String[] { };
            protected String[] getTemplateNames() {
                return TEMPLATE_NAMES;
            }
            protected Recognizer.Matcher getMatcher() {
                return getMatcher(new String[]{});
            }
		// END pass-through code block ---
	}

	/**
	 * A RolapConnection uses one AggRule. If no name is specified, then
	 * the AggRule which is marked as default==true is used (validation
	 * fails if one and only one AggRule is not marked as the default).
	 * An AggRule has manditory child elements for matching the
	 * aggregate table names, aggregate table fact count column,
	 * foreign key columns, the measure columns, and the hierarchy level
	 * columns. These child elements can be specified as direct children
	 * of an AggRule element or by reference to elements defined as a
	 * pier to the AggRule (using references allows reuse of the child
	 * elements and with one quick edit the reference to use can be
	 * changed by changing the refid attribute value).
	 */
	public static class AggRule extends Base
	{
		public AggRule()
		{
		}

		public AggRule(org.eigenbase.xom.DOMWrapper _def)
			throws org.eigenbase.xom.XOMException
		{
			try {
				org.eigenbase.xom.DOMElementParser _parser = new org.eigenbase.xom.DOMElementParser(_def, "", DefaultDef.class);
				tag = (String)_parser.getAttribute("tag", "String", null, null, true);
				countColumn = (String)_parser.getAttribute("countColumn", "String", "fact_count", null, true);
				enabled = (Boolean)_parser.getAttribute("enabled", "Boolean", "true", null, false);
				ignoreMap = (IgnoreMap)_parser.getElement(IgnoreMap.class, false);
				ignoreMapRef = (IgnoreMapRef)_parser.getElement(IgnoreMapRef.class, false);
				factCountMatch = (FactCountMatch)_parser.getElement(FactCountMatch.class, false);
				factCountMatchRef = (FactCountMatchRef)_parser.getElement(FactCountMatchRef.class, false);
				foreignKeyMatch = (ForeignKeyMatch)_parser.getElement(ForeignKeyMatch.class, false);
				foreignKeyMatchRef = (ForeignKeyMatchRef)_parser.getElement(ForeignKeyMatchRef.class, false);
				tableMatch = (TableMatch)_parser.getElement(TableMatch.class, false);
				tableMatchRef = (TableMatchRef)_parser.getElement(TableMatchRef.class, false);
				levelMap = (LevelMap)_parser.getElement(LevelMap.class, false);
				levelMapRef = (LevelMapRef)_parser.getElement(LevelMapRef.class, false);
				measureMap = (MeasureMap)_parser.getElement(MeasureMap.class, false);
				measureMapRef = (MeasureMapRef)_parser.getElement(MeasureMapRef.class, false);
			} catch(org.eigenbase.xom.XOMException _ex) {
				throw new org.eigenbase.xom.XOMException("In " + getName() + ": " + _ex.getMessage());
			}
		}

		public String tag;  // required attribute
		public String countColumn;  // attribute default: fact_count

		/**
		 */
		public IgnoreMap ignoreMap;  //optional element
		/**
		 */
		public IgnoreMapRef ignoreMapRef;  //optional element
		/**
		 */
		public FactCountMatch factCountMatch;  //optional element
		/**
		 */
		public FactCountMatchRef factCountMatchRef;  //optional element
		/**
		 */
		public ForeignKeyMatch foreignKeyMatch;  //optional element
		/**
		 */
		public ForeignKeyMatchRef foreignKeyMatchRef;  //optional element
		/**
		 */
		public TableMatch tableMatch;  //optional element
		/**
		 */
		public TableMatchRef tableMatchRef;  //optional element
		/**
		 */
		public LevelMap levelMap;  //optional element
		/**
		 */
		public LevelMapRef levelMapRef;  //optional element
		/**
		 */
		public MeasureMap measureMap;  //optional element
		/**
		 */
		public MeasureMapRef measureMapRef;  //optional element

		public String getName()
		{
			return "AggRule";
		}

		public void display(java.io.PrintWriter _out, int _indent)
		{
			_out.println(getName());
			displayAttribute(_out, "tag", tag, _indent+1);
			displayAttribute(_out, "countColumn", countColumn, _indent+1);
			displayAttribute(_out, "enabled", enabled, _indent+1);
			displayElement(_out, "ignoreMap", ignoreMap, _indent+1);
			displayElement(_out, "ignoreMapRef", ignoreMapRef, _indent+1);
			displayElement(_out, "factCountMatch", factCountMatch, _indent+1);
			displayElement(_out, "factCountMatchRef", factCountMatchRef, _indent+1);
			displayElement(_out, "foreignKeyMatch", foreignKeyMatch, _indent+1);
			displayElement(_out, "foreignKeyMatchRef", foreignKeyMatchRef, _indent+1);
			displayElement(_out, "tableMatch", tableMatch, _indent+1);
			displayElement(_out, "tableMatchRef", tableMatchRef, _indent+1);
			displayElement(_out, "levelMap", levelMap, _indent+1);
			displayElement(_out, "levelMapRef", levelMapRef, _indent+1);
			displayElement(_out, "measureMap", measureMap, _indent+1);
			displayElement(_out, "measureMapRef", measureMapRef, _indent+1);
		}
		public void displayXML(org.eigenbase.xom.XMLOutput _out, int _indent)
		{
			_out.beginTag("AggRule", new org.eigenbase.xom.XMLAttrVector()
				.add("tag", tag)
				.add("countColumn", countColumn)
				.add("enabled", enabled)
				);
			displayXMLElement(_out, ignoreMap);
			displayXMLElement(_out, ignoreMapRef);
			displayXMLElement(_out, factCountMatch);
			displayXMLElement(_out, factCountMatchRef);
			displayXMLElement(_out, foreignKeyMatch);
			displayXMLElement(_out, foreignKeyMatchRef);
			displayXMLElement(_out, tableMatch);
			displayXMLElement(_out, tableMatchRef);
			displayXMLElement(_out, levelMap);
			displayXMLElement(_out, levelMapRef);
			displayXMLElement(_out, measureMap);
			displayXMLElement(_out, measureMapRef);
			_out.endTag("AggRule");
		}
		public boolean displayDiff(org.eigenbase.xom.ElementDef _other, java.io.PrintWriter _out, int _indent)
		{
			AggRule _cother = (AggRule)_other;
			boolean _diff = displayAttributeDiff("tag", tag, _cother.tag, _out, _indent+1);
			_diff = _diff && displayAttributeDiff("countColumn", countColumn, _cother.countColumn, _out, _indent+1);
			_diff = _diff && displayElementDiff("ignoreMap", ignoreMap, _cother.ignoreMap, _out, _indent+1);
			_diff = _diff && displayElementDiff("ignoreMapRef", ignoreMapRef, _cother.ignoreMapRef, _out, _indent+1);
			_diff = _diff && displayElementDiff("factCountMatch", factCountMatch, _cother.factCountMatch, _out, _indent+1);
			_diff = _diff && displayElementDiff("factCountMatchRef", factCountMatchRef, _cother.factCountMatchRef, _out, _indent+1);
			_diff = _diff && displayElementDiff("foreignKeyMatch", foreignKeyMatch, _cother.foreignKeyMatch, _out, _indent+1);
			_diff = _diff && displayElementDiff("foreignKeyMatchRef", foreignKeyMatchRef, _cother.foreignKeyMatchRef, _out, _indent+1);
			_diff = _diff && displayElementDiff("tableMatch", tableMatch, _cother.tableMatch, _out, _indent+1);
			_diff = _diff && displayElementDiff("tableMatchRef", tableMatchRef, _cother.tableMatchRef, _out, _indent+1);
			_diff = _diff && displayElementDiff("levelMap", levelMap, _cother.levelMap, _out, _indent+1);
			_diff = _diff && displayElementDiff("levelMapRef", levelMapRef, _cother.levelMapRef, _out, _indent+1);
			_diff = _diff && displayElementDiff("measureMap", measureMap, _cother.measureMap, _out, _indent+1);
			_diff = _diff && displayElementDiff("measureMapRef", measureMapRef, _cother.measureMapRef, _out, _indent+1);
			return _diff;
		}
		// BEGIN pass-through code block ---
private boolean isOk(final Base base) {
                return ((base != null) && base.isEnabled());
            }
            private boolean isRef(final AggRules rules,
                                  final mondrian.recorder.MessageRecorder msgRecorder,
                                  final Base base,
                                  final Base baseRef,
                                  final String baseName) {
                if (! isOk(base)) {
                    if (isOk(baseRef)) {
                        baseRef.validate(rules, msgRecorder);
                        return true;
                    } else {
                        String msg = "Neither base " +
                            baseName +
                            " or baseref " +
                            baseName +
                            "Ref is ok";
                        msgRecorder.reportError(msg);
                        return false;
                    }
                } else if (isOk(baseRef)) {
                    String msg = "Both base " +
                        base.getName() +
                        " and baseref " +
                        baseRef.getName() +
                        " are ok";
                    msgRecorder.reportError(msg);
                    return false;
                } else {
                    base.validate(rules, msgRecorder);
                    return false;
                }
            }
            // called after a constructor is called
            public void validate(final AggRules rules,
                                 final mondrian.recorder.MessageRecorder msgRecorder) {
                msgRecorder.pushContextName(getName());
                try {
                    // IgnoreMap is optional
                    if (ignoreMap != null) {
                        ignoreMap.validate(rules, msgRecorder);
                    } else if (ignoreMapRef != null) {
                        ignoreMapRef.validate(rules, msgRecorder);
                        ignoreMap =
                            rules.lookupIgnoreMap(ignoreMapRef.getRefId());
                    }
                    if (isRef(rules, msgRecorder, factCountMatch,
                            factCountMatchRef, "FactCountMatch")) {
                        factCountMatch = rules.lookupFactCountMatch(
                            factCountMatchRef.getRefId());
                    }
                    if (isRef(rules, msgRecorder, foreignKeyMatch,
                            foreignKeyMatchRef, "ForeignKeyMatch")) {
                        foreignKeyMatch = rules.lookupForeignKeyMatch(
                            foreignKeyMatchRef.getRefId());
                    }
                    if (isRef(rules, msgRecorder, tableMatch,
                            tableMatchRef, "TableMatch")) {
                        tableMatch =
                            rules.lookupTableMatch(tableMatchRef.getRefId());
                    }
                    if (isRef(rules, msgRecorder, levelMap,
                            levelMapRef, "LevelMap")) {
                        levelMap = rules.lookupLevelMap(levelMapRef.getRefId());
                    }
                    if (isRef(rules, msgRecorder, measureMap,
                            measureMapRef, "MeasureMap")) {
                        measureMap =
                            rules.lookupMeasureMap(measureMapRef.getRefId());
                    }
                } finally {
                    msgRecorder.popContextName();
                }
            }
            public String getTag() {
                return tag;
            }
            public String getCountColumn() {
                return countColumn;
            }
            public FactCountMatch getFactCountMatch() {
                return factCountMatch;
            }
            public ForeignKeyMatch getForeignKeyMatch() {
                return foreignKeyMatch;
            }
            public TableMatch getTableMatch() {
                return tableMatch;
            }
            public LevelMap getLevelMap() {
                return levelMap;
            }
            public MeasureMap getMeasureMap() {
                return measureMap;
            }
            public IgnoreMap getIgnoreMap() {
                return ignoreMap;
            }
		// END pass-through code block ---
	}


}
