/*
 * Decompiled with CFR 0.152.
 */
package com.tonbeller.wcf.utils;

import com.tonbeller.tbutils.res.Resources;
import java.io.UnsupportedEncodingException;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.Date;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.springframework.context.MessageSource;
import org.springframework.context.i18n.LocaleContextHolder;

public class I18nUtils {
    public static final String TABLE_BUNDLE = "jpivot_messages";
    public static final String FORM_BUNDLE = "jpivot_messages";
    public static final String HTML_UNICODE_CHARS = "&#;";
    public static final String HEX_STR = "x";
    public static final String UTF8 = "UTF8";
    public static String REGEX = "&#[0-9]{5};|&#[xX]([0-9aAbBcCdDeEfF]{4});";

    public static String localizedInt(String pattern, int value, Locale loc) {
        NumberFormat nf = NumberFormat.getNumberInstance(loc);
        DecimalFormat df = (DecimalFormat)nf;
        df.applyPattern(pattern);
        String output = df.format(value);
        return output;
    }

    public static String localizedDouble(String pattern, double value, Locale loc) {
        NumberFormat nf = NumberFormat.getNumberInstance(loc);
        DecimalFormat df = (DecimalFormat)nf;
        df.applyPattern(pattern);
        String output = df.format(value);
        return output;
    }

    public static String localizedDate(Date date, Locale currentLocale) {
        DateFormat dateFormatter = DateFormat.getDateInstance(2, currentLocale);
        String dateOut = dateFormatter.format(date);
        return dateOut;
    }

    public static String localizedDateTime(Date date, Locale currentLocale) {
        DateFormat dateTimeFormatter = DateFormat.getDateTimeInstance(2, 2, currentLocale);
        String dateOut = dateTimeFormatter.format(date);
        return dateOut;
    }

    public static String convertString(String intValueStr) {
        byte[] utf8Bytes = null;
        try {
            utf8Bytes = intValueStr.getBytes(UTF8);
            byte[] defaultBytes = intValueStr.getBytes();
            String string = new String(utf8Bytes, UTF8);
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        return utf8Bytes.toString();
    }

    public static void printBytes(byte[] array, String name) {
        for (int k = 0; k < array.length; ++k) {
            System.out.println(name + "[" + k + "] = " + "0x" + I18nUtils.byteToHex(array[k]));
        }
    }

    public static String byteToHex(byte b) {
        char[] hexDigit = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
        char[] array = new char[]{hexDigit[b >> 4 & 0xF], hexDigit[b & 0xF]};
        return new String(array);
    }

    public static String charToHex(char c) {
        byte hi = (byte)(c >>> 8);
        byte lo = (byte)(c & 0xFF);
        return I18nUtils.byteToHex(hi) + I18nUtils.byteToHex(lo);
    }

    public static void printCharArray(String inStr) {
        char[] myBuffer = inStr.toCharArray();
        for (int i = 0; i < inStr.length(); ++i) {
            byte b = (byte)myBuffer[i];
            short s = (short)myBuffer[i];
            String hexB = Integer.toHexString(b).toUpperCase();
            String hexS = Integer.toHexString(s).toUpperCase();
            StringBuffer sb = new StringBuffer();
            sb.append("char[");
            sb.append(i);
            sb.append("]='");
            sb.append(myBuffer[i]);
            sb.append("'\t");
            sb.append("byte=");
            sb.append(b);
            sb.append(" \\u");
            sb.append(hexB);
            sb.append('\t');
            sb.append("short=");
            sb.append(s);
            sb.append(" \\u");
            sb.append(hexS);
            sb.append('\t');
            sb.append(Character.UnicodeBlock.of(myBuffer[i]));
            System.out.println(sb.toString());
        }
        System.out.println();
    }

    public static String convertHtmlUnicode(String htmlUnicode) {
        Pattern p = Pattern.compile(REGEX);
        Matcher m = p.matcher(htmlUnicode);
        StringBuffer sb = new StringBuffer();
        while (m.find()) {
            String token = htmlUnicode.substring(m.start() + 2, m.end() - 1);
            int radix = 10;
            if (token.toLowerCase().startsWith(HEX_STR)) {
                token = token.substring(1);
                radix = 16;
            }
            char tempChar = (char)Integer.parseInt(token.toString(), radix);
            m.appendReplacement(sb, Character.toString(tempChar));
        }
        m.appendTail(sb);
        return sb.toString();
    }

    private static boolean isHexUnicode(String token) {
        if (token.length() != 5) {
            return false;
        }
        if (!token.startsWith(HEX_STR)) {
            return false;
        }
        token = token.substring(1);
        try {
            Integer.parseInt(token, 16);
        }
        catch (NumberFormatException e) {
            return false;
        }
        return true;
    }

    private static boolean isIntUnicode(String token) {
        if (token.length() != 5) {
            return false;
        }
        try {
            Integer.parseInt(token, 10);
        }
        catch (NumberFormatException e) {
            return false;
        }
        return true;
    }

    public static void debugGetMessageFromResources(Resources resources) {
        if (resources != null) {
            String msg = resources.getString("hello.world");
            if (msg != null) {
                System.out.println("*** messages retrieved: " + msg + ". ***");
            } else {
                System.out.println("*** failed to retrieve messages. ***");
            }
        } else {
            System.out.println("*** resources is null. ***");
        }
    }

    public static void debugSetMessages(MessageSource messages) {
        System.out.println("messages: " + messages.toString());
        String s = messages.getMessage("hello.world", null, new Locale("zh", "TW"));
        if (null != s) {
            System.out.println("*** messages injected. ***" + s);
        } else {
            System.out.println("*** messages injected. ***" + messages.toString());
        }
    }

    public static String debugGetMessage(String arg, Object[] args, MessageSource messages) {
        String message = null;
        if (messages != null) {
            System.out.println("messages: " + messages.toString());
            Locale locale = LocaleContextHolder.getLocale();
            if (locale != null) {
                System.out.println("*** locale is " + locale.toString() + ". ***");
                message = messages.getMessage(arg, args, locale);
            } else {
                System.out.println("*** locale is null. ***");
            }
        } else {
            System.out.println("*** messages is null. ***");
        }
        return message;
    }
}

