/*
 * Decompiled with CFR 0.152.
 */
package com.tonbeller.wcf.controller;

import com.tonbeller.wcf.controller.Dispatcher;
import com.tonbeller.wcf.controller.RequestContext;
import com.tonbeller.wcf.controller.RequestListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class DispatcherSupport
implements Dispatcher {
    private HashMap map = new HashMap();
    private HashMap inverseMap = new HashMap();

    public void addRequestListener(String name, String value, RequestListener listener) {
        this.removeRequestListener(listener);
        String key = this.getKey(name, value);
        this.map.put(listener, key);
        LinkedList<RequestListener> list = (LinkedList<RequestListener>)this.inverseMap.get(key);
        if (list == null) {
            list = new LinkedList<RequestListener>();
            this.inverseMap.put(key, list);
        }
        list.add(listener);
    }

    public void removeRequestListener(RequestListener listener) {
        String key = (String)this.map.get(listener);
        if (key != null) {
            this.map.remove(listener);
            List list = (List)this.inverseMap.get(key);
            if (list != null) {
                list.remove(listener);
            }
        }
    }

    public void clear() {
        this.map.clear();
        this.inverseMap.clear();
    }

    String getKey(String name, String value) {
        if (name != null && value != null) {
            return name + "=" + value;
        }
        if (name != null) {
            return name + "=";
        }
        if (value != null) {
            return "=" + value;
        }
        return "=";
    }

    List findAll(Map requestParameters) {
        LinkedList match = new LinkedList();
        for (String name : requestParameters.keySet()) {
            Object obj;
            String[] values = (String[])requestParameters.get(name);
            if (values != null) {
                for (int i = 0; i < values.length; ++i) {
                    if (values[i] == null || values[i].length() == 0) continue;
                    Object obj2 = this.inverseMap.get(name + "=" + values[i]);
                    if (obj2 != null) {
                        match.addAll((List)obj2);
                    }
                    if ((obj2 = this.inverseMap.get("=" + values[i])) == null) continue;
                    match.addAll((List)obj2);
                }
            }
            if ((obj = this.inverseMap.get(name + "=")) != null) {
                match.addAll((List)obj);
            }
            if (!name.endsWith(".x") || (obj = this.inverseMap.get((name = name.substring(0, name.length() - 2)) + "=")) == null) continue;
            match.addAll((List)obj);
        }
        Object obj = this.inverseMap.get("=");
        if (obj != null) {
            match.addAll((List)obj);
        }
        return match;
    }

    public void request(RequestContext context) throws Exception {
        for (RequestListener listener : this.findAll(context.getRequest().getParameterMap())) {
            listener.request(context);
        }
    }

    public List findMatchingListeners(Map httpParams) {
        List candidates = this.findAll(httpParams);
        ArrayList result = new ArrayList();
        for (Object obj : candidates) {
            if (obj instanceof Dispatcher) {
                Dispatcher d = (Dispatcher)obj;
                result.addAll(d.findMatchingListeners(httpParams));
                continue;
            }
            result.add(obj);
        }
        return result;
    }
}

