/*
 * Decompiled with CFR 0.152.
 */
package com.tonbeller.jpivot.xmla;

import com.tonbeller.jpivot.olap.mdxparse.Exp;
import com.tonbeller.jpivot.olap.mdxparse.FunCall;
import com.tonbeller.jpivot.olap.mdxparse.Literal;
import com.tonbeller.jpivot.olap.model.Axis;
import com.tonbeller.jpivot.olap.model.Hierarchy;
import com.tonbeller.jpivot.olap.model.Member;
import com.tonbeller.jpivot.olap.model.OlapException;
import com.tonbeller.jpivot.util.TreeNode;
import com.tonbeller.jpivot.util.TreeNodeCallback;
import com.tonbeller.jpivot.xmla.XMLA_Axis;
import com.tonbeller.jpivot.xmla.XMLA_Hierarchy;
import com.tonbeller.jpivot.xmla.XMLA_Level;
import com.tonbeller.jpivot.xmla.XMLA_Member;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;

public class XMLA_Util {
    static Logger logger = Logger.getLogger(XMLA_Util.class);

    public static Exp[] member2Exp(Member[] members) {
        Exp[] memExp = new Exp[members.length];
        for (int i = 0; i < memExp.length; ++i) {
            memExp[i] = Literal.createSymbol(((XMLA_Member)members[i]).getUniqueName());
        }
        return memExp;
    }

    public static Exp member2Exp(Member member) {
        return Literal.createSymbol(member.getLabel());
    }

    public static int hierIndex(XMLA_Axis axis, XMLA_Member member) {
        XMLA_Level lev = (XMLA_Level)member.getLevel();
        XMLA_Hierarchy hier = (XMLA_Hierarchy)lev.getHierarchy();
        return XMLA_Util.hierIndex(axis, hier);
    }

    public static int hierIndex(XMLA_Axis axis, XMLA_Hierarchy hier) {
        Hierarchy[] hiersOfAxis = axis.getHierarchies();
        for (int j = 0; j < hiersOfAxis.length; ++j) {
            if (!((XMLA_Hierarchy)hiersOfAxis[j]).isEqual(hier)) continue;
            return j;
        }
        return -1;
    }

    public static int axisOrdinalForMember(Axis[] axes, XMLA_Member member) {
        XMLA_Level lev = (XMLA_Level)member.getLevel();
        XMLA_Hierarchy hier = (XMLA_Hierarchy)lev.getHierarchy();
        return XMLA_Util.axisOrdinalForHier(axes, hier);
    }

    public static int axisOrdinalForHier(Axis[] axes, XMLA_Hierarchy hier) {
        for (int i = 0; i < axes.length; ++i) {
            Hierarchy[] hiersOfAxis = axes[i].getHierarchies();
            for (int j = 0; j < hiersOfAxis.length; ++j) {
                if (!((XMLA_Hierarchy)hiersOfAxis[j]).isEqual(hier)) continue;
                return i;
            }
        }
        return -1;
    }

    public static XMLA_Member[] getMemberDescendants(XMLA_Member member, XMLA_Level level) throws OlapException {
        XMLA_Level lev;
        int depth = level.getDepth();
        if (depth <= (lev = (XMLA_Level)member.getLevel()).getDepth()) {
            return new XMLA_Member[0];
        }
        ArrayList<XMLA_Member> currentMembers = new ArrayList<XMLA_Member>();
        currentMembers.add(member);
        while (depth > lev.getDepth()) {
            lev = lev.getChildLevel();
            ArrayList<XMLA_Member> aMembers = new ArrayList<XMLA_Member>();
            for (XMLA_Member m : currentMembers) {
                XMLA_Member[] mems = m.getChildren();
                for (int i = 0; i < mems.length; ++i) {
                    aMembers.add(mems[i]);
                }
            }
            currentMembers = aMembers;
        }
        return currentMembers.toArray(new XMLA_Member[0]);
    }

    public static boolean isDescendant(XMLA_Member ancestor, XMLA_Member descendant) {
        XMLA_Member mm;
        if (descendant.isCalculated()) {
            return false;
        }
        if (ancestor.equals(descendant)) {
            return false;
        }
        int ancestorLevelNumber = ((XMLA_Level)ancestor.getLevel()).getDepth();
        for (mm = descendant; mm != null && ancestorLevelNumber < ((XMLA_Level)mm.getLevel()).getDepth(); mm = (XMLA_Member)mm.getParent()) {
            try {
                continue;
            }
            catch (OlapException e) {
                logger.error((Object)"?", (Throwable)e);
                break;
            }
        }
        return mm.equals(ancestor);
    }

    public static Exp topLevelMembers(Hierarchy hier, boolean expandAllMember) {
        Exp[] topMembers;
        XMLA_Level topLevel = (XMLA_Level)((XMLA_Hierarchy)hier).getLevels()[0];
        XMLA_Member mAll = (XMLA_Member)((XMLA_Hierarchy)hier).getAllMember();
        if (mAll != null) {
            Exp[] memar = new XMLA_Member[]{mAll};
            FunCall mAllSet = new FunCall("{}", memar, 5);
            if (!expandAllMember) {
                return mAll;
            }
            FunCall mAllChildren = new FunCall("children", memar, 1);
            FunCall union = new FunCall("union", new Exp[]{mAllSet, mAllChildren}, 0);
            return union;
        }
        try {
            topMembers = topLevel.getMembers();
        }
        catch (OlapException e) {
            logger.error((Object)"?", (Throwable)e);
            return null;
        }
        if (topMembers.length == 1) {
            return topMembers[0];
        }
        return new FunCall("{}", topMembers, 5);
    }

    static List collectMembers(TreeNode root, final int iDim) {
        if (root == null) {
            return null;
        }
        final ArrayList memberList = new ArrayList();
        root.walkChildren(new TreeNodeCallback(){

            public int handleTreeNode(TreeNode node) {
                int iDimNode = node.getLevel() - 1;
                if (iDimNode < iDim) {
                    return 0;
                }
                Exp exp = (Exp)node.getReference();
                if (exp instanceof XMLA_Member) {
                    XMLA_Member m = (XMLA_Member)exp;
                    if (!memberList.contains(m)) {
                        memberList.add(m);
                    }
                } else {
                    FunCall f = (FunCall)exp;
                    try {
                        XMLA_Util.resolveFunCallMembers(f, memberList);
                    }
                    catch (OlapException e) {
                        logger.error((Object)"?", (Throwable)e);
                    }
                }
                return 1;
            }
        });
        return memberList;
    }

    static void resolveFunCallMembers(FunCall f, List memberList) throws OlapException {
        if (f.isCallTo("Children")) {
            XMLA_Member m = (XMLA_Member)f.getArgs()[0];
            XMLA_Member[] members = m.getChildren();
            for (int i = 0; i < members.length; ++i) {
                if (memberList.contains(members[i])) continue;
                memberList.add(members[i]);
            }
        } else if (f.isCallTo("Descendants")) {
            XMLA_Member m = (XMLA_Member)f.getArgs()[0];
            XMLA_Level level = (XMLA_Level)f.getArgs()[1];
            XMLA_Member[] members = XMLA_Util.getMemberDescendants(m, level);
            for (int i = 0; i < members.length; ++i) {
                if (memberList.contains(members[i])) continue;
                memberList.add(members[i]);
            }
        } else if (f.isCallTo("Members")) {
            XMLA_Level level = (XMLA_Level)f.getArgs()[0];
            XMLA_Member[] members = level.getMembers();
            for (int i = 0; i < members.length; ++i) {
                if (memberList.contains(members[i])) continue;
                memberList.add(members[i]);
            }
        } else if (f.isCallTo("Union")) {
            XMLA_Util.resolveFunCallMembers((FunCall)f.getArgs()[0], memberList);
            XMLA_Util.resolveFunCallMembers((FunCall)f.getArgs()[1], memberList);
        } else if (f.isCallTo("{}")) {
            for (int i = 0; i < f.getArgs().length; ++i) {
                if (memberList.contains(f.getArgs()[i])) continue;
                memberList.add(f.getArgs()[i]);
            }
        } else if (f.isCallTo("TopCount") || f.isCallTo("BottomCount") || f.isCallTo("TopPercent") || f.isCallTo("BottomPercent")) {
            XMLA_Util.resolveFunCallMembers((FunCall)f.getArgs()[0], memberList);
        } else {
            logger.error((Object)("invalid FunCall encountered " + f.getFunction()));
        }
    }

    public static int funCallSyntax(String fuName) {
        if (fuName.equals("()")) {
            return 6;
        }
        if (fuName.equals("{}")) {
            return 5;
        }
        if (fuName.equalsIgnoreCase("members")) {
            return 1;
        }
        if (fuName.equalsIgnoreCase("children")) {
            return 1;
        }
        return 0;
    }
}

