/*
 * Decompiled with CFR 0.152.
 */
package com.tonbeller.jpivot.table;

import com.tonbeller.jpivot.mondrian.MondrianHierarchy;
import com.tonbeller.jpivot.mondrian.MondrianLevel;
import com.tonbeller.jpivot.mondrian.MondrianMember;
import com.tonbeller.jpivot.olap.model.Dimension;
import com.tonbeller.jpivot.olap.model.Displayable;
import com.tonbeller.jpivot.olap.model.EmptyMember;
import com.tonbeller.jpivot.olap.model.Hierarchy;
import com.tonbeller.jpivot.olap.model.Level;
import com.tonbeller.jpivot.olap.model.Member;
import com.tonbeller.jpivot.olap.model.OlapException;
import com.tonbeller.jpivot.olap.model.Property;
import com.tonbeller.jpivot.olap.model.PropertyHolder;
import com.tonbeller.jpivot.olap.model.VisitorSupportStrict;
import com.tonbeller.jpivot.table.ClickableMember;
import com.tonbeller.jpivot.table.PartBuilderSupport;
import com.tonbeller.jpivot.table.SpanBuilder;
import com.tonbeller.jpivot.table.navi.DrillReplaceUI;
import com.tonbeller.jpivot.table.span.PropertyHeading;
import com.tonbeller.jpivot.table.span.PropertyUtils;
import com.tonbeller.jpivot.table.span.Span;
import com.tonbeller.jpivot.table.span.SpanVisitor;
import com.tonbeller.jpivot.xmla.XMLA_Hierarchy;
import com.tonbeller.jpivot.xmla.XMLA_Level;
import com.tonbeller.jpivot.xmla.XMLA_Member;
import com.tonbeller.tbutils.res.Resources;
import java.util.Iterator;
import java.util.List;
import mondrian.olap.HierarchyBase;
import mondrian.rolap.RolapLevel;
import org.apache.log4j.Logger;
import org.w3c.dom.Element;

public class SpanBuilderImpl
extends PartBuilderSupport
implements SpanBuilder {
    String memberName;
    String headingName;
    DrillReplaceUI dru;
    private static final Logger logger = Logger.getLogger(SpanBuilderImpl.class);

    public SpanBuilderImpl(String memberName, String headingName) {
        this.memberName = memberName;
        this.headingName = headingName;
    }

    public Element build(SpanBuilder.SBContext sbctx, Span span, boolean even) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("build " + span));
        }
        RenderSwitch renderSwitch = new RenderSwitch(sbctx);
        Displayable v = span.getObject();
        if (v != null) {
            v.accept(renderSwitch);
        }
        Element elem = renderSwitch.getElem();
        Iterator it = this.table.clickableIterator();
        while (it.hasNext()) {
            ((ClickableMember)it.next()).decorate(sbctx, span.getObject());
        }
        return elem;
    }

    class RenderSwitch
    extends VisitorSupportStrict
    implements SpanVisitor {
        private static final String CAPTION = "caption";
        Element elem;
        private SpanBuilder.SBContext sbctx;

        public RenderSwitch(SpanBuilder.SBContext sbctx) {
            this.sbctx = sbctx;
        }

        void renderHeading(Displayable d) {
            if (d == null) {
                return;
            }
            this.elem = SpanBuilderImpl.this.table.elem(SpanBuilderImpl.this.headingName);
            SpanBuilderImpl.this.dru = (DrillReplaceUI)SpanBuilderImpl.this.table.getExtensions().get("drillReplace");
            if (SpanBuilderImpl.this.dru == null) {
                return;
            }
            if (!SpanBuilderImpl.this.dru.isEnabled() || !this.canZoomOut(d) || this.isZooming(d)) {
                Element caption = SpanBuilderImpl.this.table.append(CAPTION, this.elem);
                String label = this.getCaptionForHeading(d);
                logger.debug((Object)("renderHeading: label = " + label));
                caption.setAttribute(CAPTION, label);
                this.sbctx.setCaption(caption, label);
            }
        }

        private void renderMember(Displayable d, String label) {
            if (d == null || label == null) {
                return;
            }
            this.elem = SpanBuilderImpl.this.table.elem(SpanBuilderImpl.this.memberName);
            Element caption = SpanBuilderImpl.this.table.append(CAPTION, this.elem);
            SpanBuilderImpl.this.dru = (DrillReplaceUI)SpanBuilderImpl.this.table.getExtensions().get("drillReplace");
            if (SpanBuilderImpl.this.dru == null) {
                return;
            }
            if (!SpanBuilderImpl.this.dru.isEnabled() || this.isRolapStoredMeasure(d) || this.isZooming(d) || d instanceof MondrianMember.MondrianProp) {
                caption.setAttribute(CAPTION, label);
                this.sbctx.setCaption(caption, d.getLabel());
            }
            if (d instanceof PropertyHolder) {
                String value;
                Property[] props = ((PropertyHolder)((Object)d)).getProperties();
                PropertyUtils.addInlineProperties(caption, props);
                Property style = PropertyUtils.getInlineProperty(props, "style");
                if (style != null && (value = style.getValue().trim()) != null && value.length() > 0) {
                    this.elem.setAttribute("style", value.toLowerCase());
                }
            }
        }

        private String getCaptionForHeading(Displayable d) {
            XMLA_Level level;
            Hierarchy hierarchy;
            String label = d.getLabel();
            if (d instanceof MondrianLevel) {
                MondrianLevel level2 = (MondrianLevel)d;
                Hierarchy hierarchy2 = level2.getHierarchy();
                if (hierarchy2 != null) {
                    HierarchyBase hierarchyBase = (HierarchyBase)((MondrianHierarchy)hierarchy2).getMonHierarchy();
                    RolapLevel rl = (RolapLevel)level2.getMonLevel();
                    if (rl != null && hierarchyBase != null && rl.getName().equals(Resources.instance().getString("(All)"))) {
                        return hierarchyBase.getCaption();
                    }
                }
            } else if (d instanceof XMLA_Level && (hierarchy = (level = (XMLA_Level)d).getHierarchy()) != null) {
                XMLA_Hierarchy xh = (XMLA_Hierarchy)hierarchy;
                XMLA_Level xl = level;
                if (xl.getName().equals(Resources.instance().getString("(All)"))) {
                    return xh.getCaption();
                }
            }
            return label;
        }

        private boolean canZoomOut(Displayable d) {
            boolean result;
            block16: {
                block17: {
                    if (d == null) {
                        return false;
                    }
                    result = false;
                    if (!(d instanceof MondrianLevel)) break block17;
                    MondrianLevel level = (MondrianLevel)d;
                    Hierarchy hierarchy = level.getHierarchy();
                    if (hierarchy == null) {
                        return false;
                    }
                    MondrianLevel[] levels = (MondrianLevel[])hierarchy.getLevels();
                    if (levels == null) {
                        return false;
                    }
                    if (level.getMonLevel() == null) {
                        return false;
                    }
                    String label = level.getMonLevel().getName();
                    if (label == null) {
                        return false;
                    }
                    for (int i = 1; i < levels.length && levels[i] != null; ++i) {
                        if (!levels[i].getLabel().equals(label)) continue;
                        if (levels[i - 1] == null || !(levels[i - 1] instanceof MondrianLevel)) break block16;
                        result = levels[i - 1].isZooming();
                        List memberList = levels[i - 1].getMembers();
                        if (memberList != null) {
                            Iterator itr = memberList.iterator();
                            while (itr.hasNext()) {
                                result |= ((MondrianMember)itr.next()).isZooming();
                            }
                        }
                        break block16;
                    }
                    break block16;
                }
                if (!(d instanceof XMLA_Level)) break block16;
                XMLA_Level level = (XMLA_Level)d;
                Hierarchy hierarchy = level.getHierarchy();
                if (hierarchy == null) {
                    return false;
                }
                XMLA_Level[] levels = (XMLA_Level[])hierarchy.getLevels();
                if (levels == null) {
                    return false;
                }
                String label = level.getLabel();
                if (label == null) {
                    return false;
                }
                for (int i = 1; i < levels.length && levels[i] != null; ++i) {
                    if (!levels[i].getLabel().equals(label)) continue;
                    if (levels[i - 1] == null || !(levels[i - 1] instanceof XMLA_Level)) break;
                    result = levels[i - 1].isZooming();
                    try {
                        XMLA_Member[] members = levels[i - 1].getMembers();
                        if (members == null) {
                            return false;
                        }
                        for (int j = 0; j < members.length && members[j] != null; ++j) {
                            result |= members[j].isZooming();
                        }
                        break;
                    }
                    catch (OlapException e) {
                        e.printStackTrace();
                        break;
                    }
                }
            }
            return result;
        }

        private boolean isRolapStoredMeasure(Displayable d) {
            XMLA_Member m;
            if (d == null) {
                return false;
            }
            boolean result = false;
            if (d instanceof MondrianMember) {
                MondrianMember m2 = (MondrianMember)d;
                if (m2.isDrilling()) {
                    result = true;
                }
            } else if (d instanceof XMLA_Member && (m = (XMLA_Member)d).isDrilling()) {
                result = true;
            }
            return result;
        }

        private boolean isLeaf(Displayable d) {
            if (d == null) {
                return false;
            }
            boolean result = false;
            if (d instanceof MondrianMember) {
                MondrianMember m = (MondrianMember)d;
                Level level = m.getLevel();
                if (level == null) {
                    return false;
                }
                result = !((MondrianLevel)level).hasChildLevel();
            } else if (d instanceof XMLA_Member) {
                XMLA_Member m = (XMLA_Member)d;
                Level level = m.getLevel();
                if (level == null) {
                    return false;
                }
                result = !((XMLA_Level)level).hasChildLevel();
            }
            return result;
        }

        private boolean isZooming(Displayable d) {
            boolean result;
            block8: {
                block10: {
                    block9: {
                        block7: {
                            if (d == null) {
                                return false;
                            }
                            result = false;
                            if (!(d instanceof MondrianMember)) break block7;
                            MondrianMember mm = (MondrianMember)d;
                            result = mm.isZooming();
                            break block8;
                        }
                        if (!(d instanceof MondrianLevel)) break block9;
                        List members = ((MondrianLevel)d).getMembers();
                        if (members == null) {
                            return false;
                        }
                        Iterator itr = members.iterator();
                        while (itr.hasNext()) {
                            result |= ((MondrianMember)itr.next()).isZooming();
                        }
                        break block8;
                    }
                    if (!(d instanceof XMLA_Member)) break block10;
                    XMLA_Member mm = (XMLA_Member)d;
                    result = mm.isZooming();
                    break block8;
                }
                if (!(d instanceof XMLA_Level)) break block8;
                try {
                    XMLA_Member[] members = ((XMLA_Level)d).getMembers();
                    if (members == null) {
                        return false;
                    }
                    for (int i = 0; i < members.length && members[i] != null; ++i) {
                        result |= members[i].isZooming();
                    }
                }
                catch (OlapException e) {
                    e.printStackTrace();
                }
            }
            return result;
        }

        public void visitPropertyHeading(PropertyHeading v) {
            this.renderHeading(v);
        }

        public void visitDimension(Dimension v) {
            this.renderHeading(v);
        }

        public void visitHierarchy(Hierarchy v) {
            this.renderHeading(v);
        }

        public void visitLevel(Level v) {
            this.renderHeading(v);
        }

        public void visitMember(Member v) {
            this.renderMember(v, v.getLabel());
        }

        public void visitProperty(Property v) {
            this.renderMember(v, v.getValue());
        }

        public void visitEmptyMember(EmptyMember v) {
            this.renderMember(v, v.getLabel());
        }

        public Element getElem() {
            return this.elem;
        }

        public void setElem(Element elem) {
            this.elem = elem;
        }
    }
}

