/*
 * Decompiled with CFR 0.152.
 */
package com.tonbeller.jpivot.navigator.hierarchy;

import com.tonbeller.jpivot.navigator.hierarchy.AbstractCategory;
import com.tonbeller.jpivot.navigator.hierarchy.HierarchyNavigator;
import com.tonbeller.jpivot.olap.model.Dimension;
import com.tonbeller.jpivot.olap.model.Hierarchy;
import com.tonbeller.jpivot.olap.model.Member;
import com.tonbeller.jpivot.olap.model.OlapUtils;
import com.tonbeller.jpivot.olap.navi.ChangeSlicer;
import com.tonbeller.jpivot.olap.navi.PlaceMembersOnAxes;
import com.tonbeller.tbutils.res.Resources;
import com.tonbeller.wcf.catedit.Item;
import com.tonbeller.wcf.controller.RequestContext;
import com.tonbeller.wcf.controller.RequestListener;
import com.tonbeller.wcf.utils.DomUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.apache.log4j.Logger;

public class HierarchyItem
implements Item,
RequestListener,
Comparable {
    private static final Logger logger = Logger.getLogger(HierarchyItem.class);
    private Resources resources = Resources.instance();
    private HierarchyNavigator navigator;
    private AbstractCategory category;
    private Hierarchy hierarchy;
    private List axisSelection;
    private boolean axisSelectionDirty;
    private List slicerSelection;
    private boolean slicerSelectionDirty;
    private List deleted = new ArrayList();
    private Object expression;
    private String id = DomUtils.randomId();
    private Dimension dimension;

    public String getId() {
        return this.id;
    }

    public HierarchyItem(AbstractCategory category, Hierarchy hierarchy) {
        this.category = category;
        this.hierarchy = hierarchy;
        this.dimension = hierarchy.getDimension();
        this.navigator = category.getNavigator();
        this.navigator.getTempDispatcher().addRequestListener(this.id, null, (RequestListener)this);
    }

    void initializeSlicerSelection() {
        ChangeSlicer slicerExtension = this.navigator.getSlicerExtension();
        this.slicerSelection = new ArrayList();
        if (slicerExtension != null) {
            Member[] members = slicerExtension.getSlicer();
            for (int i = 0; i < members.length; ++i) {
                if (!members[i].getLevel().getHierarchy().equals(this.hierarchy)) continue;
                this.slicerSelection.add(members[i]);
                break;
            }
        }
    }

    void initializeAxisSelection() {
        PlaceMembersOnAxes memberExtension = this.navigator.getMemberExtension();
        this.axisSelection = new ArrayList();
        if (memberExtension != null) {
            List members = memberExtension.findVisibleMembers(this.hierarchy);
            this.axisSelection.addAll(members);
        }
    }

    private void clear() {
        this.axisSelection = null;
        this.slicerSelection = null;
        this.deleted.clear();
        this.expression = null;
    }

    public void setCategory(AbstractCategory category) {
        this.category = category;
    }

    public AbstractCategory getCategory() {
        return this.category;
    }

    public Hierarchy getHierarchy() {
        return this.hierarchy;
    }

    public Dimension getDimension() {
        return this.dimension;
    }

    public String getLabel() {
        return this.hierarchy.getLabel();
    }

    public void request(RequestContext context) throws Exception {
        this.category.itemClicked(context, this);
    }

    public List getAxisSelection() {
        if (this.axisSelection == null) {
            this.initializeAxisSelection();
        }
        return this.axisSelection;
    }

    public List getSlicerSelection() {
        if (this.slicerSelection == null) {
            this.initializeSlicerSelection();
        }
        return this.slicerSelection;
    }

    public void setAxisSelection(Collection selection) {
        if (((Object)selection).equals(this.axisSelection)) {
            return;
        }
        this.clear();
        this.updateHierarchy(selection);
        if (this.axisSelection == null) {
            this.axisSelection = new ArrayList();
        } else {
            this.axisSelection.clear();
        }
        this.axisSelection.addAll(selection);
        this.axisSelectionDirty = true;
        this.category.setDirty(true);
        this.expression = null;
    }

    public void setSlicerSelection(Collection selection) {
        this.clear();
        this.updateHierarchy(selection);
        if (this.slicerSelection == null) {
            this.slicerSelection = new ArrayList();
        } else {
            this.slicerSelection.clear();
        }
        this.slicerSelection.addAll(selection);
        this.slicerSelectionDirty = true;
        this.category.setDirty(true);
        this.expression = null;
    }

    private void updateHierarchy(Collection selection) {
        if (selection == null || selection.isEmpty()) {
            this.hierarchy = this.dimension.getHierarchies()[0];
        } else {
            Member m = (Member)selection.iterator().next();
            this.hierarchy = m.getLevel().getHierarchy();
            if (!this.hierarchy.getDimension().equals(this.dimension)) {
                logger.error((Object)(this.resources.getString("jpivot.HierarchyItem.error.invalidDimension") + this.hierarchy.getLabel()));
            }
        }
    }

    public boolean isAxisSelectionDirty() {
        return this.axisSelectionDirty;
    }

    public boolean isSlicerSelectionDirty() {
        return this.slicerSelectionDirty;
    }

    public void setAxisSelectionDirty(boolean axisSelectionDirty) {
        this.axisSelectionDirty = axisSelectionDirty;
    }

    public void setSlicerSelectionDirty(boolean slicerSelectionDirty) {
        this.slicerSelectionDirty = slicerSelectionDirty;
    }

    public void setSelection(Collection selection) {
        this.category.setSelection(this, selection);
    }

    public String validateSelection(Collection selection) {
        return this.category.validateSelection(this, selection);
    }

    public int compareTo(Object arg) {
        HierarchyItem that = (HierarchyItem)arg;
        return Resources.instance().getCollator().compare(this.hierarchy.getLabel(), that.getHierarchy().getLabel());
    }

    public void removeFromSelection(Set deleted) {
        if (this.axisSelection != null) {
            this.axisSelection.removeAll(deleted);
        }
        if (this.slicerSelection != null) {
            this.slicerSelection.removeAll(deleted);
        }
    }

    public Collection getDeleted() {
        return this.deleted;
    }

    public void setDeleted(Collection c) {
        this.deleted.clear();
        this.deleted.addAll(c);
    }

    public Object getExpression() {
        return this.expression;
    }

    public void setExpression(Object object) {
        this.clear();
        this.expression = object;
        this.category.setDirty(true);
    }

    public boolean isMovable() {
        return !OlapUtils.isSingleRecord(this.hierarchy);
    }

    public boolean isClickable() {
        return this.navigator.getHierarchyItemClickHandler() != null;
    }
}

