/*
 * Decompiled with CFR 0.152.
 */
package com.tonbeller.jpivot.mondrian;

import com.tonbeller.jpivot.mondrian.MondrianHierarchy;
import com.tonbeller.jpivot.mondrian.MondrianModel;
import com.tonbeller.jpivot.mondrian.MondrianPosition;
import com.tonbeller.jpivot.mondrian.MondrianQueryAdapter;
import com.tonbeller.jpivot.olap.model.Axis;
import com.tonbeller.jpivot.olap.model.Hierarchy;
import com.tonbeller.jpivot.olap.model.Visitor;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import mondrian.olap.AxisOrdinal;
import mondrian.olap.Member;
import mondrian.olap.Position;

public class MondrianAxis
implements Axis {
    private mondrian.olap.Axis monAxis = null;
    private MondrianModel model = null;
    private ArrayList aPositions = null;
    private MondrianHierarchy[] hierarchies = null;
    private int ordinal;

    public MondrianAxis(int iOrdinal, mondrian.olap.Axis monAxis, MondrianModel model) {
        this.ordinal = iOrdinal;
        this.monAxis = monAxis;
        this.model = model;
        this.aPositions = new ArrayList();
        boolean foundQueryHierarchies = true;
        if (iOrdinal >= 0) {
            MondrianQueryAdapter adapter = (MondrianQueryAdapter)model.getQueryAdapter();
            mondrian.olap.Hierarchy[] monHiers = adapter.getMonQuery().getMdxHierarchiesOnAxis(AxisOrdinal.StandardAxisOrdinal.forLogicalOrdinal((int)iOrdinal));
            this.hierarchies = new MondrianHierarchy[monHiers.length];
            for (int j = 0; j < this.hierarchies.length; ++j) {
                if (monHiers[j] == null) {
                    foundQueryHierarchies = false;
                    continue;
                }
                this.hierarchies[j] = model.lookupHierarchy(monHiers[j].getUniqueName());
            }
        }
        List monPositions = monAxis.getPositions();
        Iterator pit = monPositions.iterator();
        int i = 0;
        while (pit.hasNext()) {
            Position monPosition = (Position)pit.next();
            MondrianPosition position = new MondrianPosition(monPosition, iOrdinal, model);
            this.aPositions.add(position);
            if (!(iOrdinal != -1 && foundQueryHierarchies || i != 0)) {
                ArrayList<MondrianHierarchy> l = new ArrayList<MondrianHierarchy>();
                for (Member monMember : monPosition) {
                    l.add(model.lookupHierarchy(monMember.getHierarchy().getUniqueName()));
                }
                this.hierarchies = l.toArray(new MondrianHierarchy[l.size()]);
            }
            ++i;
        }
    }

    public List getPositions() {
        return this.aPositions;
    }

    public Hierarchy[] getHierarchies() {
        return this.hierarchies;
    }

    public void accept(Visitor visitor) {
        visitor.visitAxis(this);
    }

    public Object getRootDecoree() {
        return this;
    }

    public int getOrdinal() {
        return this.ordinal;
    }
}

