/*
 * Decompiled with CFR 0.152.
 */
package com.ingres.gcf.util;

import com.ingres.gcf.util.DbmsConst;
import com.ingres.gcf.util.SqlData;
import com.ingres.gcf.util.SqlDates;
import com.ingres.gcf.util.SqlEx;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Date;
import java.util.TimeZone;

public class SqlTimestamp
extends SqlData
implements DbmsConst {
    private String value = null;
    private int nanos = 0;
    private String timezone = null;
    private short dbms_type = (short)19;

    public SqlTimestamp(short s) throws SqlEx {
        super(true);
        switch (s) {
            case 9: 
            case 18: 
            case 19: {
                this.dbms_type = s;
                break;
            }
            default: {
                throw SqlEx.get(ERR_GC401B_INVALID_DATE);
            }
        }
    }

    public void set(String string) throws SqlEx {
        if (string == null) {
            this.setNull();
        } else {
            if (this.dbms_type == 18) {
                if (string.length() < "yyyy-MM-dd HH:mm:ss".length() + "+HH:mm".length()) {
                    throw SqlEx.get(ERR_GC401B_INVALID_DATE);
                }
                int n = string.length() - "+HH:mm".length();
                this.timezone = string.substring(n);
                string = string.substring(0, n);
            }
            if (string.length() > "yyyy-MM-dd HH:mm:ss".length()) {
                this.nanos = SqlDates.parseFrac(string.substring("yyyy-MM-dd HH:mm:ss".length()));
                string = string.substring(0, "yyyy-MM-dd HH:mm:ss".length());
            }
            this.setNotNull();
            this.value = string;
        }
    }

    public void set(SqlTimestamp sqlTimestamp) {
        this.dbms_type = sqlTimestamp.dbms_type;
        if (sqlTimestamp == null || sqlTimestamp.isNull()) {
            this.setNull();
        } else {
            this.setNotNull();
            this.value = sqlTimestamp.value;
            this.nanos = sqlTimestamp.nanos;
            this.timezone = sqlTimestamp.timezone;
        }
    }

    public String get() {
        String string = this.value;
        if (this.nanos > 0) {
            string = string + SqlDates.formatFrac(this.nanos);
        }
        if (this.dbms_type == 18) {
            string = string + this.timezone;
        }
        return string;
    }

    public void setString(String string) throws SqlEx {
        if (string == null) {
            this.setNull();
        } else {
            Timestamp timestamp;
            try {
                timestamp = Timestamp.valueOf(string);
            }
            catch (Exception exception) {
                throw SqlEx.get(ERR_GC401A_CONVERSION_ERR);
            }
            this.setTimestamp(timestamp, null);
        }
    }

    public void setDate(java.sql.Date date, TimeZone timeZone) throws SqlEx {
        this.set(date, timeZone);
    }

    public void setTime(Time time, TimeZone timeZone) throws SqlEx {
        this.set(time, timeZone);
    }

    public void setTimestamp(Timestamp timestamp, TimeZone timeZone) throws SqlEx {
        this.set(timestamp, timeZone);
        if (timestamp != null) {
            this.nanos = timestamp.getNanos();
        }
    }

    private void set(Date date, TimeZone timeZone) throws SqlEx {
        if (date == null) {
            this.setNull();
            return;
        }
        this.setNotNull();
        this.nanos = 0;
        switch (this.dbms_type) {
            case 19: {
                this.value = SqlDates.formatTimestamp(date, true);
                break;
            }
            case 9: {
                this.value = timeZone != null ? SqlDates.formatTimestamp(date, timeZone) : SqlDates.formatTimestamp(date, false);
                break;
            }
            case 18: {
                this.value = timeZone != null ? SqlDates.formatTimestamp(date, timeZone) : SqlDates.formatTimestamp(date, false);
                String string = this.timezone = timeZone != null ? SqlDates.formatTZ(timeZone, date) : SqlDates.formatTZ(date);
            }
        }
        if (this.value == null || this.value.length() < 19 || this.value.length() > 29 || this.value.charAt(10) != ' ' || this.value.charAt(13) != ':' || this.value.charAt(16) != ':') {
            throw SqlEx.get(ERR_GC401A_CONVERSION_ERR);
        }
    }

    public String getString() throws SqlEx {
        String string = SqlDates.formatTimestamp((Date)this.get(null), false);
        if (this.nanos > 0) {
            string = string + SqlDates.formatFrac(this.nanos);
        }
        return string;
    }

    public java.sql.Date getDate(TimeZone timeZone) throws SqlEx {
        return SqlDates.parseDate(SqlDates.formatDate((Date)this.get(timeZone), false), false);
    }

    public Time getTime(TimeZone timeZone) throws SqlEx {
        return SqlDates.parseTime(SqlDates.formatTime((Date)this.get(timeZone), false), false);
    }

    public Timestamp getTimestamp(TimeZone timeZone) throws SqlEx {
        return this.get(timeZone);
    }

    public Object getObject() throws SqlEx {
        return this.get(null);
    }

    private Timestamp get(TimeZone timeZone) throws SqlEx {
        Timestamp timestamp = null;
        switch (this.dbms_type) {
            case 19: {
                timestamp = SqlDates.parseTimestamp(this.value, true);
                break;
            }
            case 9: {
                timestamp = timeZone != null ? SqlDates.parseTimestamp(this.value, timeZone) : SqlDates.parseTimestamp(this.value, false);
                break;
            }
            case 18: {
                timestamp = SqlDates.parseTimestamp(this.value, SqlDates.getTZ(this.timezone));
            }
        }
        timestamp.setNanos(this.nanos);
        return timestamp;
    }

    public int getNanos() {
        return this.nanos;
    }
}

