/*
 * Decompiled with CFR 0.152.
 */
package com.ingres.gcf.util;

import com.ingres.gcf.util.SqlData;
import com.ingres.gcf.util.SqlEx;
import java.math.BigDecimal;

public class SqlSmallInt
extends SqlData {
    private short value = 0;

    public SqlSmallInt() {
        super(true);
    }

    public SqlSmallInt(short s) {
        super(false);
        this.value = s;
    }

    public void set(short s) {
        this.setNotNull();
        this.value = s;
    }

    public void set(SqlSmallInt sqlSmallInt) {
        if (sqlSmallInt == null || sqlSmallInt.isNull()) {
            this.setNull();
        } else {
            this.setNotNull();
            this.value = sqlSmallInt.value;
        }
    }

    public short get() {
        return this.value;
    }

    public void setBoolean(boolean bl) throws SqlEx {
        this.setNotNull();
        this.value = (short)(bl ? 1 : 0);
    }

    public void setByte(byte by) throws SqlEx {
        this.setNotNull();
        this.value = by;
    }

    public void setShort(short s) throws SqlEx {
        this.setNotNull();
        this.value = s;
    }

    public void setInt(int n) throws SqlEx {
        this.setNotNull();
        this.value = (short)n;
    }

    public void setLong(long l) throws SqlEx {
        this.setNotNull();
        this.value = (short)l;
    }

    public void setFloat(float f) throws SqlEx {
        this.setNotNull();
        this.value = (short)f;
    }

    public void setDouble(double d) throws SqlEx {
        this.setNotNull();
        this.value = (short)d;
    }

    public void setBigDecimal(BigDecimal bigDecimal) throws SqlEx {
        if (bigDecimal == null) {
            this.setNull();
        } else {
            this.setNotNull();
            this.value = (short)bigDecimal.intValue();
        }
    }

    public void setString(String string) throws SqlEx {
        if (string == null) {
            this.setNull();
        } else {
            this.setNotNull();
            try {
                this.value = Short.parseShort(string.trim());
            }
            catch (NumberFormatException numberFormatException) {
                throw SqlEx.get(ERR_GC401A_CONVERSION_ERR);
            }
        }
    }

    public boolean getBoolean() throws SqlEx {
        return this.value != 0;
    }

    public byte getByte() throws SqlEx {
        return (byte)this.value;
    }

    public short getShort() throws SqlEx {
        return this.value;
    }

    public int getInt() throws SqlEx {
        return this.value;
    }

    public long getLong() throws SqlEx {
        return this.value;
    }

    public float getFloat() throws SqlEx {
        return this.value;
    }

    public double getDouble() throws SqlEx {
        return this.value;
    }

    public BigDecimal getBigDecimal() throws SqlEx {
        return BigDecimal.valueOf(this.value);
    }

    public String getString() throws SqlEx {
        return Short.toString(this.value);
    }

    public Object getObject() throws SqlEx {
        return new Integer(this.value);
    }
}

