/*
 * Decompiled with CFR 0.152.
 */
package com.ingres.gcf.util;

import com.ingres.gcf.util.GcfErr;
import com.ingres.gcf.util.IdMap;
import com.ingres.gcf.util.SqlEx;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Hashtable;
import java.util.SimpleTimeZone;
import java.util.TimeZone;
import java.util.Vector;

public class SqlDates
implements GcfErr {
    public static final String D_EPOCH = "1970-01-01";
    public static final String T_EPOCH = "00:00:00";
    public static final String TS_EPOCH = "1970-01-01 00:00:00";
    public static final String D_FMT = "yyyy-MM-dd";
    public static final String T_FMT = "HH:mm:ss";
    public static final String TS_FMT = "yyyy-MM-dd HH:mm:ss";
    public static final String D_LIT_FMT = "yyyy_MM_dd";
    public static final String T_LIT_FMT = "HH:mm:ss";
    public static final String TS_LIT_FMT = "yyyy_MM_dd HH:mm:ss";
    public static final String TZ_FMT = "+HH:mm";
    private static TimeZone tz_gmt = TimeZone.getTimeZone("GMT");
    private static TimeZone tz_lcl = TimeZone.getDefault();
    private static DateFormat df_ts_val = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    private static DateFormat df_d_val = new SimpleDateFormat("yyyy-MM-dd");
    private static DateFormat df_t_val = new SimpleDateFormat("HH:mm:ss");
    private static DateFormat df_ts_lit = new SimpleDateFormat("yyyy_MM_dd HH:mm:ss");
    private static DateFormat df_d_lit = new SimpleDateFormat("yyyy_MM_dd");
    private static DateFormat df_t_lit = new SimpleDateFormat("HH:mm:ss");
    private static java.sql.Date epochDate = null;
    private static Time epochTime = null;
    private static Timestamp epochTS = null;
    private static Hashtable tzCache = new Hashtable();
    private static Vector tzoCache = new Vector();
    private static char[] digits = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9'};
    private static char[] zeros = new char[]{'0', '0', '0', '0', '0', '0', '0', '0', '0'};

    public static java.sql.Date getEpochDate() throws SqlEx {
        if (epochDate == null) {
            epochDate = SqlDates.parseDate(D_EPOCH, tz_lcl);
        }
        return epochDate;
    }

    public static Time getEpochTime() throws SqlEx {
        if (epochTime == null) {
            epochTime = SqlDates.parseTime(T_EPOCH, tz_lcl);
        }
        return epochTime;
    }

    public static Timestamp getEpochTimestamp() throws SqlEx {
        if (epochTS == null) {
            epochTS = SqlDates.parseTimestamp(TS_EPOCH, tz_lcl);
        }
        return epochTS;
    }

    public static int parseOffset(String string) throws SqlEx {
        if (string.length() != TZ_FMT.length() || string.charAt(0) != '+' && string.charAt(0) != '-' || !Character.isDigit(string.charAt(1)) || !Character.isDigit(string.charAt(2)) || string.charAt(3) != ':' || !Character.isDigit(string.charAt(4)) || !Character.isDigit(string.charAt(5))) {
            throw SqlEx.get(ERR_GC401B_INVALID_DATE);
        }
        int n = Character.digit(string.charAt(1), 10) * 10 + Character.digit(string.charAt(2), 10);
        int n2 = Character.digit(string.charAt(4), 10) * 10 + Character.digit(string.charAt(5), 10);
        int n3 = n * 60 + n2;
        if (string.charAt(0) == '-') {
            n3 = -n3;
        }
        return n3;
    }

    public static String formatOffset(int n) {
        int n2;
        String string = null;
        for (n2 = 0; n2 < tzoCache.size(); ++n2) {
            IdMap idMap = (IdMap)tzoCache.get(n2);
            if (!idMap.equals(n)) continue;
            string = idMap.toString();
            break;
        }
        if (string == null) {
            int n3 = n2 = n < 0 ? 1 : 0;
            if (n2 != 0) {
                n = -n;
            }
            int n4 = n / 60;
            int n5 = n % 60;
            char[] cArray = new char[]{n2 != 0 ? (char)'-' : '+', digits[n4 / 10 % 10], digits[n4 % 10], ':', digits[n5 / 10 % 10], digits[n5 % 10]};
            if (n2 != 0) {
                n = -n;
            }
            string = new String(cArray);
            tzoCache.add(new IdMap(n, string));
        }
        return string;
    }

    public static TimeZone getTZ(int n) throws SqlEx {
        return SqlDates.getTZ(SqlDates.formatOffset(n));
    }

    public static TimeZone getTZ(String string) throws SqlEx {
        TimeZone timeZone = (TimeZone)tzCache.get(string);
        if (timeZone == null) {
            int n = SqlDates.parseOffset(string);
            timeZone = new SimpleTimeZone(n * 60000, "GMT" + string);
            tzCache.put(string, timeZone);
        }
        return timeZone;
    }

    public static String formatTZ(Date date) {
        return SqlDates.formatTZ(tz_lcl, date.getTime());
    }

    public static String formatTZ(TimeZone timeZone, Date date) {
        return SqlDates.formatTZ(timeZone, date.getTime());
    }

    public static String formatTZ(long l) {
        return SqlDates.formatTZ(tz_lcl, l);
    }

    public static String formatTZ(TimeZone timeZone, long l) {
        return SqlDates.formatOffset(timeZone.getOffset(l) / 60000);
    }

    public static int parseFrac(String string) throws SqlEx {
        int n = 0;
        if (string.length() < 1 || string.charAt(0) != '.') {
            throw SqlEx.get(ERR_GC401B_INVALID_DATE);
        }
        StringBuffer stringBuffer = new StringBuffer(string);
        if (stringBuffer.length() > 10) {
            stringBuffer.setLength(10);
        }
        if (stringBuffer.length() < 10) {
            stringBuffer.append(zeros, 0, 10 - stringBuffer.length());
        }
        try {
            n = Integer.parseInt(stringBuffer.substring(1));
        }
        catch (NumberFormatException numberFormatException) {
            throw SqlEx.get(ERR_GC401B_INVALID_DATE);
        }
        return n;
    }

    public static String formatFrac(int n) {
        if (n == 0) {
            return ".0";
        }
        if (n < 0) {
            n = -n;
        }
        StringBuffer stringBuffer = new StringBuffer();
        String string = Integer.toString(n);
        stringBuffer.append('.');
        if (string.length() < 9) {
            stringBuffer.append(zeros, 0, 9 - string.length());
        }
        stringBuffer.append(string);
        int n2 = 10;
        while (stringBuffer.charAt(n2 - 1) == '0') {
            --n2;
        }
        stringBuffer.setLength(n2);
        return stringBuffer.toString();
    }

    public static Time parseTime(String string, boolean bl) throws SqlEx {
        return SqlDates.parseTime(string, bl ? tz_gmt : tz_lcl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Time parseTime(String string, TimeZone timeZone) throws SqlEx {
        Date date;
        if (string.length() != "HH:mm:ss".length()) {
            throw SqlEx.get(ERR_GC401B_INVALID_DATE);
        }
        DateFormat dateFormat = df_t_val;
        synchronized (dateFormat) {
            df_t_val.setTimeZone(timeZone);
            try {
                date = df_t_val.parse(string);
            }
            catch (Exception exception) {
                throw SqlEx.get(ERR_GC401B_INVALID_DATE);
            }
        }
        return new Time(date.getTime());
    }

    public static String formatTime(Date date, boolean bl) {
        return SqlDates.formatTime(date, bl ? tz_gmt : tz_lcl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String formatTime(Date date, TimeZone timeZone) {
        String string;
        DateFormat dateFormat = df_t_val;
        synchronized (dateFormat) {
            df_t_val.setTimeZone(timeZone);
            string = df_t_val.format(date);
        }
        return string;
    }

    public static String formatTimeLit(Date date, boolean bl) {
        return SqlDates.formatTimeLit(date, bl ? tz_gmt : tz_lcl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String formatTimeLit(Date date, TimeZone timeZone) {
        String string;
        DateFormat dateFormat = df_t_lit;
        synchronized (dateFormat) {
            df_t_lit.setTimeZone(timeZone);
            string = df_t_lit.format(date);
        }
        return string;
    }

    public static java.sql.Date parseDate(String string, boolean bl) throws SqlEx {
        return SqlDates.parseDate(string, bl ? tz_gmt : tz_lcl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static java.sql.Date parseDate(String string, TimeZone timeZone) throws SqlEx {
        Date date;
        if (string.length() != D_FMT.length()) {
            throw SqlEx.get(ERR_GC401B_INVALID_DATE);
        }
        DateFormat dateFormat = df_d_val;
        synchronized (dateFormat) {
            df_d_val.setTimeZone(timeZone);
            try {
                date = df_d_val.parse(string);
            }
            catch (Exception exception) {
                throw SqlEx.get(ERR_GC401B_INVALID_DATE);
            }
        }
        return new java.sql.Date(date.getTime());
    }

    public static String formatDate(Date date, boolean bl) {
        return SqlDates.formatDate(date, bl ? tz_gmt : tz_lcl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String formatDate(Date date, TimeZone timeZone) {
        String string;
        DateFormat dateFormat = df_d_val;
        synchronized (dateFormat) {
            df_d_val.setTimeZone(timeZone);
            string = df_d_val.format(date);
        }
        return string;
    }

    public static String formatDateLit(Date date, boolean bl) {
        return SqlDates.formatDateLit(date, bl ? tz_gmt : tz_lcl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String formatDateLit(Date date, TimeZone timeZone) {
        String string;
        DateFormat dateFormat = df_d_lit;
        synchronized (dateFormat) {
            df_d_lit.setTimeZone(timeZone);
            string = df_d_lit.format(date);
        }
        return string;
    }

    public static Timestamp parseTimestamp(String string, boolean bl) throws SqlEx {
        return SqlDates.parseTimestamp(string, bl ? tz_gmt : tz_lcl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Timestamp parseTimestamp(String string, TimeZone timeZone) throws SqlEx {
        Date date;
        if (string.length() != TS_FMT.length()) {
            throw SqlEx.get(ERR_GC401B_INVALID_DATE);
        }
        DateFormat dateFormat = df_ts_val;
        synchronized (dateFormat) {
            df_ts_val.setTimeZone(timeZone);
            try {
                date = df_ts_val.parse(string);
            }
            catch (Exception exception) {
                throw SqlEx.get(ERR_GC401B_INVALID_DATE);
            }
        }
        return new Timestamp(date.getTime());
    }

    public static String formatTimestamp(Date date, boolean bl) {
        return SqlDates.formatTimestamp(date, bl ? tz_gmt : tz_lcl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String formatTimestamp(Date date, TimeZone timeZone) {
        String string;
        DateFormat dateFormat = df_ts_val;
        synchronized (dateFormat) {
            df_ts_val.setTimeZone(timeZone);
            string = df_ts_val.format(date);
        }
        return string;
    }

    public static String formatTimestampLit(Date date, boolean bl) {
        return SqlDates.formatTimestampLit(date, bl ? tz_gmt : tz_lcl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String formatTimestampLit(Date date, TimeZone timeZone) {
        String string;
        DateFormat dateFormat = df_ts_lit;
        synchronized (dateFormat) {
            df_ts_lit.setTimeZone(timeZone);
            string = df_ts_lit.format(date);
        }
        return string;
    }

    private SqlDates() {
    }
}

