/*
 * Decompiled with CFR 0.152.
 */
package com.ingres.gcf.util;

import com.ingres.gcf.util.GcfErr;
import com.ingres.gcf.util.SqlEx;
import java.io.ByteArrayInputStream;
import java.io.CharArrayReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.TimeZone;

public class SqlData
implements GcfErr {
    private boolean is_null = true;

    public static int getSqlType(Object object) throws SqlEx {
        if (object == null) {
            return 0;
        }
        if (object instanceof String) {
            return 12;
        }
        if (object instanceof Boolean) {
            return 16;
        }
        if (object instanceof Byte) {
            return -6;
        }
        if (object instanceof Short) {
            return 5;
        }
        if (object instanceof Integer) {
            return 4;
        }
        if (object instanceof Long) {
            return -5;
        }
        if (object instanceof Float) {
            return 7;
        }
        if (object instanceof Double) {
            return 8;
        }
        if (object instanceof BigDecimal) {
            return 3;
        }
        if (object instanceof Reader) {
            return -1;
        }
        if (object instanceof InputStream) {
            return -4;
        }
        if (object instanceof Blob) {
            return 2004;
        }
        if (object instanceof Clob) {
            return 2005;
        }
        if (object instanceof Date) {
            return 91;
        }
        if (object instanceof Time) {
            return 92;
        }
        if (object instanceof Timestamp) {
            return 93;
        }
        Class<?> clazz = object.getClass();
        if (clazz.isArray()) {
            if (clazz.getComponentType() == Character.TYPE) {
                return 1;
            }
            if (clazz.getComponentType() == Byte.TYPE) {
                return -2;
            }
        }
        throw SqlEx.get(ERR_GC401A_CONVERSION_ERR);
    }

    public static InputStream getBinary(byte[] byArray, int n, int n2) throws SqlEx {
        return new ByteArrayInputStream(byArray, n, n2);
    }

    public static InputStream getAscii(String string) throws SqlEx {
        byte[] byArray;
        try {
            byArray = string.getBytes("US-ASCII");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw SqlEx.get(ERR_GC401E_CHAR_ENCODE);
        }
        return new ByteArrayInputStream(byArray);
    }

    public static InputStream getUnicode(String string) throws SqlEx {
        byte[] byArray;
        try {
            byArray = string.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw SqlEx.get(ERR_GC401E_CHAR_ENCODE);
        }
        return new ByteArrayInputStream(byArray);
    }

    public static Reader getCharacter(char[] cArray, int n, int n2) throws SqlEx {
        return new CharArrayReader(cArray, n, n2);
    }

    public static Reader getCharacter(String string) throws SqlEx {
        return new StringReader(string);
    }

    public static Reader cnvtAscii(InputStream inputStream) throws SqlEx {
        try {
            return new InputStreamReader(inputStream, "US-ASCII");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw SqlEx.get(ERR_GC401E_CHAR_ENCODE);
        }
    }

    public static Reader cnvtUnicode(InputStream inputStream) throws SqlEx {
        try {
            return new InputStreamReader(inputStream, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw SqlEx.get(ERR_GC401E_CHAR_ENCODE);
        }
    }

    protected SqlData(boolean bl) {
        this.is_null = bl;
    }

    public String toString() {
        String string;
        try {
            string = this.getString();
        }
        catch (SqlEx sqlEx) {
            string = super.toString();
        }
        return string;
    }

    public boolean isNull() {
        return this.is_null;
    }

    public void setNull() {
        this.is_null = true;
    }

    protected void setNotNull() {
        this.is_null = false;
    }

    public boolean isTruncated() {
        return false;
    }

    public int getDataSize() {
        return -1;
    }

    public int getTruncSize() {
        return 0;
    }

    protected void setScale(int n) throws SqlEx {
    }

    private void setObject(Object object, boolean bl, int n) throws SqlEx {
        switch (SqlData.getSqlType(object)) {
            case 0: {
                this.setNull();
                break;
            }
            case 16: {
                this.setBoolean((Boolean)object);
                break;
            }
            case -6: {
                this.setByte((Byte)object);
                break;
            }
            case 5: {
                this.setShort((Short)object);
                break;
            }
            case 4: {
                this.setInt((Integer)object);
                break;
            }
            case -5: {
                this.setLong((Long)object);
                break;
            }
            case 7: {
                this.setFloat(((Float)object).floatValue());
                break;
            }
            case 8: {
                this.setDouble((Double)object);
                break;
            }
            case -2: {
                this.setBytes((byte[])object);
                break;
            }
            case -4: {
                this.setBinaryStream((InputStream)object);
                break;
            }
            case 2004: {
                this.setBlob((Blob)object);
                break;
            }
            case 1: {
                this.setString(new String((char[])object));
                break;
            }
            case 12: {
                this.setString((String)object);
                break;
            }
            case -1: {
                this.setCharacterStream((Reader)object);
                break;
            }
            case 2005: {
                this.setClob((Clob)object);
                break;
            }
            case 91: {
                this.setDate((Date)object, null);
                break;
            }
            case 92: {
                this.setTime((Time)object, null);
                break;
            }
            case 93: {
                this.setTimestamp((Timestamp)object, null);
                break;
            }
            case 3: {
                if (!bl) {
                    this.setBigDecimal((BigDecimal)object);
                    break;
                }
                this.setBigDecimal((BigDecimal)object, n);
                bl = false;
                break;
            }
            default: {
                throw SqlEx.get(ERR_GC401A_CONVERSION_ERR);
            }
        }
        if (bl) {
            this.setScale(n);
        }
    }

    public void setBoolean(boolean bl) throws SqlEx {
        throw SqlEx.get(ERR_GC401A_CONVERSION_ERR);
    }

    public void setByte(byte by) throws SqlEx {
        throw SqlEx.get(ERR_GC401A_CONVERSION_ERR);
    }

    public void setShort(short s) throws SqlEx {
        throw SqlEx.get(ERR_GC401A_CONVERSION_ERR);
    }

    public void setInt(int n) throws SqlEx {
        throw SqlEx.get(ERR_GC401A_CONVERSION_ERR);
    }

    public void setLong(long l) throws SqlEx {
        throw SqlEx.get(ERR_GC401A_CONVERSION_ERR);
    }

    public void setFloat(float f) throws SqlEx {
        throw SqlEx.get(ERR_GC401A_CONVERSION_ERR);
    }

    public void setDouble(double d) throws SqlEx {
        throw SqlEx.get(ERR_GC401A_CONVERSION_ERR);
    }

    public void setBigDecimal(BigDecimal bigDecimal) throws SqlEx {
        throw SqlEx.get(ERR_GC401A_CONVERSION_ERR);
    }

    public void setString(String string) throws SqlEx {
        throw SqlEx.get(ERR_GC401A_CONVERSION_ERR);
    }

    public void setBytes(byte[] byArray) throws SqlEx {
        throw SqlEx.get(ERR_GC401A_CONVERSION_ERR);
    }

    public void setDate(Date date, TimeZone timeZone) throws SqlEx {
        throw SqlEx.get(ERR_GC401A_CONVERSION_ERR);
    }

    public void setTime(Time time, TimeZone timeZone) throws SqlEx {
        throw SqlEx.get(ERR_GC401A_CONVERSION_ERR);
    }

    public void setTimestamp(Timestamp timestamp, TimeZone timeZone) throws SqlEx {
        throw SqlEx.get(ERR_GC401A_CONVERSION_ERR);
    }

    public void setBinaryStream(InputStream inputStream) throws SqlEx {
        throw SqlEx.get(ERR_GC401A_CONVERSION_ERR);
    }

    public void setAsciiStream(InputStream inputStream) throws SqlEx {
        throw SqlEx.get(ERR_GC401A_CONVERSION_ERR);
    }

    public void setUnicodeStream(InputStream inputStream) throws SqlEx {
        throw SqlEx.get(ERR_GC401A_CONVERSION_ERR);
    }

    public void setCharacterStream(Reader reader) throws SqlEx {
        throw SqlEx.get(ERR_GC401A_CONVERSION_ERR);
    }

    public void setBlob(Blob blob) throws SqlEx {
        throw SqlEx.get(ERR_GC401A_CONVERSION_ERR);
    }

    public void setClob(Clob clob) throws SqlEx {
        throw SqlEx.get(ERR_GC401A_CONVERSION_ERR);
    }

    public boolean getBoolean() throws SqlEx {
        throw SqlEx.get(ERR_GC401A_CONVERSION_ERR);
    }

    public byte getByte() throws SqlEx {
        throw SqlEx.get(ERR_GC401A_CONVERSION_ERR);
    }

    public short getShort() throws SqlEx {
        throw SqlEx.get(ERR_GC401A_CONVERSION_ERR);
    }

    public int getInt() throws SqlEx {
        throw SqlEx.get(ERR_GC401A_CONVERSION_ERR);
    }

    public long getLong() throws SqlEx {
        throw SqlEx.get(ERR_GC401A_CONVERSION_ERR);
    }

    public float getFloat() throws SqlEx {
        throw SqlEx.get(ERR_GC401A_CONVERSION_ERR);
    }

    public double getDouble() throws SqlEx {
        throw SqlEx.get(ERR_GC401A_CONVERSION_ERR);
    }

    public BigDecimal getBigDecimal() throws SqlEx {
        throw SqlEx.get(ERR_GC401A_CONVERSION_ERR);
    }

    public String getString() throws SqlEx {
        throw SqlEx.get(ERR_GC401A_CONVERSION_ERR);
    }

    public byte[] getBytes() throws SqlEx {
        throw SqlEx.get(ERR_GC401A_CONVERSION_ERR);
    }

    public Date getDate(TimeZone timeZone) throws SqlEx {
        throw SqlEx.get(ERR_GC401A_CONVERSION_ERR);
    }

    public Time getTime(TimeZone timeZone) throws SqlEx {
        throw SqlEx.get(ERR_GC401A_CONVERSION_ERR);
    }

    public Timestamp getTimestamp(TimeZone timeZone) throws SqlEx {
        throw SqlEx.get(ERR_GC401A_CONVERSION_ERR);
    }

    public InputStream getBinaryStream() throws SqlEx {
        throw SqlEx.get(ERR_GC401A_CONVERSION_ERR);
    }

    public InputStream getAsciiStream() throws SqlEx {
        throw SqlEx.get(ERR_GC401A_CONVERSION_ERR);
    }

    public InputStream getUnicodeStream() throws SqlEx {
        throw SqlEx.get(ERR_GC401A_CONVERSION_ERR);
    }

    public Reader getCharacterStream() throws SqlEx {
        throw SqlEx.get(ERR_GC401A_CONVERSION_ERR);
    }

    public Blob getBlob() throws SqlEx {
        throw SqlEx.get(ERR_GC401A_CONVERSION_ERR);
    }

    public Clob getClob() throws SqlEx {
        throw SqlEx.get(ERR_GC401A_CONVERSION_ERR);
    }

    public Object getObject() throws SqlEx {
        throw SqlEx.get(ERR_GC401A_CONVERSION_ERR);
    }

    public void setBigDecimal(BigDecimal bigDecimal, int n) throws SqlEx {
        this.setBigDecimal(bigDecimal);
    }

    public void setObject(Object object) throws SqlEx {
        this.setObject(object, false, 0);
    }

    public void setObject(Object object, int n) throws SqlEx {
        this.setObject(object, true, n);
    }

    public BigDecimal getBigDecimal(int n) throws SqlEx {
        BigDecimal bigDecimal = this.getBigDecimal();
        return bigDecimal == null ? null : bigDecimal.setScale(n, 4);
    }

    public String getString(int n) throws SqlEx {
        return this.getString();
    }

    public byte[] getBytes(int n) throws SqlEx {
        return this.getBytes();
    }

    public Object getObject(int n) throws SqlEx {
        return this.getObject();
    }
}

