/*
 * Decompiled with CFR 0.152.
 */
package com.ingres.gcf.util;

import com.ingres.gcf.util.ByteBuffer;
import com.ingres.gcf.util.GcfErr;
import com.ingres.gcf.util.SqlEx;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.Blob;
import java.sql.SQLException;

public class BufferedBlob
implements Blob,
GcfErr {
    private ByteBuffer buff = null;

    public BufferedBlob() {
        this.buff = new ByteBuffer();
    }

    public BufferedBlob(int n) {
        this.buff = new ByteBuffer(n);
    }

    public BufferedBlob(InputStream inputStream) {
        this.buff = new ByteBuffer(inputStream);
    }

    public BufferedBlob(int n, InputStream inputStream) {
        this.buff = new ByteBuffer(n, inputStream);
    }

    public BufferedBlob(ByteBuffer byteBuffer) {
        this.buff = byteBuffer;
    }

    public long length() throws SQLException {
        return this.buff.length();
    }

    public InputStream getBinaryStream() throws SQLException {
        return this.buff.getIS();
    }

    public byte[] getBytes(long l, int n) throws SQLException {
        if (l < 1L || n < 0) {
            throw SqlEx.get(ERR_GC4010_PARAM_VALUE);
        }
        long l2 = this.buff.length();
        l = Math.min(l - 1L, l2);
        n = (int)Math.max(0L, Math.min(l2 - l, (long)n));
        byte[] byArray = new byte[n];
        if (n > 0 && (int)this.buff.read(l, byArray, 0, n) != n) {
            throw SqlEx.get(ERR_GC4010_PARAM_VALUE);
        }
        return byArray;
    }

    public long position(byte[] byArray, long l) throws SQLException {
        if (byArray == null || l < 1L) {
            throw SqlEx.get(ERR_GC4010_PARAM_VALUE);
        }
        return (l = this.buff.find(byArray, l - 1L)) >= 0L ? l + 1L : -1L;
    }

    public long position(Blob blob, long l) throws SQLException {
        long l2;
        if (blob == null || (l2 = blob.length()) > Integer.MAX_VALUE) {
            throw SqlEx.get(ERR_GC4010_PARAM_VALUE);
        }
        return this.position(blob.getBytes(1L, (int)l2), l);
    }

    public int setBytes(long l, byte[] byArray) throws SQLException {
        if (byArray == null) {
            throw SqlEx.get(ERR_GC4010_PARAM_VALUE);
        }
        return this.setBytes(l, byArray, 0, byArray.length);
    }

    public int setBytes(long l, byte[] byArray, int n, int n2) throws SQLException {
        if (byArray == null || n2 < 0 || l < 1L || l > this.buff.length() + 1L || n < 0 || n > byArray.length) {
            throw SqlEx.get(ERR_GC4010_PARAM_VALUE);
        }
        return (int)this.buff.write(l - 1L, byArray, n, n2);
    }

    public OutputStream setBinaryStream(long l) throws SQLException {
        OutputStream outputStream = this.buff.getOS(l - 1L);
        if (outputStream == null) {
            throw SqlEx.get(ERR_GC4010_PARAM_VALUE);
        }
        return outputStream;
    }

    public void truncate(long l) throws SQLException {
        if (l < 0L) {
            throw SqlEx.get(ERR_GC4010_PARAM_VALUE);
        }
        this.buff.truncate(l);
    }
}

