/*
 * Decompiled with CFR 0.152.
 */
package com.ingres.gcf.jdbc;

import com.ingres.gcf.dam.MsgConn;
import com.ingres.gcf.dam.MsgConst;
import com.ingres.gcf.jdbc.DrvConn;
import com.ingres.gcf.jdbc.DrvTrace;
import com.ingres.gcf.util.DbmsConst;
import com.ingres.gcf.util.GcfErr;
import com.ingres.gcf.util.IdMap;
import com.ingres.gcf.util.SqlEx;
import java.math.BigDecimal;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;

public class JdbcRSMD
implements ResultSetMetaData,
MsgConst,
DbmsConst,
GcfErr {
    public short count = 0;
    public Desc[] desc;
    private DrvTrace trace = null;
    private String title = null;
    private String tr_id = null;
    private static int inst_count = 0;

    static JdbcRSMD load(DrvConn drvConn) throws SqlEx {
        MsgConn msgConn = drvConn.msg;
        short s = msgConn.readShort();
        JdbcRSMD jdbcRSMD = new JdbcRSMD(s, drvConn.trace);
        for (short s2 = 0; s2 < s; s2 = (short)(s2 + 1)) {
            int n = msgConn.readShort();
            int n2 = msgConn.readShort();
            short s3 = msgConn.readShort();
            byte by = msgConn.readByte();
            byte by2 = msgConn.readByte();
            byte by3 = msgConn.readByte();
            String string = msgConn.readString();
            switch (n) {
                case -1: {
                    switch (n2) {
                        case 29: 
                        case 36: {
                            n = 2005;
                        }
                    }
                    break;
                }
                case -4: {
                    switch (n2) {
                        case 35: {
                            n = 2004;
                        }
                    }
                    break;
                }
                case 93: {
                    if (n2 != 0) break;
                    n2 = 3;
                    break;
                }
                case 10: {
                    n = 12;
                    s3 = (short)(n2 == 33 ? 8 : 24);
                    by2 = 0;
                    by = 0;
                }
            }
            jdbcRSMD.desc[s2].name = string;
            jdbcRSMD.desc[s2].sql_type = n;
            jdbcRSMD.desc[s2].dbms_type = (short)n2;
            jdbcRSMD.desc[s2].length = s3;
            jdbcRSMD.desc[s2].precision = by;
            jdbcRSMD.desc[s2].scale = by2;
            jdbcRSMD.desc[s2].flags = by3;
        }
        return jdbcRSMD;
    }

    JdbcRSMD(short n, DrvTrace drvTrace) {
        this.count = n;
        this.trace = drvTrace;
        this.desc = new Desc[n];
        for (int i = 0; i < n; ++i) {
            this.desc[i] = new Desc();
        }
        this.title = drvTrace.getTraceName() + "-ResultSetMetaData[" + inst_count + "]";
        this.tr_id = "RSMD[" + inst_count + "]";
        ++inst_count;
    }

    public String toString() {
        return this.title;
    }

    public void reload(DrvConn drvConn) throws SqlEx {
        MsgConn msgConn = drvConn.msg;
        short s = msgConn.readShort();
        short s2 = (short)Math.min(s, this.count);
        if (s != this.count) {
            this.resize(s);
        }
        for (short s3 = 0; s3 < this.count; s3 = (short)(s3 + 1)) {
            int n = msgConn.readShort();
            short s4 = msgConn.readShort();
            short s5 = msgConn.readShort();
            byte by = msgConn.readByte();
            byte by2 = msgConn.readByte();
            byte by3 = msgConn.readByte();
            String string = msgConn.readString();
            switch (n) {
                case -1: {
                    switch (s4) {
                        case 29: 
                        case 36: {
                            n = 2005;
                        }
                    }
                    break;
                }
                case -4: {
                    switch (s4) {
                        case 35: {
                            n = 2004;
                        }
                    }
                    break;
                }
                case 93: {
                    if (s4 != 0) break;
                    s4 = 3;
                    break;
                }
                case 10: {
                    n = 12;
                    s5 = (short)(s4 == 33 ? 8 : 15);
                    by2 = 0;
                    by = 0;
                }
            }
            if (s3 < s2 && this.trace.enabled(5)) {
                if (n != this.desc[s3].sql_type) {
                    this.trace.write(this.tr_id + ": reload[" + s3 + "] sql_type " + this.desc[s3].sql_type + " => " + n);
                }
                if (s4 != this.desc[s3].dbms_type) {
                    this.trace.write(this.tr_id + ": reload[" + s3 + "] dbms_type " + this.desc[s3].dbms_type + " => " + s4);
                }
                if (s5 != this.desc[s3].length) {
                    this.trace.write(this.tr_id + ": reload[" + s3 + "] length " + this.desc[s3].length + " => " + s5);
                }
                if (by != this.desc[s3].precision) {
                    this.trace.write(this.tr_id + ": reload[" + s3 + "] precision " + this.desc[s3].precision + " => " + by);
                }
                if (by2 != this.desc[s3].scale) {
                    this.trace.write(this.tr_id + ": reload[" + s3 + "] scale " + this.desc[s3].scale + " => " + by2);
                }
                if (by3 != this.desc[s3].flags) {
                    this.trace.write(this.tr_id + ": reload[" + s3 + "] flags " + this.desc[s3].flags + " => " + by3);
                }
            }
            this.desc[s3].name = string;
            this.desc[s3].sql_type = n;
            this.desc[s3].dbms_type = s4;
            this.desc[s3].length = s5;
            this.desc[s3].precision = by;
            this.desc[s3].scale = by2;
            this.desc[s3].flags = by3;
        }
    }

    public void setColumnInfo(String string, int n, int n2, short s, short s2, byte by, byte by2, boolean bl) throws SqlEx {
        n = this.columnMap(n);
        this.desc[n].name = string;
        this.desc[n].sql_type = n2;
        this.desc[n].dbms_type = s;
        this.desc[n].length = s2;
        this.desc[n].precision = by;
        this.desc[n].scale = by2;
        this.desc[n].flags = bl ? (byte)1 : 0;
    }

    public int getColumnCount() throws SQLException {
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".getColumnCount: " + this.count);
        }
        return this.count;
    }

    public String getColumnName(int n) throws SQLException {
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".getColumnName( " + n + " )");
        }
        n = this.columnMap(n);
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".getColumnName: " + this.desc[n].name);
        }
        return this.desc[n].name;
    }

    public String getColumnLabel(int n) throws SQLException {
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".getColumnLabel( " + n + " )");
        }
        n = this.columnMap(n);
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".getColumnLabel: " + this.desc[n].name);
        }
        return this.desc[n].name;
    }

    public String getTableName(int n) throws SQLException {
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".getTableName( " + n + " )");
        }
        n = this.columnMap(n);
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".getTableName: ''");
        }
        return "";
    }

    public String getSchemaName(int n) throws SQLException {
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".getSchemaName( " + n + " )");
        }
        n = this.columnMap(n);
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".getSchemaName: ''");
        }
        return "";
    }

    public String getCatalogName(int n) throws SQLException {
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".getCatalogName( " + n + " )");
        }
        n = this.columnMap(n);
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".getCatalogName: ''");
        }
        return "";
    }

    public int getColumnType(int n) throws SQLException {
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".getColumnType( " + n + " )");
        }
        n = this.columnMap(n);
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".getColumnType: " + this.desc[n].sql_type);
        }
        return this.desc[n].sql_type;
    }

    public String getColumnTypeName(int n) throws SQLException {
        String string = null;
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".getColumnTypeName( " + n + " )");
        }
        n = this.columnMap(n);
        switch (this.desc[n].dbms_type) {
            case 30: {
                string = IdMap.get(this.desc[n].length, intMap);
                break;
            }
            case 31: {
                string = IdMap.get(this.desc[n].length, floatMap);
                break;
            }
            default: {
                string = IdMap.get(this.desc[n].dbms_type, typeMap);
            }
        }
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".getColumnTypeName: " + string);
        }
        return string;
    }

    public String getColumnClassName(int n) throws SQLException {
        Class<Object> clazz = Object.class;
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".getColumnClassName( " + n + " )");
        }
        n = this.columnMap(n);
        switch (this.desc[n].sql_type) {
            case -7: 
            case 16: {
                clazz = Boolean.class;
                break;
            }
            case -6: 
            case 4: 
            case 5: {
                clazz = Integer.class;
                break;
            }
            case -5: {
                clazz = Long.class;
                break;
            }
            case 7: {
                clazz = Float.class;
                break;
            }
            case 6: 
            case 8: {
                clazz = Double.class;
                break;
            }
            case 2: 
            case 3: {
                clazz = BigDecimal.class;
                break;
            }
            case -1: 
            case 1: 
            case 12: {
                clazz = String.class;
                break;
            }
            case -4: 
            case -3: 
            case -2: {
                clazz = byte[].class;
                break;
            }
            case 91: {
                clazz = Date.class;
                break;
            }
            case 92: {
                clazz = Time.class;
                break;
            }
            case 93: {
                clazz = Timestamp.class;
                break;
            }
            case 2005: {
                clazz = Clob.class;
                break;
            }
            case 2004: {
                clazz = Blob.class;
                break;
            }
            default: {
                if (this.trace.enabled(1)) {
                    this.trace.write(this.title + ": invalid SQL type " + this.desc[n].sql_type);
                }
                throw SqlEx.get(ERR_GC4002_PROTOCOL_ERR);
            }
        }
        String string = clazz.getName();
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".getColumnClassName: " + string);
        }
        return string;
    }

    public int getPrecision(int n) throws SQLException {
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".getPrecision( " + n + " )");
        }
        n = this.columnMap(n);
        int n2 = 0;
        block0 : switch (this.desc[n].sql_type) {
            case 91: {
                n2 = 10;
                break;
            }
            case 92: {
                n2 = 8;
                break;
            }
            case 93: {
                n2 = 29;
                break;
            }
            case -6: {
                n2 = 3;
                break;
            }
            case 5: {
                n2 = 5;
                break;
            }
            case 4: {
                n2 = 10;
                break;
            }
            case -5: {
                n2 = 19;
                break;
            }
            case 7: {
                n2 = 7;
                break;
            }
            case 6: 
            case 8: {
                n2 = 15;
                break;
            }
            case 2: 
            case 3: {
                n2 = this.desc[n].precision;
                break;
            }
            case -3: 
            case -2: {
                n2 = this.desc[n].length;
                break;
            }
            case 1: {
                switch (this.desc[n].dbms_type) {
                    case 26: {
                        n2 = this.desc[n].length / 2;
                        break block0;
                    }
                }
                n2 = this.desc[n].length;
                break;
            }
            case 12: {
                switch (this.desc[n].dbms_type) {
                    case 27: {
                        n2 = this.desc[n].length / 2;
                        break block0;
                    }
                }
                n2 = this.desc[n].length;
            }
        }
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".getPrecision: " + n2);
        }
        return n2;
    }

    public int getScale(int n) throws SQLException {
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".getScale( " + n + " )");
        }
        n = this.columnMap(n);
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".getScale: " + this.desc[n].scale);
        }
        return this.desc[n].scale;
    }

    public int getColumnDisplaySize(int n) throws SQLException {
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".getColumnDisplaySize( " + n + " )");
        }
        n = this.columnMap(n);
        int n2 = 0;
        switch (this.desc[n].sql_type) {
            case -7: 
            case 16: {
                n2 = 5;
                break;
            }
            case -6: {
                n2 = 4;
                break;
            }
            case 5: {
                n2 = 6;
                break;
            }
            case 4: {
                n2 = 11;
                break;
            }
            case -5: {
                n2 = 20;
                break;
            }
            case 7: {
                n2 = 14;
                break;
            }
            case 6: 
            case 8: {
                n2 = 24;
                break;
            }
            case 91: {
                n2 = 10;
                break;
            }
            case 92: {
                n2 = 8;
                break;
            }
            case 93: {
                n2 = 29;
                break;
            }
            case -3: 
            case -2: {
                n2 = this.desc[n].length;
                break;
            }
            case -4: 
            case -1: 
            case 2004: 
            case 2005: {
                n2 = 0;
                break;
            }
            case 2: 
            case 3: {
                n2 = this.desc[n].precision + 1;
                if (this.desc[n].scale <= 0) break;
                ++n2;
                break;
            }
            case 1: {
                n2 = this.desc[n].length;
                if (this.desc[n].dbms_type != 26) break;
                n2 /= 2;
                break;
            }
            case 12: {
                n2 = this.desc[n].length;
                if (this.desc[n].dbms_type != 27) break;
                n2 /= 2;
            }
        }
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".getColumnDisplaySize: " + n2);
        }
        return n2;
    }

    public int isNullable(int n) throws SQLException {
        int n2;
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".isNullable( " + n + " )");
        }
        n = this.columnMap(n);
        int n3 = n2 = (this.desc[n].flags & 1) != 0 ? 1 : 0;
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".isNullable: " + n2);
        }
        return n2;
    }

    public boolean isSearchable(int n) throws SQLException {
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".isSearchable( " + n + " )");
        }
        n = this.columnMap(n);
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".isSearchable: " + true);
        }
        return true;
    }

    public boolean isCaseSensitive(int n) throws SQLException {
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".isCaseSensitive( " + n + " )");
        }
        n = this.columnMap(n);
        boolean bl = false;
        switch (this.desc[n].sql_type) {
            case -1: 
            case 1: 
            case 12: 
            case 2005: {
                bl = true;
            }
        }
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".isCaseSensitive: " + bl);
        }
        return bl;
    }

    public boolean isSigned(int n) throws SQLException {
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".isSigned( " + n + " )");
        }
        n = this.columnMap(n);
        boolean bl = false;
        switch (this.desc[n].sql_type) {
            case -6: 
            case -5: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                bl = true;
            }
        }
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".isSigned: " + bl);
        }
        return bl;
    }

    public boolean isCurrency(int n) throws SQLException {
        boolean bl;
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".isCurrency( " + n + " )");
        }
        n = this.columnMap(n);
        boolean bl2 = bl = this.desc[n].dbms_type == 5;
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".isCurrency: " + bl);
        }
        return bl;
    }

    public boolean isAutoIncrement(int n) throws SQLException {
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".isAutoIncrement( " + n + " )");
        }
        n = this.columnMap(n);
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".isAutoIncrement: " + false);
        }
        return false;
    }

    public boolean isReadOnly(int n) throws SQLException {
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".isReadOnly( " + n + " )");
        }
        n = this.columnMap(n);
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".isReadOnly: " + false);
        }
        return false;
    }

    public boolean isWritable(int n) throws SQLException {
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".isWritable( " + n + " )");
        }
        n = this.columnMap(n);
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".isWritable: " + true);
        }
        return true;
    }

    public boolean isDefinitelyWritable(int n) throws SQLException {
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".isDefinitelyWritable( " + n + " )");
        }
        n = this.columnMap(n);
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".isDefinitelyWritable: " + true);
        }
        return true;
    }

    public int getParameterMode(int n) throws SQLException {
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".getParameterMode( " + n + " )");
        }
        n = this.columnMap(n);
        int n2 = 0;
        if ((this.desc[n].flags & 4) != 0) {
            n2 = 2;
        } else if ((this.desc[n].flags & 2) != 0) {
            n2 = (this.desc[n].flags & 0x10) != 0 ? 2 : 1;
        } else if ((this.desc[n].flags & 0x10) != 0) {
            n2 = 4;
        }
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".getParameterMode: " + n2);
        }
        return n2;
    }

    private void resize(short s) {
        if (s == this.count) {
            return;
        }
        Desc[] descArray = new Desc[s];
        if (this.trace.enabled(4)) {
            this.trace.write(this.tr_id + ": resize " + this.count + " to " + s);
        }
        for (short s2 = 0; s2 < s; s2 = (short)(s2 + 1)) {
            descArray[s2] = s2 < this.count ? this.desc[s2] : new Desc();
        }
        this.count = s;
        this.desc = descArray;
    }

    private int columnMap(int n) throws SqlEx {
        if (n < 1 || n > this.count) {
            throw SqlEx.get(ERR_GC4011_INDEX_RANGE);
        }
        return n - 1;
    }

    static class Desc {
        int sql_type = 1111;
        short dbms_type = 0;
        short length = 0;
        byte precision = 0;
        byte scale = 0;
        byte flags = 0;
        String name = null;

        Desc() {
        }
    }
}

