<%--
  ~ Copyright (C) 2005 - 2011 Jaspersoft Corporation. All rights reserved.
  ~ http://www.jaspersoft.com.
  ~
  ~ Unless you have purchased  a commercial license agreement from Jaspersoft,
  ~ the following license terms  apply:
  ~
  ~ This program is free software: you can redistribute it and/or  modify
  ~ it under the terms of the GNU Affero General Public License  as
  ~ published by the Free Software Foundation, either version 3 of  the
  ~ License, or (at your option) any later version.
  ~
  ~ This program is distributed in the hope that it will be useful,
  ~ but WITHOUT ANY WARRANTY; without even the implied warranty of
  ~ MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
  ~ GNU Affero  General Public License for more details.
  ~
  ~ You should have received a copy of the GNU Affero General Public  License
  ~ along with this program. If not, see <http://www.gnu.org/licenses/>.
  --%>

<%--
Overview:
    Nothing To Display. Used to communicate to user that empty display is not an error.

Usage:
    <t:insertTemplate template="/WEB-INF/jsp/modules/templates/#nothingToDisplay.jsp">
        <t:putAttribute name="bodyContent"></t:putAttribute>
    </t:insertTemplate>
    
--%>

<%@ taglib prefix="t" uri="http://tiles.apache.org/tags-tiles" %>
<%@ taglib uri="http://www.springframework.org/tags" prefix="spring"%>
<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core" %>

<%@ page import="com.jaspersoft.jasperserver.api.JSException" %>

<!--/WEB-INF/jsp/modules/templates/#nothingToDisplay.jsp revision A-->
<t:useAttribute id="bodyContent" name="bodyContent" classname="java.lang.String" ignore="true"/>
<t:useAttribute id="containerID" name="containerID" classname="java.lang.String" ignore="true"/>

<t:insertTemplate template="/WEB-INF/jsp/modules/templates/container.jsp">
	<t:putAttribute name="containerClass" value="panel info nothingToDisplay centered_vert centered_horz hidden"/>
	<t:putAttribute name="containerID" value="${not empty containerID ? containerID : 'nothingToDisplay'}"/>
    <t:putAttribute name="bodyContent">
		${bodyContent}
    </t:putAttribute>
</t:insertTemplate>