/*
 * Copyright (C) 2005 - 2011 Jaspersoft Corporation. All rights reserved.
 * http://www.jaspersoft.com.
 *
 * Unless you have purchased  a commercial license agreement from Jaspersoft,
 * the following license terms  apply:
 *
 * This program is free software: you can redistribute it and/or  modify
 * it under the terms of the GNU Affero General Public License  as
 * published by the Free Software Foundation, either version 3 of  the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU Affero  General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public  License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */

package com.jaspersoft.jasperserver.war.tags;

import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

import javax.servlet.jsp.JspException;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.context.MessageSource;
import org.springframework.context.support.ResourceBundleMessageSource;
import org.springframework.context.i18n.LocaleContextHolder;

import com.jaspersoft.jasperserver.war.dto.RuntimeInputControlWrapper;

/**
 * @author Lucian Chirita
 *
 */
public class InputControlLabelTag extends BaseTagSupport {
	
	protected static final Log log = LogFactory.getLog(InputControlLabelTag.class);

	public static final String DEFAULT_LABEL_JSP = "/WEB-INF/jsp/modules/inputControls/InputControlLabel.jsp";
	public static final String INPUT_CONTROL_ATTRIBUTE_NAME = "control";
	public static final String CONTROL_LABEL_ATTRIBUTE_NAME = "controlLabel";
    public static final String KEY_PREAMBLE = "$R{";
    public static final String KEY_POSTAMBLE = "}";

	private RuntimeInputControlWrapper control;
    private MessageSource messageSource;
    private String labelJsp;
	
	protected int doStartTagInternal() {
		return SKIP_BODY;
	}

	public int doEndTag() throws JspException {
		Map attributes = new HashMap();
		attributes.put(INPUT_CONTROL_ATTRIBUTE_NAME, getControl());
        attributes.put(CONTROL_LABEL_ATTRIBUTE_NAME, resolveLabel());
		includeNested(getLabelJsp(), attributes);
		return EVAL_PAGE;
	}


    public String resolveLabel() {
        String promptLabel = control.getControlInfo().getPromptLabel();
        String label = (promptLabel != null && promptLabel.length() > 0) ? promptLabel : control.getInputControl().getLabel();

        Pattern p = Pattern.compile("^\\$R\\{(.+)\\}(.*)$");
        Matcher m = p.matcher(label);
        if (m.matches() && messageSource != null) {

            // matches $R{<supermart.store.store_sqft.label>} is Between
            String labelKey = m.group(1);
            // matches $R{supermart.store.store_sqft.label}< is Between>
            String labelPostfix = m.group(2);

            try {
                label = messageSource.getMessage(labelKey, null, LocaleContextHolder.getLocale());
            } catch (Exception ex) { /* No message. Ok, not a prob... */ }

            label += labelPostfix;
        }

        return label;
    }

	public RuntimeInputControlWrapper getControl() {
		return control;
	}

	public void setControl(RuntimeInputControlWrapper control) {
		this.control = control;
	}

    public void setMessageSource(MessageSource messageSource) {
        this.messageSource = messageSource;
    }

    public String getLabelJsp() {
		String jsp = labelJsp;
		if (jsp == null) {
			jsp = DEFAULT_LABEL_JSP;
		}
		return jsp;
	}

	public void setLabelJsp(String labelJsp) {
		this.labelJsp = labelJsp;
	}
}
