/*
 * Copyright (C) 2005 - 2011 Jaspersoft Corporation. All rights reserved.
 * http://www.jaspersoft.com.
 *
 * Unless you have purchased  a commercial license agreement from Jaspersoft,
 * the following license terms  apply:
 *
 * This program is free software: you can redistribute it and/or  modify
 * it under the terms of the GNU Affero General Public License  as
 * published by the Free Software Foundation, either version 3 of  the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU Affero  General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public  License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */
package com.jaspersoft.jasperserver.war.cascade.token;

import java.util.Map;
import java.util.HashMap;

import com.jaspersoft.jasperserver.api.engine.common.service.IQueryManipulator;

/**
 * QueryFilter
 * @author jwhang
 * @version $Id: QueryFilter.java 19932 2010-12-11 15:24:29Z tmatyashovsky $
 */
public class QueryFilter implements IQueryManipulator {
    private FilterCore filterResolver;

    public QueryFilter(){
    }

    public FilterCore getFilterResolver() {
        return filterResolver;
    }

    public void setFilterResolver(FilterCore filterResolver) {
        this.filterResolver = filterResolver;
    }


    /**
     * try to update parameter map with built-in params
     * if we have missing params, return empty query which will get bypassed
     */
    public String updateQuery(String queryString, Map parameters) {
        Map resolvedParams = getFilterResolver().resolveParameters(queryString, parameters);
        if (resolvedParams == null) {
            queryString = "";
        } else {
            parameters.putAll(resolvedParams);
        }
        return queryString;
    }

}
