/*
 * Copyright (C) 2005 - 2011 Jaspersoft Corporation. All rights reserved.
 * http://www.jaspersoft.com.
 *
 * Unless you have purchased  a commercial license agreement from Jaspersoft,
 * the following license terms  apply:
 *
 * This program is free software: you can redistribute it and/or  modify
 * it under the terms of the GNU Affero General Public License  as
 * published by the Free Software Foundation, either version 3 of  the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU Affero  General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public  License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */
package com.jaspersoft.jasperserver.war.action;

import java.util.Map;

import org.springframework.webflow.core.collection.AttributeMap;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.RequestContext;
import org.springframework.webflow.execution.ScopeType;

import com.jaspersoft.jasperserver.api.engine.scheduling.domain.ReportJob;

/**
 * @author Lucian Chirita (lucianc@users.sourceforge.net)
 * @version $Id: ScheduleReportParametersAction.java 19932 2010-12-11 15:24:29Z tmatyashovsky $
 */
public class ScheduleReportParametersAction extends ReportParametersAction {


    private String jobFormObjectName;
    private Class jobFormObjectClass;
    private ScopeType jobFormObjectScope;

	public Class getJobFormObjectClass() {
		return jobFormObjectClass;
	}

	public void setJobFormObjectClass(Class jobFormObjectClass) {
		this.jobFormObjectClass = jobFormObjectClass;
	}

	public String getJobFormObjectName() {
		return jobFormObjectName;
	}

	public void setJobFormObjectName(String jobFormObjectName) {
		this.jobFormObjectName = jobFormObjectName;
	}

	public ScopeType getJobFormObjectScope() {
		return jobFormObjectScope;
	}

	public void setJobFormObjectScope(ScopeType jobFormObjectScope) {
		this.jobFormObjectScope = jobFormObjectScope;
	}

	public Event checkForParameters(RequestContext context)
	{
        createWrappers(context);

        // the report only has hidden controls
        if (hasInputs(context) && !hasUserInputControls(context)) {
            // set the default values
            Map parameterValues = getParameterValuesForJob(context);
            ReportJob reportJob = getReportJob(context);
            reportJob.getSource().setParametersMap(parameterValues);
        }

        return success();
	}

	public Event setParameterValues(RequestContext context) {
		Map parameterValues = getParameterValuesForJob(context);
		if (parameterValues == null) {
			return error();
		}
		
		ReportJob reportJob = getReportJob(context);
		reportJob.getSource().setParametersMap(parameterValues);

		return success();
	}

	protected Map getParameterValuesForJob(RequestContext context) {
		return getRequestParameterValues(context);
	}

	protected InputValueProvider initialValueProvider(RequestContext context) {
		InputValueProvider provider = baseJobValueProvider(context);
		
		ReportJob reportJob = getReportJob(context);
		Map paramValues = reportJob.getSource().getParametersMap();
		if (paramValues != null && !paramValues.isEmpty()) {
			provider = new MapValueProvider(paramValues, provider);
		}

		return provider;
	}

	protected InputValueProvider baseJobValueProvider(RequestContext context) {
		return defaultValuesProvider(context);
	}
	
	protected ReportJob getReportJob(RequestContext context) {
		AttributeMap scope = getJobFormObjectScope().getScope(context);
		return (ReportJob) scope.getRequired(getJobFormObjectName(), getJobFormObjectClass());
	}

}
